/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.expression.AbstractSqmParameter;
import org.hibernate.query.sqm.tree.expression.SqmParameter;

public class SqmNamedParameter<T>
extends AbstractSqmParameter<T> {
    private final String name;

    public SqmNamedParameter(String name, boolean canBeMultiValued, NodeBuilder nodeBuilder) {
        this(name, canBeMultiValued, null, nodeBuilder);
    }

    public SqmNamedParameter(String name, boolean canBeMultiValued, SqmExpressible<T> inherentType, NodeBuilder nodeBuilder) {
        super(canBeMultiValued, inherentType, nodeBuilder);
        this.name = name;
    }

    @Override
    public SqmNamedParameter<T> copy(SqmCopyContext context) {
        SqmNamedParameter existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmNamedParameter expression = context.registerCopy(this, new SqmNamedParameter(this.name, this.allowMultiValuedBinding(), this.getNodeType(), this.nodeBuilder()));
        this.copyTo(expression, context);
        return expression;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitNamedParameterExpression(this);
    }

    @Override
    public String asLoggableText() {
        return ":" + this.getName();
    }

    public String toString() {
        return "SqmNamedParameter(" + this.getName() + ")";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public SqmParameter<T> copy() {
        return new SqmNamedParameter(this.getName(), this.allowMultiValuedBinding(), this.getNodeType(), this.nodeBuilder());
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        sb.append(':');
        sb.append(this.getName());
    }
}

