/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.automaticindexing.building.impl;

import java.lang.invoke.MethodHandles;
import java.util.Set;
import org.hibernate.search.mapper.pojo.automaticindexing.ReindexOnUpdate;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.AbstractPojoImplicitReindexingResolverTypeNodeBuilder;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.AbstractPojoIndexingDependencyCollectorValueNode;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoImplicitReindexingResolverBuilder;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoImplicitReindexingResolverBuildingHelper;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoImplicitReindexingResolverValueNodeBuilderDelegate;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoIndexingDependencyCollectorTypeNode;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.path.binding.impl.PojoModelPathBinder;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPath;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class PojoIndexingDependencyCollectorDisjointValueNode<V>
extends AbstractPojoIndexingDependencyCollectorValueNode {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoIndexingDependencyCollectorTypeNode<?> parentNode;
    private final PojoRawTypeModel<V> inverseSideEntityTypeModel;
    private final BoundPojoModelPathValueNode<?, ?, ?> inverseAssociationPath;

    PojoIndexingDependencyCollectorDisjointValueNode(PojoIndexingDependencyCollectorTypeNode<?> parentNode, PojoRawTypeModel<V> inverseSideEntityTypeModel, BoundPojoModelPathValueNode<?, ?, ?> inverseAssociationPath, PojoImplicitReindexingResolverBuildingHelper buildingHelper) {
        super(buildingHelper);
        this.parentNode = parentNode;
        this.inverseSideEntityTypeModel = inverseSideEntityTypeModel;
        this.inverseAssociationPath = inverseAssociationPath;
        if (!buildingHelper.isEntity(inverseSideEntityTypeModel)) {
            throw new AssertionFailure("Encountered a type node whose parent is a disjoint value node, but does not represent an entity type?");
        }
        if (!inverseAssociationPath.getRootType().equals(inverseSideEntityTypeModel)) {
            throw new AssertionFailure("Inconsistent root type for " + inverseAssociationPath + "; expected " + inverseSideEntityTypeModel);
        }
    }

    @Override
    public PojoIndexingDependencyCollectorTypeNode<?> type() {
        return new PojoIndexingDependencyCollectorTypeNode<V>(this, BoundPojoModelPath.root(this.inverseSideEntityTypeModel), this.buildingHelper);
    }

    @Override
    PojoIndexingDependencyCollectorTypeNode<?> lastEntityNode() {
        return this.parentNode.lastEntityNode();
    }

    @Override
    ReindexOnUpdate reindexOnUpdate() {
        return this.parentNode.reindexOnUpdate();
    }

    @Override
    void collectDependency(BoundPojoModelPathValueNode<?, ?, ?> dirtyPathFromEntityType) {
        this.parentNode.collectDependency(dirtyPathFromEntityType);
    }

    @Override
    void markForReindexing(AbstractPojoImplicitReindexingResolverTypeNodeBuilder<?, ?> inverseSideEntityTypeNodeBuilder, BoundPojoModelPathValueNode<?, ?, ?> dependencyPathFromInverseSideEntityTypeNode) {
        Set<PojoRawTypeModel<?>> valueNodeTypeConcreteEntitySubTypes;
        PojoImplicitReindexingResolverValueNodeBuilderDelegate valueNodeBuilderDelegate;
        PojoTypeModel<?> inverseSideEntityType = inverseSideEntityTypeNodeBuilder.getTypeModel();
        PojoRawTypeModel<?> inverseSideRawEntityType = inverseSideEntityType.rawType();
        PojoRawTypeModel<?> originalSideRawConcreteEntityType = this.parentNode.typeModel().rawType();
        PojoModelPathValueNode inverseAssociationUnboundPath = this.inverseAssociationPath.toUnboundPath();
        try {
            valueNodeBuilderDelegate = (PojoImplicitReindexingResolverValueNodeBuilderDelegate)PojoModelPathBinder.bind(inverseSideEntityTypeNodeBuilder, inverseAssociationUnboundPath, PojoImplicitReindexingResolverBuilder.walker());
            PojoRawTypeModel inverseSideRawType = valueNodeBuilderDelegate.getTypeModel().rawType();
            valueNodeTypeConcreteEntitySubTypes = this.parentNode.getConcreteEntitySubTypesForTypeToReindex(originalSideRawConcreteEntityType, inverseSideRawType);
        }
        catch (RuntimeException e) {
            throw log.cannotApplyExplicitInverseAssociationPath(inverseSideRawEntityType, inverseAssociationUnboundPath, originalSideRawConcreteEntityType, e.getMessage(), e);
        }
        this.parentNode.markForReindexing(valueNodeBuilderDelegate, valueNodeTypeConcreteEntitySubTypes, dependencyPathFromInverseSideEntityTypeNode);
    }
}

