/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.collector.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SimpleCollector;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorExecutionContext;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorFactory;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorKey;
import org.hibernate.search.backend.lucene.lowlevel.common.impl.MetadataFields;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.IndexReaderMetadataResolver;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneDocumentReference;
import org.hibernate.search.engine.backend.common.DocumentReference;

public final class DocumentReferenceCollector
extends SimpleCollector {
    public static final CollectorKey<DocumentReferenceCollector> KEY = CollectorKey.create();
    public static final CollectorFactory<DocumentReferenceCollector> FACTORY = new CollectorFactory<DocumentReferenceCollector>(){

        @Override
        public DocumentReferenceCollector createCollector(CollectorExecutionContext context) {
            return new DocumentReferenceCollector(context);
        }

        @Override
        public CollectorKey<DocumentReferenceCollector> getCollectorKey() {
            return KEY;
        }
    };
    private final IndexReaderMetadataResolver metadataResolver;
    private String currentLeafMappedTypeName;
    private BinaryDocValues currentLeafIdDocValues;
    private int currentLeafDocBase;
    private Map<Integer, DocumentReference> collected = new HashMap<Integer, DocumentReference>();

    private DocumentReferenceCollector(CollectorExecutionContext executionContext) {
        this.metadataResolver = executionContext.getMetadataResolver();
    }

    public void collect(int doc) throws IOException {
        this.currentLeafIdDocValues.advance(doc);
        this.collected.put(this.currentLeafDocBase + doc, new LuceneDocumentReference(this.currentLeafMappedTypeName, this.currentLeafIdDocValues.binaryValue().utf8ToString()));
    }

    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE_NO_SCORES;
    }

    public DocumentReference get(int doc) {
        return this.collected.get(doc);
    }

    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        this.currentLeafMappedTypeName = this.metadataResolver.resolveMappedTypeName(context);
        this.currentLeafIdDocValues = DocValues.getBinary((LeafReader)context.reader(), (String)MetadataFields.idFieldName());
        this.currentLeafDocBase = context.docBase;
    }
}

