/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.distribution;

import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.MessageRedistributionTest;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.Test;

public class LargeMessageRedistributionTest
extends MessageRedistributionTest {
    @Override
    public boolean isLargeMessage() {
        return true;
    }

    @Test
    public void testRedistributionLargeMessageDirCleanup() throws Exception {
        long delay = 1000L;
        int numMessages = 5;
        this.setRedistributionDelay(1000L);
        this.setupCluster(MessageLoadBalancingType.ON_DEMAND);
        this.startServers(0, 1);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.waitForBindings(0, "queues.testaddress", 1, 0, true);
        this.waitForBindings(1, "queues.testaddress", 1, 0, true);
        this.waitForBindings(0, "queues.testaddress", 1, 0, false);
        this.waitForBindings(1, "queues.testaddress", 1, 0, false);
        this.send(0, "queues.testaddress", 5, true, null);
        this.addConsumer(0, 0, "queue0", null);
        this.verifyReceiveAll(5, 0);
        this.removeConsumer(0);
        this.addConsumer(1, 1, "queue0", null);
        this.verifyReceiveAll(5, 1);
        this.removeConsumer(1);
        Wait.assertEquals((int)0, () -> this.getServer(0).getConfiguration().getLargeMessagesLocation().listFiles().length);
        Wait.assertEquals((int)5, () -> this.getServer(1).getConfiguration().getLargeMessagesLocation().listFiles().length);
    }
}

