/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt.imported;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.server.QueueQueryResult;
import org.apache.activemq.artemis.tests.integration.mqtt.imported.MQTTClientProvider;
import org.apache.activemq.artemis.tests.integration.mqtt.imported.MQTTTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTTFQQNTest
extends MQTTTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(MQTTFQQNTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMQTTSubNames() throws Exception {
        MQTTClientProvider subscriptionProvider = this.getMQTTClientProvider();
        this.initializeConnection(subscriptionProvider);
        try {
            subscriptionProvider.subscribe("foo/bah", 0);
            MQTTFQQNTest.assertEquals((long)1L, (long)this.server.getPostOffice().getAllBindings().count());
            Binding b = (Binding)this.server.getPostOffice().getAllBindings().iterator().next();
            QueueQueryResult result = this.server.queueQuery(b.getUniqueName());
            MQTTFQQNTest.assertTrue((boolean)result.isExists());
            MQTTFQQNTest.assertEquals((Object)result.getAddress(), (Object)new SimpleString("foo.bah"));
            MQTTFQQNTest.assertEquals((Object)b.getUniqueName(), (Object)result.getName());
            result = this.server.queueQuery(new SimpleString("foo.bah::" + b.getUniqueName()));
            MQTTFQQNTest.assertTrue((boolean)result.isExists());
            MQTTFQQNTest.assertEquals((Object)new SimpleString("foo.bah"), (Object)result.getAddress());
            MQTTFQQNTest.assertEquals((Object)b.getUniqueName(), (Object)result.getName());
        }
        finally {
            subscriptionProvider.disconnect();
        }
    }

    @Test(timeout=60000L)
    public void testSendAndReceiveMQTTSpecial1() throws Exception {
        final MQTTClientProvider subscriptionProvider = this.getMQTTClientProvider();
        this.initializeConnection(subscriptionProvider);
        subscriptionProvider.subscribe("foo/bah::", 0);
        final CountDownLatch latch = new CountDownLatch(250);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 250; ++i) {
                    try {
                        byte[] payload = subscriptionProvider.receive(10000);
                        Assert.assertNotNull((String)"Should get a message", (Object)payload);
                        latch.countDown();
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        break;
                    }
                }
            }
        });
        thread.start();
        MQTTClientProvider publishProvider = this.getMQTTClientProvider();
        this.initializeConnection(publishProvider);
        for (int i = 0; i < 250; ++i) {
            String payload = "Message " + i;
            publishProvider.publish("foo/bah", payload.getBytes(), 1);
        }
        latch.await(10L, TimeUnit.SECONDS);
        MQTTFQQNTest.assertEquals((long)0L, (long)latch.getCount());
        subscriptionProvider.disconnect();
        publishProvider.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testSendAndReceiveMQTTSpecial2() throws Exception {
        MQTTClientProvider subscriptionProvider = this.getMQTTClientProvider();
        this.initializeConnection(subscriptionProvider);
        try {
            subscriptionProvider.subscribe("::foo/bah", 0);
            MQTTFQQNTest.fail((String)"should get exception!");
        }
        catch (Exception exception) {
        }
        finally {
            subscriptionProvider.disconnect();
        }
        this.initializeConnection(subscriptionProvider);
        try {
            subscriptionProvider.subscribe("::", 0);
            MQTTFQQNTest.fail((String)"should get exception!");
        }
        catch (Exception exception) {
        }
        finally {
            subscriptionProvider.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMQTTSubNamesSpecial() throws Exception {
        MQTTClientProvider subscriptionProvider = this.getMQTTClientProvider();
        this.initializeConnection(subscriptionProvider);
        try {
            subscriptionProvider.subscribe("foo/bah", 0);
            MQTTFQQNTest.assertEquals((long)1L, (long)this.server.getPostOffice().getAllBindings().count());
            Binding b = (Binding)this.server.getPostOffice().getAllBindings().iterator().next();
            QueueQueryResult result = this.server.queueQuery(new SimpleString("::" + b.getUniqueName()));
            MQTTFQQNTest.assertTrue((boolean)result.isExists());
            MQTTFQQNTest.assertEquals((Object)new SimpleString("foo.bah"), (Object)result.getAddress());
            MQTTFQQNTest.assertEquals((Object)b.getUniqueName(), (Object)result.getName());
            result = this.server.queueQuery(new SimpleString(b.getUniqueName() + "::"));
            MQTTFQQNTest.assertFalse((boolean)result.isExists());
            result = this.server.queueQuery(new SimpleString("::"));
            MQTTFQQNTest.assertFalse((boolean)result.isExists());
        }
        finally {
            subscriptionProvider.disconnect();
        }
    }
}

