/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.Session;
import java.util.Arrays;
import java.util.Collection;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQMessageConsumer;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.command.ActiveMQDestination;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JMSConsumer11Test
extends BasicOpenWireTest {
    public int deliveryMode;

    @Parameterized.Parameters(name="deliveryMode={0}")
    public static Collection<Object[]> getParams() {
        return Arrays.asList({1}, {2});
    }

    public JMSConsumer11Test(int deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    @Test
    public void testPrefetch1MessageNotDispatched() throws Exception {
        this.connection.getPrefetchPolicy().setAll(1);
        this.connection.start();
        Session session = this.connection.createSession(true, 0);
        ActiveMQDestination destination = this.createDestination(session, (byte)1);
        ActiveMQMessageConsumer consumer = (ActiveMQMessageConsumer)session.createConsumer((Destination)destination);
        this.sendMessages(session, (Destination)destination, 2);
        session.commit();
        ActiveMQConnection connection2 = (ActiveMQConnection)this.factory.createConnection();
        connection2.start();
        Session session2 = connection2.createSession(true, 0);
        ActiveMQMessageConsumer consumer2 = (ActiveMQMessageConsumer)session2.createConsumer((Destination)destination);
        Wait.assertEquals((int)1, () -> ((ActiveMQMessageConsumer)consumer).getMessageSize());
        Wait.assertEquals((int)1, () -> ((ActiveMQMessageConsumer)consumer2).getMessageSize());
        Message message1 = consumer.receive(1000L);
        JMSConsumer11Test.assertNotNull((Object)message1);
        Message message2 = consumer2.receive(5000L);
        JMSConsumer11Test.assertNotNull((Object)message2);
        session.commit();
        session2.commit();
        Message m = consumer.receiveNoWait();
        JMSConsumer11Test.assertNull((Object)m);
        try {
            connection2.close();
        }
        catch (Throwable e) {
            System.err.println("exception e: " + e);
            e.printStackTrace();
        }
    }
}

