/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.paging;

import java.nio.ByteBuffer;
import java.util.HashMap;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.tests.integration.paging.PagingTest;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Test;

public class PagingSyncTest
extends ActiveMQTestBase {
    private static final int PAGE_MAX = 102400;
    private static final int PAGE_SIZE = 10240;
    static final SimpleString ADDRESS = new SimpleString("SimpleAddress");

    @Test
    public void testOrder1() throws Throwable {
        boolean persistentMessages = true;
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        ActiveMQServer server = this.createServer(true, config, 10240, 102400L, new HashMap());
        server.start();
        int messageSize = 1024;
        int numberOfMessages = 500;
        ServerLocator locator = this.createInVMNonHALocator().setClientFailureCheckPeriod(1000L).setConnectionTTL(2000L).setReconnectAttempts(0).setBlockOnNonDurableSend(false).setBlockOnDurableSend(false).setBlockOnAcknowledge(false).setConsumerWindowSize(0x100000);
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = sf.createSession(false, false, false);
        server.addAddressInfo(new AddressInfo(ADDRESS, RoutingType.ANYCAST));
        server.createQueue(new QueueConfiguration(ADDRESS).setRoutingType(RoutingType.ANYCAST));
        ClientProducer producer = session.createProducer(PagingTest.ADDRESS);
        byte[] body = new byte[1024];
        ByteBuffer bb = ByteBuffer.wrap(body);
        for (int j = 1; j <= 1024; ++j) {
            bb.put(PagingSyncTest.getSamplebyte((long)j));
        }
        for (int i = 0; i < 500; ++i) {
            ClientMessage message = session.createMessage(persistentMessages);
            ActiveMQBuffer bodyLocal = message.getBodyBuffer();
            bodyLocal.writeBytes(body);
            message.putIntProperty(new SimpleString("id"), i);
            producer.send((Message)message);
        }
        session.commit();
        session.close();
    }
}

