/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.transports.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import java.util.ArrayList;
import java.util.Random;
import org.apache.activemq.artemis.core.remoting.impl.netty.ActiveMQFrameDecoder2;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Test;

public class ActiveMQFrameDecoder2Test
extends ActiveMQTestBase {
    private static final int MSG_CNT = 10000;
    private static final int MSG_LEN = 1000;
    private static final int FRAGMENT_MAX_LEN = 1500;
    private static final Random rand = new Random();

    @Test
    public void testOrdinaryFragmentation() throws Exception {
        EmbeddedChannel decoder = new EmbeddedChannel(new ChannelHandler[]{new ActiveMQFrameDecoder2()});
        byte[] data = new byte[1000];
        rand.nextBytes(data);
        ByteBuf src = Unpooled.buffer((int)10040000);
        while (src.writerIndex() < src.capacity()) {
            src.writeInt(1000);
            src.writeBytes(data);
        }
        ArrayList<ByteBuf> packets = new ArrayList<ByteBuf>();
        while (src.isReadable()) {
            int length = Math.min(rand.nextInt(1500), src.readableBytes());
            packets.add(src.readBytes(length));
        }
        int cnt = 0;
        for (ByteBuf p : packets) {
            ByteBuf frame;
            decoder.writeInbound(new Object[]{p});
            while ((frame = (ByteBuf)decoder.readInbound()) != null) {
                Assert.assertEquals((long)4L, (long)frame.readerIndex());
                Assert.assertEquals((long)1000L, (long)frame.readableBytes());
                Assert.assertEquals((Object)Unpooled.wrappedBuffer((byte[])data), (Object)frame);
                ++cnt;
                frame.release();
            }
        }
        Assert.assertEquals((long)10000L, (long)cnt);
    }

    @Test
    public void testExtremeFragmentation() throws Exception {
        EmbeddedChannel decoder = new EmbeddedChannel(new ChannelHandler[]{new ActiveMQFrameDecoder2()});
        decoder.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{0})});
        Assert.assertNull((Object)decoder.readInbound());
        decoder.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{0})});
        Assert.assertNull((Object)decoder.readInbound());
        decoder.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{0})});
        Assert.assertNull((Object)decoder.readInbound());
        decoder.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{4})});
        Assert.assertNull((Object)decoder.readInbound());
        decoder.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{5})});
        Assert.assertNull((Object)decoder.readInbound());
        decoder.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{6})});
        Assert.assertNull((Object)decoder.readInbound());
        decoder.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{7})});
        Assert.assertNull((Object)decoder.readInbound());
        decoder.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{8})});
        ByteBuf frame = (ByteBuf)decoder.readInbound();
        Assert.assertEquals((long)4L, (long)frame.readerIndex());
        Assert.assertEquals((long)4L, (long)frame.readableBytes());
        Assert.assertEquals((long)5L, (long)frame.getByte(4));
        Assert.assertEquals((long)6L, (long)frame.getByte(5));
        Assert.assertEquals((long)7L, (long)frame.getByte(6));
        Assert.assertEquals((long)8L, (long)frame.getByte(7));
        frame.release();
    }
}

