/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.activemq.artemis.wildfly.integration;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.activemq.artemis.core.remoting.impl.netty.TransportConstants;
import org.apache.activemq.artemis.core.remoting.impl.ssl.DefaultSSLContextFactory;
import org.apache.activemq.artemis.spi.core.remoting.ssl.SSLContextConfig;
import org.apache.activemq.artemis.utils.ConfigurationHelper;

public class WildFlySSLContextFactory
extends DefaultSSLContextFactory {
    private static final Map<String, SSLContext> SSL_CONTEXTS = Collections.synchronizedMap(new HashMap());

    public static void registerSSLContext(String name, SSLContext context) {
        SSL_CONTEXTS.put(name, context);
        log.warnf("Injecting Elytron SSLContext %s", (Object)name);
    }

    public static void unregisterSSLContext(String name) {
        SSL_CONTEXTS.remove(name);
    }

    public void clearSSLContexts() {
        SSL_CONTEXTS.clear();
    }

    public SSLContext getSSLContext(SSLContextConfig config, Map<String, Object> additionalOpts) throws Exception {
        boolean useDefaultSslContext = ConfigurationHelper.getBooleanProperty((String)"useDefaultSslContext", (boolean)false, additionalOpts);
        String sslContextName = ConfigurationHelper.getStringProperty((String)"sslContext", (String)ConfigurationHelper.getStringProperty((String)"keyStorePath", (String)TransportConstants.DEFAULT_KEYSTORE_PATH, additionalOpts), additionalOpts);
        if (useDefaultSslContext) {
            return SSLContext.getDefault();
        }
        log.debugf("Looking for Elytron SSLContext called %s", (Object)sslContextName);
        if (!SSL_CONTEXTS.containsKey(sslContextName)) {
            log.debugf("No Elytron SSLContext called %s found, creating it from the parameters", (Object)sslContextName);
            SSL_CONTEXTS.put(sslContextName, super.getSSLContext(config, additionalOpts));
        }
        return SSL_CONTEXTS.get(sslContextName);
    }

    public int getPriority() {
        return 20;
    }
}

