/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.metrics.deployment;

import java.util.List;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.DeploymentModelUtils;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.wildfly.extension.metrics.MetricCollector;
import org.wildfly.extension.metrics.deployment.DeploymentMetricService;

public class DeploymentMetricProcessor
implements DeploymentUnitProcessor {
    public static final AttachmentKey<MetricCollector> METRICS_COLLECTOR = AttachmentKey.create(MetricCollector.class);
    private final boolean exposeAnySubsystem;
    private final List<String> exposedSubsystems;
    private final String prefix;
    private Resource rootResource;
    private ManagementResourceRegistration managementResourceRegistration;

    public DeploymentMetricProcessor(boolean exposeAnySubsystem, List<String> exposedSubsystems, String prefix) {
        this.exposeAnySubsystem = exposeAnySubsystem;
        this.exposedSubsystems = exposedSubsystems;
        this.prefix = prefix;
    }

    public void deploy(DeploymentPhaseContext phaseContext) {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        this.rootResource = (Resource)deploymentUnit.getAttachment(DeploymentModelUtils.DEPLOYMENT_RESOURCE);
        this.managementResourceRegistration = (ManagementResourceRegistration)deploymentUnit.getAttachment(DeploymentModelUtils.MUTABLE_REGISTRATION_ATTACHMENT);
        DeploymentMetricService.install(phaseContext.getServiceTarget(), deploymentUnit, this.rootResource, this.managementResourceRegistration, this.exposeAnySubsystem, this.exposedSubsystems, this.prefix);
    }
}

