/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.integration.management.ManagementControlHelper;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.junit.Test;

public class AmqpScheduledMessageTest
extends AmqpClientTestSupport {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testSendWithDeliveryTimeIsScheduled() throws Exception {
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.getQueueName());
            Queue queueView = this.getProxyToQueue(this.getQueueName());
            AmqpScheduledMessageTest.assertNotNull((Object)queueView);
            AmqpMessage message = new AmqpMessage();
            long deliveryTime = System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(2L);
            message.setMessageAnnotation("x-opt-delivery-time", (Object)deliveryTime);
            message.setText("Test-Message");
            sender.send(message);
            sender.close();
            AmqpScheduledMessageTest.assertEquals((long)1L, (long)queueView.getScheduledCount());
            AmqpReceiver receiver = session.createReceiver(this.getQueueName());
            receiver.flow(1);
            AmqpMessage received = receiver.receive(5L, TimeUnit.SECONDS);
            AmqpScheduledMessageTest.assertNull((Object)received);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testSendRecvWithDeliveryTime() throws Exception {
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.getQueueName());
            Queue queueView = this.getProxyToQueue(this.getQueueName());
            AmqpScheduledMessageTest.assertNotNull((Object)queueView);
            SimpleString queueNameSS = SimpleString.toSimpleString((String)this.getQueueName());
            PagingStore targetPagingStore = this.server.getPagingManager().getPageStore(queueNameSS);
            AmqpScheduledMessageTest.assertNotNull((Object)targetPagingStore);
            QueueControl queueControl = ManagementControlHelper.createQueueControl(queueNameSS, queueNameSS, RoutingType.ANYCAST, this.mBeanServer);
            AmqpScheduledMessageTest.assertNotNull((Object)queueControl);
            AmqpMessage message = new AmqpMessage();
            long deliveryTime = System.currentTimeMillis() + 6000L;
            message.setMessageAnnotation("x-opt-delivery-time", (Object)deliveryTime);
            message.setText("Test-Message");
            message.setApplicationProperty("OneOfThose", (Object)"Please");
            sender.send(message);
            sender.close();
            AmqpScheduledMessageTest.assertEquals((long)1L, (long)queueView.getScheduledCount());
            AmqpScheduledMessageTest.assertTrue((targetPagingStore.getAddressSize() > 0L ? (byte)1 : 0) != 0);
            AmqpScheduledMessageTest.assertEquals((long)1L, (long)queueControl.listScheduledMessages().length);
            AmqpReceiver receiver = session.createReceiver(this.getQueueName());
            receiver.flow(1);
            AmqpMessage received = receiver.receive(2L, TimeUnit.SECONDS);
            AmqpScheduledMessageTest.assertNull((Object)received);
            received = receiver.receive(10L, TimeUnit.SECONDS);
            AmqpScheduledMessageTest.assertNotNull((Object)received);
            received.accept();
            Wait.assertEquals((long)0L, () -> ((PagingStore)targetPagingStore).getAddressSize());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testScheduleWithDelay() throws Exception {
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.getQueueName());
            Queue queueView = this.getProxyToQueue(this.getQueueName());
            AmqpScheduledMessageTest.assertNotNull((Object)queueView);
            AmqpMessage message = new AmqpMessage();
            long delay = 6000L;
            message.setMessageAnnotation("x-opt-delivery-delay", (Object)delay);
            message.setText("Test-Message");
            sender.send(message);
            sender.close();
            AmqpScheduledMessageTest.assertEquals((long)1L, (long)queueView.getScheduledCount());
            AmqpReceiver receiver = session.createReceiver(this.getQueueName());
            receiver.flow(1);
            AmqpMessage received = receiver.receive(2L, TimeUnit.SECONDS);
            AmqpScheduledMessageTest.assertNull((Object)received);
            received = receiver.receive(10L, TimeUnit.SECONDS);
            AmqpScheduledMessageTest.assertNotNull((Object)received);
            received.accept();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testSendWithDeliveryTimeHoldsMessage() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpScheduledMessageTest.assertNotNull((Object)client);
        try (AmqpConnection connection = this.addConnection(client.connect());){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.getQueueName());
            AmqpReceiver receiver = session.createReceiver(this.getQueueName());
            AmqpMessage message = new AmqpMessage();
            long deliveryTime = System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(5L);
            message.setMessageAnnotation("x-opt-delivery-time", (Object)deliveryTime);
            message.setText("Test-Message");
            sender.send(message);
            receiver.flow(1);
            AmqpScheduledMessageTest.assertNull((Object)receiver.receive(1L, TimeUnit.SECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testSendWithDeliveryTimeDeliversMessageAfterDelay() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpScheduledMessageTest.assertNotNull((Object)client);
        try (AmqpConnection connection = this.addConnection(client.connect());){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.getQueueName());
            AmqpReceiver receiver = session.createReceiver(this.getQueueName());
            AmqpMessage message = new AmqpMessage();
            long deliveryTime = System.currentTimeMillis() + 2000L;
            message.setMessageAnnotation("x-opt-delivery-time", (Object)deliveryTime);
            message.setText("Test-Message");
            sender.send(message);
            receiver.flow(1);
            AmqpMessage received = receiver.receive(10L, TimeUnit.SECONDS);
            AmqpScheduledMessageTest.assertNotNull((Object)received);
            received.accept();
            Long msgDeliveryTime = (Long)received.getMessageAnnotation("x-opt-delivery-time");
            AmqpScheduledMessageTest.assertNotNull((Object)msgDeliveryTime);
            AmqpScheduledMessageTest.assertEquals((long)deliveryTime, (long)msgDeliveryTime);
        }
    }
}

