/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import javax.management.MBeanServer;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMAcceptorFactory;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyAcceptorFactory;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.tests.integration.amqp.JMSSaslExternalTest;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifFiles;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP", port=1024)})
@ApplyLdifFiles(value={"AMQauth.ldif"})
public class JMSSaslExternalLDAPTest
extends AbstractLdapTestUnit {
    private ActiveMQServer server;
    private final boolean debug = false;
    public static final String TARGET_TMP = "./target/tmp";
    @Rule
    public TemporaryFolder temporaryFolder;
    private String testDir;

    public JMSSaslExternalLDAPTest() {
        File parent = new File(TARGET_TMP);
        parent.mkdirs();
        this.temporaryFolder = new TemporaryFolder(parent);
    }

    @Before
    public void setUp() throws Exception {
        this.testDir = this.temporaryFolder.getRoot().getAbsolutePath();
    }

    @Before
    public void startServer() throws Exception {
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager("SaslExternalPlusLdap");
        ConfigurationImpl configuration = new ConfigurationImpl().setSecurityEnabled(true).addAcceptorConfiguration(new TransportConfiguration(InVMAcceptorFactory.class.getCanonicalName())).setJournalDirectory(ActiveMQTestBase.getJournalDir((String)this.testDir, (int)0, (boolean)false)).setBindingsDirectory(ActiveMQTestBase.getBindingsDir((String)this.testDir, (int)0, (boolean)false)).setPagingDirectory(ActiveMQTestBase.getPageDir((String)this.testDir, (int)0, (boolean)false)).setLargeMessagesDirectory(ActiveMQTestBase.getLargeMessagesDir((String)this.testDir, (int)0, (boolean)false));
        this.server = ActiveMQServers.newActiveMQServer((Configuration)configuration, (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)securityManager, (boolean)false);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sslEnabled", true);
        params.put("keyStorePath", "server-keystore.jks");
        params.put("keyStorePassword", "securepass");
        params.put("trustStorePath", "client-ca-truststore.jks");
        params.put("trustStorePassword", "securepass");
        params.put("needClientAuth", true);
        HashMap<String, String> extraParams = new HashMap<String, String>();
        extraParams.put("saslMechanisms", "EXTERNAL");
        this.server.getConfiguration().addAcceptorConfiguration(new TransportConfiguration(NettyAcceptorFactory.class.getCanonicalName(), params, "netty", extraParams));
        String roleName = "widgets";
        Role role = new Role("widgets", true, true, true, true, true, true, true, true, true, true);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(role);
        this.server.getSecurityRepository().addMatch("TEST", roles);
        this.server.start();
    }

    @After
    public void stopServer() throws Exception {
        this.server.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=600000L)
    public void testRoundTrip() throws Exception {
        String keystore = ((Object)((Object)this)).getClass().getClassLoader().getResource("client-keystore.jks").getFile();
        String truststore = ((Object)((Object)this)).getClass().getClassLoader().getResource("server-ca-truststore.jks").getFile();
        String connOptions = "?amqp.saslMechanisms=EXTERNAL&transport.trustStoreLocation=" + truststore + "&transport.trustStorePassword=securepass&transport.keyStoreLocation=" + keystore + "&transport.keyStorePassword=securepass&transport.verifyHost=false";
        JmsConnectionFactory factory = new JmsConnectionFactory(new URI("amqps://localhost:61616" + connOptions));
        connection.start();
        try (Connection connection = factory.createConnection("client", null);){
            Session session = connection.createSession(false, 1);
            Queue queue = session.createQueue("TEST");
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            MessageProducer producer = session.createProducer((Destination)queue);
            String text = RandomUtil.randomString();
            producer.send((Message)session.createTextMessage(text));
            TextMessage m = (TextMessage)consumer.receive(1000L);
            Assert.assertNotNull((Object)m);
            Assert.assertEquals((Object)text, (Object)m.getText());
        }
    }

    static {
        URL resource;
        String path = System.getProperty("java.security.auth.login.config");
        if (path == null && (resource = JMSSaslExternalTest.class.getClassLoader().getResource("login.config")) != null) {
            path = resource.getFile();
            System.setProperty("java.security.auth.login.config", path);
        }
    }
}

