/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.ActiveMQDisconnectedException;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQIOErrorException;
import org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException;
import org.apache.activemq.artemis.api.core.ActiveMQNonExistentQueueException;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ClientProducerImpl;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.impl.RemotingConnectionImpl;
import org.apache.activemq.artemis.core.remoting.CloseListener;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.impl.ServerSessionImpl;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.SingleServerTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.jboss.logging.Logger;
import org.junit.Test;

public class TemporaryQueueTest
extends SingleServerTestBase {
    private static final Logger log = Logger.getLogger(TemporaryQueueTest.class);
    private static final long CONNECTION_TTL = 2000L;

    protected ActiveMQServer createServer() throws Exception {
        ActiveMQServer server = super.createServer();
        server.getConfiguration().setAddressQueueScanPeriod(100L);
        return server;
    }

    @Test
    public void testConsumeFromTemporaryQueue() throws Exception {
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString address = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage msg = this.session.createMessage(false);
        producer.send((Message)msg);
        this.session.start();
        ClientConsumer consumer = this.session.createConsumer(queue);
        ClientMessage message = consumer.receive(500L);
        TemporaryQueueTest.assertNotNull((Object)message);
        message.acknowledge();
        consumer.close();
        this.session.deleteQueue(queue);
        this.session.close();
    }

    @Test
    public void testMemoryLeakOnAddressSettingForTemporaryQueue() throws Exception {
        for (int i = 0; i < 1000; ++i) {
            SimpleString queue = RandomUtil.randomSimpleString();
            SimpleString address = RandomUtil.randomSimpleString();
            this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
            this.session.close();
            this.session = this.sf.createSession();
        }
        this.session.close();
        this.sf.close();
        Wait.assertTrue((String)("server.getAddressSettingsRepository().getCacheSize() = " + this.server.getAddressSettingsRepository().getCacheSize()), () -> this.server.getAddressSettingsRepository().getCacheSize() < 10);
    }

    @Test
    public void testPaginStoreIsRemovedWhenQueueIsDeleted() throws Exception {
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString address = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage msg = this.session.createMessage(false);
        producer.send((Message)msg);
        this.session.start();
        ClientConsumer consumer = this.session.createConsumer(queue);
        ClientMessage message = consumer.receive(500L);
        TemporaryQueueTest.assertNotNull((Object)message);
        message.acknowledge();
        Wait.assertTrue(() -> Arrays.asList(this.server.getPagingManager().getStoreNames()).contains(address));
        consumer.close();
        this.session.deleteQueue(queue);
        this.session.close();
        Wait.assertFalse(() -> Arrays.asList(this.server.getPagingManager().getStoreNames()).contains(address));
    }

    @Test
    public void testConsumeFromTemporaryQueueCreatedByOtherSession() throws Exception {
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString address = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        ClientProducer producer = this.session.createProducer(address);
        producer.send((Message)this.session.createMessage(false));
        ClientSession session2 = this.sf.createSession(false, true, true);
        session2.start();
        ClientConsumer consumer = session2.createConsumer(queue);
        ClientMessage message = consumer.receive(500L);
        TemporaryQueueTest.assertNotNull((Object)message);
        session2.close();
        this.session.close();
    }

    @Test
    public void testDeleteTemporaryQueueAfterConnectionIsClosed() throws Exception {
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString address = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        RemotingConnectionImpl conn = (RemotingConnectionImpl)this.server.getRemotingService().getConnections().iterator().next();
        final CountDownLatch latch = new CountDownLatch(1);
        conn.addCloseListener(new CloseListener(){

            public void connectionClosed() {
                latch.countDown();
            }
        });
        this.session.close();
        this.sf.close();
        TemporaryQueueTest.assertTrue((String)"connection close listeners not fired", (boolean)latch.await(4000L, TimeUnit.MILLISECONDS));
        this.sf = this.addSessionFactory(this.createSessionFactory(this.locator));
        this.session = this.sf.createSession(false, true, true);
        this.session.start();
        try {
            this.session.createConsumer(queue);
            TemporaryQueueTest.fail((String)"temp queue must not exist after the remoting connection is closed");
        }
        catch (ActiveMQNonExistentQueueException activeMQNonExistentQueueException) {
        }
        catch (ActiveMQException e) {
            TemporaryQueueTest.fail((String)("Invalid Exception type:" + e.getType()));
        }
        this.session.close();
    }

    @Test
    public void testQueueWithWildcard() throws Exception {
        this.session.createQueue(new QueueConfiguration("queue1").setAddress("a.b"));
        this.session.createQueue(new QueueConfiguration("queue2").setAddress("a.#").setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        this.session.createQueue(new QueueConfiguration("queue3").setAddress("a.#").setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        ClientProducer producer = this.session.createProducer("a.b");
        producer.send((Message)this.session.createMessage(false));
        ClientConsumer cons = this.session.createConsumer("queue2");
        this.session.start();
        ClientMessage msg = cons.receive(5000L);
        TemporaryQueueTest.assertNotNull((Object)msg);
        msg.acknowledge();
        cons.close();
        cons = this.session.createConsumer("queue3");
        this.session.start();
        msg = cons.receive(5000L);
        TemporaryQueueTest.assertNotNull((Object)msg);
        msg.acknowledge();
        cons.close();
        this.session.deleteQueue("queue2");
        this.session.deleteQueue("queue3");
        this.session.close();
    }

    @Test
    public void testQueueWithWildcard2() throws Exception {
        this.session.createQueue(new QueueConfiguration("queue1").setAddress("a.b"));
        this.session.createQueue(new QueueConfiguration("queue2").setAddress("a.#").setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        this.session.createQueue(new QueueConfiguration("queue3").setAddress("a.#").setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        ClientProducer producer = this.session.createProducer("a.b");
        producer.send((Message)this.session.createMessage(false));
        ClientConsumer cons = this.session.createConsumer("queue2");
        this.session.start();
        ClientMessage msg = cons.receive(5000L);
        TemporaryQueueTest.assertNotNull((Object)msg);
        msg.acknowledge();
        cons.close();
        cons = this.session.createConsumer("queue3");
        this.session.start();
        msg = cons.receive(5000L);
        TemporaryQueueTest.assertNotNull((Object)msg);
        msg.acknowledge();
        cons.close();
        this.session.deleteQueue("queue2");
        this.session.deleteQueue("queue3");
        this.session.close();
    }

    @Test
    public void testQueueWithWildcard3() throws Exception {
        this.session.createQueue(new QueueConfiguration("queue1").setAddress("a.b"));
        this.session.createQueue(new QueueConfiguration("queue2").setAddress("a.#").setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        this.session.createQueue(new QueueConfiguration("queue2.1").setAddress("a.#").setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        this.session.deleteQueue("queue2");
    }

    @Test
    public void testDeleteTemporaryQueueAfterConnectionIsClosed_2() throws Exception {
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString address = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address));
        TemporaryQueueTest.assertEquals((long)1L, (long)this.server.getConnectionCount());
        ClientSession session2 = this.sf.createSession(false, true, true);
        this.session.close();
        session2.start();
        session2.createConsumer(queue);
        session2.close();
    }

    @Test
    public void testRecreateConsumerOverServerFailure() throws Exception {
        ServerLocator serverWithReattach = this.createInVMNonHALocator().setReconnectAttempts(30).setRetryInterval(1000L).setConfirmationWindowSize(-1).setConnectionTTL(2000L).setClientFailureCheckPeriod(666L);
        ClientSessionFactory reattachSF = this.createSessionFactory(serverWithReattach);
        ClientSession session = reattachSF.createSession(false, false);
        session.createQueue(new QueueConfiguration("tmpQ").setAddress("tmpAd").setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        ClientConsumer consumer = session.createConsumer("tmpQ");
        ClientProducer prod = session.createProducer("tmpAd");
        session.start();
        RemotingConnectionImpl conn = (RemotingConnectionImpl)((ClientSessionInternal)session).getConnection();
        conn.fail((ActiveMQException)((Object)new ActiveMQIOErrorException()));
        prod.send((Message)session.createMessage(false));
        session.commit();
        TemporaryQueueTest.assertNotNull((Object)consumer.receive(1000L));
        session.close();
        reattachSF.close();
        serverWithReattach.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTemporaryQueuesWithFilter() throws Exception {
        int countTmpQueue = 0;
        final AtomicInteger errors = new AtomicInteger(0);
        String address = "AD_test";
        int iterations = 100;
        int msgs = 100;
        for (int i = 0; i < iterations; ++i) {
            ClientSessionFactory clientsConnecton = this.addSessionFactory(this.createSessionFactory(this.locator));
            ClientSession localSession = clientsConnecton.createSession();
            ClientProducer prod = localSession.createProducer(address);
            localSession.start();
            String queueRed = address + "_red_" + countTmpQueue++;
            String queueBlue = address + "_blue_" + countTmpQueue++;
            ClientSession sessConsumerRed = clientsConnecton.createSession();
            sessConsumerRed.createQueue(new QueueConfiguration(queueRed).setAddress(address).setFilterString("color='red'").setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
            class MyHandler
            implements MessageHandler {
                final String color;
                final CountDownLatch latch;
                final ClientSession sess;

                MyHandler(ClientSession sess, String color, int expectedMessages) {
                    this.sess = sess;
                    this.latch = new CountDownLatch(expectedMessages);
                    this.color = color;
                }

                public boolean waitCompletion() throws Exception {
                    return this.latch.await(10L, TimeUnit.SECONDS);
                }

                public void onMessage(ClientMessage message) {
                    try {
                        message.acknowledge();
                        this.sess.commit();
                        this.latch.countDown();
                        if (!message.getStringProperty("color").equals(this.color)) {
                            log.warn((Object)("Unexpected color " + message.getStringProperty("color") + " when we were expecting " + this.color));
                            errors.incrementAndGet();
                        }
                    }
                    catch (Exception e) {
                        log.warn((Object)e.getMessage(), (Throwable)e);
                        errors.incrementAndGet();
                    }
                }
            }
            MyHandler redHandler = new MyHandler(sessConsumerRed, "red", msgs);
            ClientConsumer redClientConsumer = sessConsumerRed.createConsumer(queueRed);
            redClientConsumer.setMessageHandler((MessageHandler)redHandler);
            sessConsumerRed.start();
            ClientSession sessConsumerBlue = clientsConnecton.createSession();
            sessConsumerBlue.createQueue(new QueueConfiguration(queueBlue).setAddress(address).setFilterString("color='blue'").setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
            MyHandler blueHandler = new MyHandler(sessConsumerBlue, "blue", msgs);
            ClientConsumer blueClientConsumer = sessConsumerBlue.createConsumer(queueBlue);
            blueClientConsumer.setMessageHandler((MessageHandler)blueHandler);
            sessConsumerBlue.start();
            try {
                ClientMessage msgBlue = this.session.createMessage(false);
                msgBlue.putStringProperty("color", "blue");
                ClientMessage msgRed = this.session.createMessage(false);
                msgRed.putStringProperty("color", "red");
                for (int nmsg = 0; nmsg < msgs; ++nmsg) {
                    prod.send((Message)msgBlue);
                    prod.send((Message)msgRed);
                    this.session.commit();
                }
                blueHandler.waitCompletion();
                redHandler.waitCompletion();
                TemporaryQueueTest.assertEquals((long)0L, (long)errors.get());
                continue;
            }
            finally {
                localSession.close();
                clientsConnecton.close();
            }
        }
    }

    @Test
    public void testDeleteTemporaryQueueWhenClientCrash() throws Exception {
        this.session.close();
        this.sf.close();
        final SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString address = RandomUtil.randomSimpleString();
        final CountDownLatch pingOnServerLatch = new CountDownLatch(1);
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)new Interceptor(){

            public boolean intercept(Packet packet, RemotingConnection connection) throws ActiveMQException {
                if (packet.getType() == 10) {
                    pingOnServerLatch.countDown();
                }
                return true;
            }
        });
        ServerLocator locator = this.createInVMNonHALocator();
        locator.setConnectionTTL(2000L);
        this.sf = this.addSessionFactory(this.createSessionFactory(locator));
        this.session = this.sf.createSession(false, true, true);
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        TemporaryQueueTest.assertTrue((String)"server has not received any ping from the client", (boolean)pingOnServerLatch.await(2L * this.server.getConfiguration().getConnectionTtlCheckInterval(), TimeUnit.MILLISECONDS));
        TemporaryQueueTest.assertEquals((long)1L, (long)this.server.getConnectionCount());
        RemotingConnection remotingConnection = (RemotingConnection)this.server.getRemotingService().getConnections().iterator().next();
        final CountDownLatch serverCloseLatch = new CountDownLatch(1);
        remotingConnection.addCloseListener(new CloseListener(){

            public void connectionClosed() {
                serverCloseLatch.countDown();
            }
        });
        ((ClientSessionInternal)this.session).getConnection().fail((ActiveMQException)new ActiveMQInternalErrorException("simulate a client failure"));
        TemporaryQueueTest.assertTrue((String)"server has not closed the connection", (boolean)serverCloseLatch.await(2L * this.server.getConfiguration().getConnectionTtlCheckInterval() + 4000L, TimeUnit.MILLISECONDS));
        long timeout = System.currentTimeMillis() + 5000L;
        while (timeout > System.currentTimeMillis() && this.server.getConnectionCount() > 0) {
            Thread.sleep(1L);
        }
        TemporaryQueueTest.assertEquals((long)0L, (long)this.server.getConnectionCount());
        this.session.close();
        this.sf.close();
        ServerLocator locator2 = this.createInVMNonHALocator();
        this.sf = this.addSessionFactory(this.createSessionFactory(locator2));
        this.session = this.sf.createSession(false, true, true);
        this.session.start();
        ActiveMQTestBase.ActiveMQAction activeMQAction = new ActiveMQTestBase.ActiveMQAction(){

            public void run() throws ActiveMQException {
                TemporaryQueueTest.this.session.createConsumer(queue);
            }
        };
        ActiveMQTestBase.expectActiveMQException((String)"temp queue must not exist after the server detected the client crash", (ActiveMQExceptionType)ActiveMQExceptionType.QUEUE_DOES_NOT_EXIST, (ActiveMQTestBase.ActiveMQAction)activeMQAction);
        this.session.close();
        locator2.close();
    }

    @Test
    public void testBlockingWithTemporaryQueue() throws Exception {
        int secondReceive;
        AddressSettings setting = new AddressSettings().setAddressFullMessagePolicy(AddressFullMessagePolicy.BLOCK).setMaxSizeBytes(0x100000L);
        this.server.getAddressSettingsRepository().addMatch("TestAD", (Object)setting);
        ClientSessionFactory consumerCF = this.createSessionFactory(this.locator);
        ClientSession consumerSession = consumerCF.createSession(true, true);
        consumerSession.addMetaData("consumer", "consumer");
        consumerSession.createQueue(new QueueConfiguration("Q1").setAddress("TestAD").setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        consumerSession.createConsumer("Q1");
        consumerSession.start();
        final ClientProducerImpl prod = (ClientProducerImpl)this.session.createProducer("TestAD");
        final AtomicInteger errors = new AtomicInteger(0);
        final AtomicInteger msgs = new AtomicInteger(0);
        int TOTAL_MSG = 1000;
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    for (int i = 0; i < 1000; ++i) {
                        ClientMessage msg = TemporaryQueueTest.this.session.createMessage(false);
                        msg.getBodyBuffer().writeBytes(new byte[1024]);
                        prod.send((Message)msg);
                        msgs.incrementAndGet();
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
            }
        };
        t.start();
        while (msgs.get() == 0) {
            Thread.sleep(100L);
        }
        int blockedTime = 0;
        while (t.isAlive() && errors.get() == 0 && (!prod.getProducerCredits().isBlocked() || blockedTime < 60)) {
            blockedTime = prod.getProducerCredits().isBlocked() ? ++blockedTime : 0;
            Thread.sleep(100L);
        }
        TemporaryQueueTest.assertEquals((long)0L, (long)errors.get());
        ClientSessionFactory newConsumerCF = this.createSessionFactory(this.locator);
        ClientSession newConsumerSession = newConsumerCF.createSession(true, true);
        newConsumerSession.createQueue(new QueueConfiguration("Q2").setAddress("TestAD").setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        ClientConsumer newConsumer = newConsumerSession.createConsumer("Q2");
        newConsumerSession.start();
        int toReceive = 1000 - msgs.get();
        for (ServerSession sessionIterator : this.server.getSessions()) {
            if (sessionIterator.getMetaData("consumer") == null) continue;
            ServerSessionImpl impl = (ServerSessionImpl)sessionIterator;
            impl.getRemotingConnection().fail((ActiveMQException)new ActiveMQDisconnectedException("failure e"));
        }
        ClientMessage msg = null;
        for (secondReceive = 0; secondReceive < toReceive && (msg = newConsumer.receive(5000L)) != null; ++secondReceive) {
            msg.acknowledge();
        }
        TemporaryQueueTest.assertNull((Object)newConsumer.receiveImmediate());
        TemporaryQueueTest.assertEquals((long)toReceive, (long)secondReceive);
        t.join();
    }
}

