/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WildCardRoutingTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private ServerLocator locator;
    private ClientSession clientSession;
    private ClientSessionFactory sf;

    @Test
    public void testBasicWildcardRouting() throws Exception {
        SimpleString addressAB = new SimpleString("a.b");
        SimpleString addressAC = new SimpleString("a.c");
        SimpleString address = new SimpleString("a.*");
        SimpleString queueName1 = new SimpleString("Q1");
        SimpleString queueName2 = new SimpleString("Q2");
        SimpleString queueName = new SimpleString("Q");
        this.clientSession.createQueue(new QueueConfiguration(queueName1).setAddress(addressAB).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName2).setAddress(addressAC).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(addressAB);
        ClientProducer producer2 = this.clientSession.createProducer(addressAC);
        ClientConsumer clientConsumer = this.clientSession.createConsumer(queueName);
        this.clientSession.start();
        producer.send((Message)this.createTextMessage(this.clientSession, "m1"));
        producer2.send((Message)this.createTextMessage(this.clientSession, "m2"));
        ClientMessage m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"m1", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"m2", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receiveImmediate();
        Assert.assertNull((Object)m);
    }

    @Test
    public void testBasicWildcardRoutingQueuesDontExist() throws Exception {
        SimpleString addressAB = new SimpleString("a.b");
        SimpleString addressAC = new SimpleString("a.c");
        SimpleString address = new SimpleString("a.*");
        SimpleString queueName = new SimpleString("Q");
        this.clientSession.createQueue(new QueueConfiguration(queueName).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(addressAB);
        ClientProducer producer2 = this.clientSession.createProducer(addressAC);
        ClientConsumer clientConsumer = this.clientSession.createConsumer(queueName);
        this.clientSession.start();
        producer.send((Message)this.createTextMessage(this.clientSession, "m1"));
        producer2.send((Message)this.createTextMessage(this.clientSession, "m2"));
        ClientMessage m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"m1", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"m2", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receiveImmediate();
        Assert.assertNull((Object)m);
        clientConsumer.close();
        this.clientSession.deleteQueue(queueName);
        Assert.assertEquals((long)0L, (long)this.server.getPostOffice().getBindingsForAddress(addressAB).getBindings().size());
        Assert.assertEquals((long)0L, (long)this.server.getPostOffice().getBindingsForAddress(addressAC).getBindings().size());
        Assert.assertEquals((long)0L, (long)this.server.getPostOffice().getBindingsForAddress(address).getBindings().size());
    }

    @Test
    public void testBasicWildcardRoutingQueuesDontExist2() throws Exception {
        SimpleString addressAB = new SimpleString("a.b");
        SimpleString addressAC = new SimpleString("a.c");
        SimpleString address = new SimpleString("a.*");
        SimpleString queueName = new SimpleString("Q");
        SimpleString queueName2 = new SimpleString("Q2");
        this.clientSession.createQueue(new QueueConfiguration(queueName).setAddress(address).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName2).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(addressAB);
        ClientProducer producer2 = this.clientSession.createProducer(addressAC);
        ClientConsumer clientConsumer = this.clientSession.createConsumer(queueName);
        this.clientSession.start();
        producer.send((Message)this.createTextMessage(this.clientSession, "m1"));
        producer2.send((Message)this.createTextMessage(this.clientSession, "m2"));
        ClientMessage m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"m1", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"m2", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receiveImmediate();
        Assert.assertNull((Object)m);
        clientConsumer.close();
        this.clientSession.deleteQueue(queueName);
        Assert.assertEquals((long)1L, (long)this.server.getPostOffice().getBindingsForAddress(addressAB).getBindings().size());
        Assert.assertEquals((long)1L, (long)this.server.getPostOffice().getBindingsForAddress(addressAC).getBindings().size());
        Assert.assertEquals((long)1L, (long)this.server.getPostOffice().getBindingsForAddress(address).getBindings().size());
        this.clientSession.deleteQueue(queueName2);
        Assert.assertEquals((long)0L, (long)this.server.getPostOffice().getBindingsForAddress(addressAB).getBindings().size());
        Assert.assertEquals((long)0L, (long)this.server.getPostOffice().getBindingsForAddress(addressAC).getBindings().size());
        Assert.assertEquals((long)0L, (long)this.server.getPostOffice().getBindingsForAddress(address).getBindings().size());
    }

    @Test
    public void testBasicWildcardRoutingWithHash() throws Exception {
        SimpleString addressAB = new SimpleString("a.b");
        SimpleString addressAC = new SimpleString("a.c");
        SimpleString address = new SimpleString("a.#");
        SimpleString queueName1 = new SimpleString("Q1");
        SimpleString queueName2 = new SimpleString("Q2");
        SimpleString queueName = new SimpleString("Q");
        this.clientSession.createQueue(new QueueConfiguration(queueName1).setAddress(addressAB).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName2).setAddress(addressAC).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(addressAB);
        ClientProducer producer2 = this.clientSession.createProducer(addressAC);
        ClientConsumer clientConsumer = this.clientSession.createConsumer(queueName);
        this.clientSession.start();
        producer.send((Message)this.createTextMessage(this.clientSession, "m1"));
        producer2.send((Message)this.createTextMessage(this.clientSession, "m2"));
        ClientMessage m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"m1", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"m2", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receiveImmediate();
        Assert.assertNull((Object)m);
    }

    @Test
    public void testWildcardRoutingQueuesAddedAfter() throws Exception {
        SimpleString addressAB = new SimpleString("a.b");
        SimpleString addressAC = new SimpleString("a.c");
        SimpleString address = new SimpleString("a.*");
        SimpleString queueName1 = new SimpleString("Q1");
        SimpleString queueName2 = new SimpleString("Q2");
        SimpleString queueName = new SimpleString("Q");
        this.clientSession.createQueue(new QueueConfiguration(queueName).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(addressAB);
        ClientProducer producer2 = this.clientSession.createProducer(addressAC);
        ClientConsumer clientConsumer = this.clientSession.createConsumer(queueName);
        this.clientSession.createQueue(new QueueConfiguration(queueName1).setAddress(addressAB).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName2).setAddress(addressAC).setDurable(Boolean.valueOf(false)));
        this.clientSession.start();
        producer.send((Message)this.createTextMessage(this.clientSession, "m1"));
        producer2.send((Message)this.createTextMessage(this.clientSession, "m2"));
        ClientMessage m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"m1", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"m2", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receiveImmediate();
        Assert.assertNull((Object)m);
    }

    @Test
    public void testWildcardRoutingQueuesAddedThenDeleted() throws Exception {
        SimpleString addressAB = new SimpleString("a.b");
        SimpleString addressAC = new SimpleString("a.c");
        SimpleString address = new SimpleString("a.*");
        SimpleString queueName1 = new SimpleString("Q1");
        SimpleString queueName2 = new SimpleString("Q2");
        SimpleString queueName = new SimpleString("Q");
        this.clientSession.createQueue(new QueueConfiguration(queueName1).setAddress(addressAB).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName2).setAddress(addressAC).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(addressAB);
        ClientProducer producer2 = this.clientSession.createProducer(addressAC);
        ClientConsumer clientConsumer = this.clientSession.createConsumer(queueName);
        this.clientSession.start();
        this.clientSession.deleteQueue(queueName1);
        Assert.assertEquals((long)this.server.getPostOffice().getBindingsForAddress(addressAB).getBindings().size(), (long)1L);
        producer.send((Message)this.createTextMessage(this.clientSession, "m1"));
        producer2.send((Message)this.createTextMessage(this.clientSession, "m2"));
        ClientMessage m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"m1", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"m2", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        clientConsumer.close();
        this.clientSession.deleteQueue(queueName);
        Assert.assertEquals((long)this.server.getPostOffice().getBindingsForAddress(addressAB).getBindings().size(), (long)0L);
    }

    @Test
    public void testWildcardRoutingLotsOfQueuesAddedThenDeleted() throws Exception {
        SimpleString addressAB = new SimpleString("a.b");
        SimpleString addressAC = new SimpleString("a.c");
        SimpleString addressAD = new SimpleString("a.d");
        SimpleString addressAE = new SimpleString("a.e");
        SimpleString addressAF = new SimpleString("a.f");
        SimpleString addressAG = new SimpleString("a.g");
        SimpleString addressAH = new SimpleString("a.h");
        SimpleString addressAJ = new SimpleString("a.j");
        SimpleString addressAK = new SimpleString("a.k");
        SimpleString address = new SimpleString("a.*");
        SimpleString queueName1 = new SimpleString("Q1");
        SimpleString queueName2 = new SimpleString("Q2");
        SimpleString queueName3 = new SimpleString("Q3");
        SimpleString queueName4 = new SimpleString("Q4");
        SimpleString queueName5 = new SimpleString("Q5");
        SimpleString queueName6 = new SimpleString("Q6");
        SimpleString queueName7 = new SimpleString("Q7");
        SimpleString queueName8 = new SimpleString("Q8");
        SimpleString queueName9 = new SimpleString("Q9");
        SimpleString queueName = new SimpleString("Q");
        this.clientSession.createQueue(new QueueConfiguration(queueName1).setAddress(addressAB).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName2).setAddress(addressAC).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName3).setAddress(addressAD).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName4).setAddress(addressAE).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName5).setAddress(addressAF).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName6).setAddress(addressAG).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName7).setAddress(addressAH).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName8).setAddress(addressAJ).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName9).setAddress(addressAK).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer();
        ClientConsumer clientConsumer = this.clientSession.createConsumer(queueName);
        this.clientSession.start();
        producer.send(addressAB, (Message)this.createTextMessage(this.clientSession, "m1"));
        producer.send(addressAC, (Message)this.createTextMessage(this.clientSession, "m2"));
        producer.send(addressAD, (Message)this.createTextMessage(this.clientSession, "m3"));
        producer.send(addressAE, (Message)this.createTextMessage(this.clientSession, "m4"));
        producer.send(addressAF, (Message)this.createTextMessage(this.clientSession, "m5"));
        producer.send(addressAG, (Message)this.createTextMessage(this.clientSession, "m6"));
        producer.send(addressAH, (Message)this.createTextMessage(this.clientSession, "m7"));
        producer.send(addressAJ, (Message)this.createTextMessage(this.clientSession, "m8"));
        producer.send(addressAK, (Message)this.createTextMessage(this.clientSession, "m9"));
        ClientMessage m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"m1", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"m2", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"m3", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"m4", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"m5", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"m6", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"m7", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"m8", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"m9", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receiveImmediate();
        Assert.assertNull((Object)m);
        this.clientSession.deleteQueue(queueName1);
        this.clientSession.deleteQueue(queueName2);
        this.clientSession.deleteQueue(queueName3);
        this.clientSession.deleteQueue(queueName4);
        this.clientSession.deleteQueue(queueName5);
        this.clientSession.deleteQueue(queueName6);
        this.clientSession.deleteQueue(queueName7);
        this.clientSession.deleteQueue(queueName8);
        this.clientSession.deleteQueue(queueName9);
        clientConsumer.close();
        this.clientSession.deleteQueue(queueName);
    }

    @Test
    public void testWildcardRoutingLotsOfQueuesAddedThenDeletedHash() throws Exception {
        SimpleString addressAB = new SimpleString("a.b");
        SimpleString addressAC = new SimpleString("a.c");
        SimpleString addressAD = new SimpleString("a.d");
        SimpleString addressAE = new SimpleString("a.e");
        SimpleString addressAF = new SimpleString("a.f");
        SimpleString addressAG = new SimpleString("a.g");
        SimpleString addressAH = new SimpleString("a.h");
        SimpleString addressAJ = new SimpleString("a.j");
        SimpleString addressAK = new SimpleString("a.k");
        SimpleString address = new SimpleString("#");
        SimpleString queueName1 = new SimpleString("Q1");
        SimpleString queueName2 = new SimpleString("Q2");
        SimpleString queueName3 = new SimpleString("Q3");
        SimpleString queueName4 = new SimpleString("Q4");
        SimpleString queueName5 = new SimpleString("Q5");
        SimpleString queueName6 = new SimpleString("Q6");
        SimpleString queueName7 = new SimpleString("Q7");
        SimpleString queueName8 = new SimpleString("Q8");
        SimpleString queueName9 = new SimpleString("Q9");
        SimpleString queueName = new SimpleString("Q");
        this.clientSession.createQueue(new QueueConfiguration(queueName1).setAddress(addressAB).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName2).setAddress(addressAC).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName3).setAddress(addressAD).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName4).setAddress(addressAE).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName5).setAddress(addressAF).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName6).setAddress(addressAG).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName7).setAddress(addressAH).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName8).setAddress(addressAJ).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName9).setAddress(addressAK).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer();
        ClientConsumer clientConsumer = this.clientSession.createConsumer(queueName);
        this.clientSession.start();
        producer.send(addressAB, (Message)this.createTextMessage(this.clientSession, "m1"));
        producer.send(addressAC, (Message)this.createTextMessage(this.clientSession, "m2"));
        producer.send(addressAD, (Message)this.createTextMessage(this.clientSession, "m3"));
        producer.send(addressAE, (Message)this.createTextMessage(this.clientSession, "m4"));
        producer.send(addressAF, (Message)this.createTextMessage(this.clientSession, "m5"));
        producer.send(addressAG, (Message)this.createTextMessage(this.clientSession, "m6"));
        producer.send(addressAH, (Message)this.createTextMessage(this.clientSession, "m7"));
        producer.send(addressAJ, (Message)this.createTextMessage(this.clientSession, "m8"));
        producer.send(addressAK, (Message)this.createTextMessage(this.clientSession, "m9"));
        ClientMessage m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"m1", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"m2", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"m3", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"m4", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"m5", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"m6", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"m7", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"m8", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"m9", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receiveImmediate();
        Assert.assertNull((Object)m);
        this.clientSession.deleteQueue(queueName1);
        this.clientSession.deleteQueue(queueName2);
        this.clientSession.deleteQueue(queueName3);
        this.clientSession.deleteQueue(queueName4);
        this.clientSession.deleteQueue(queueName5);
        this.clientSession.deleteQueue(queueName6);
        this.clientSession.deleteQueue(queueName7);
        this.clientSession.deleteQueue(queueName8);
        this.clientSession.deleteQueue(queueName9);
        clientConsumer.close();
        this.clientSession.deleteQueue(queueName);
    }

    @Test
    public void testWildcardRoutingWithSingleHash() throws Exception {
        SimpleString addressAB = new SimpleString("a.b");
        SimpleString addressAC = new SimpleString("a.c");
        SimpleString address = new SimpleString("#");
        SimpleString queueName1 = new SimpleString("Q1");
        SimpleString queueName2 = new SimpleString("Q2");
        SimpleString queueName = new SimpleString("Q");
        this.clientSession.createQueue(new QueueConfiguration(queueName1).setAddress(addressAB).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName2).setAddress(addressAC).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(addressAB);
        ClientProducer producer2 = this.clientSession.createProducer(addressAC);
        ClientConsumer clientConsumer = this.clientSession.createConsumer(queueName);
        this.clientSession.start();
        producer.send((Message)this.createTextMessage(this.clientSession, "m1"));
        producer2.send((Message)this.createTextMessage(this.clientSession, "m2"));
        ClientMessage m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"m1", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"m2", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receiveImmediate();
        Assert.assertNull((Object)m);
    }

    @Test
    public void testWildcardRoutingWithHash() throws Exception {
        SimpleString addressAB = new SimpleString("a.b.f");
        SimpleString addressAC = new SimpleString("a.c.f");
        SimpleString address = new SimpleString("a.#.f");
        SimpleString queueName1 = new SimpleString("Q1");
        SimpleString queueName2 = new SimpleString("Q2");
        SimpleString queueName = new SimpleString("Q");
        this.clientSession.createQueue(new QueueConfiguration(queueName1).setAddress(addressAB).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName2).setAddress(addressAC).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(addressAB);
        ClientProducer producer2 = this.clientSession.createProducer(addressAC);
        ClientConsumer clientConsumer = this.clientSession.createConsumer(queueName);
        this.clientSession.start();
        producer.send((Message)this.createTextMessage(this.clientSession, "m1"));
        producer2.send((Message)this.createTextMessage(this.clientSession, "m2"));
        ClientMessage m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"m1", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"m2", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receiveImmediate();
        Assert.assertNull((Object)m);
    }

    @Test
    public void testWildcardRoutingWithHashMultiLengthAddresses() throws Exception {
        SimpleString addressAB = new SimpleString("a.b.c.f");
        SimpleString addressAC = new SimpleString("a.c.f");
        SimpleString address = new SimpleString("a.#.f");
        SimpleString queueName1 = new SimpleString("Q1");
        SimpleString queueName2 = new SimpleString("Q2");
        SimpleString queueName = new SimpleString("Q");
        this.clientSession.createQueue(new QueueConfiguration(queueName1).setAddress(addressAB).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName2).setAddress(addressAC).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(addressAB);
        ClientProducer producer2 = this.clientSession.createProducer(addressAC);
        ClientConsumer clientConsumer = this.clientSession.createConsumer(queueName);
        this.clientSession.start();
        producer.send((Message)this.createTextMessage(this.clientSession, "m1"));
        producer2.send((Message)this.createTextMessage(this.clientSession, "m2"));
        ClientMessage m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"m1", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"m2", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receiveImmediate();
        Assert.assertNull((Object)m);
    }

    @Test
    public void testWildcardRoutingWithDoubleStar() throws Exception {
        SimpleString addressAB = new SimpleString("a.b");
        SimpleString addressAC = new SimpleString("a.c");
        SimpleString address = new SimpleString("*.*");
        SimpleString queueName1 = new SimpleString("Q1");
        SimpleString queueName2 = new SimpleString("Q2");
        SimpleString queueName = new SimpleString("Q");
        this.clientSession.createQueue(new QueueConfiguration(queueName1).setAddress(addressAB).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName2).setAddress(addressAC).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(addressAB);
        ClientProducer producer2 = this.clientSession.createProducer(addressAC);
        ClientConsumer clientConsumer = this.clientSession.createConsumer(queueName);
        this.clientSession.start();
        producer.send((Message)this.createTextMessage(this.clientSession, "m1"));
        producer2.send((Message)this.createTextMessage(this.clientSession, "m2"));
        ClientMessage m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"m1", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"m2", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receiveImmediate();
        Assert.assertNull((Object)m);
    }

    @Test
    public void testWildcardRoutingPartialMatchStar() throws Exception {
        SimpleString addressAB = new SimpleString("a.b");
        SimpleString addressAC = new SimpleString("a.c");
        SimpleString address = new SimpleString("*.b");
        SimpleString queueName1 = new SimpleString("Q1");
        SimpleString queueName2 = new SimpleString("Q2");
        SimpleString queueName = new SimpleString("Q");
        this.clientSession.createQueue(new QueueConfiguration(queueName1).setAddress(addressAB).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName2).setAddress(addressAC).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(addressAB);
        ClientProducer producer2 = this.clientSession.createProducer(addressAC);
        ClientConsumer clientConsumer = this.clientSession.createConsumer(queueName);
        this.clientSession.start();
        producer.send((Message)this.createTextMessage(this.clientSession, "m1"));
        producer2.send((Message)this.createTextMessage(this.clientSession, "m2"));
        ClientMessage m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"m1", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receiveImmediate();
        Assert.assertNull((Object)m);
    }

    @Test
    public void testWildcardRoutingVariableLengths() throws Exception {
        SimpleString addressAB = new SimpleString("a.b.c");
        SimpleString addressAC = new SimpleString("a.c");
        SimpleString address = new SimpleString("a.#");
        SimpleString queueName1 = new SimpleString("Q1");
        SimpleString queueName2 = new SimpleString("Q2");
        SimpleString queueName = new SimpleString("Q");
        this.clientSession.createQueue(new QueueConfiguration(queueName1).setAddress(addressAB).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName2).setAddress(addressAC).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(addressAB);
        ClientProducer producer2 = this.clientSession.createProducer(addressAC);
        ClientConsumer clientConsumer = this.clientSession.createConsumer(queueName);
        this.clientSession.start();
        producer.send((Message)this.createTextMessage(this.clientSession, "m1"));
        producer2.send((Message)this.createTextMessage(this.clientSession, "m2"));
        ClientMessage m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"m1", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"m2", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
    }

    @Test
    public void testWildcardRoutingVariableLengthsStar() throws Exception {
        SimpleString addressAB = new SimpleString("a.b.c");
        SimpleString addressAC = new SimpleString("a.c");
        SimpleString address = new SimpleString("a.*");
        SimpleString queueName1 = new SimpleString("Q1");
        SimpleString queueName2 = new SimpleString("Q2");
        SimpleString queueName = new SimpleString("Q");
        this.clientSession.createQueue(new QueueConfiguration(queueName1).setAddress(addressAB).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName2).setAddress(addressAC).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(addressAB);
        ClientProducer producer2 = this.clientSession.createProducer(addressAC);
        ClientConsumer clientConsumer = this.clientSession.createConsumer(queueName);
        this.clientSession.start();
        producer.send((Message)this.createTextMessage(this.clientSession, "m1"));
        producer2.send((Message)this.createTextMessage(this.clientSession, "m2"));
        ClientMessage m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"m2", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receiveImmediate();
        Assert.assertNull((Object)m);
    }

    @Test
    public void testWildcardRoutingMultipleStars() throws Exception {
        SimpleString addressAB = new SimpleString("a.b.c");
        SimpleString addressAC = new SimpleString("a.c");
        SimpleString address = new SimpleString("*.*");
        SimpleString queueName1 = new SimpleString("Q1");
        SimpleString queueName2 = new SimpleString("Q2");
        SimpleString queueName = new SimpleString("Q");
        this.clientSession.createQueue(new QueueConfiguration(queueName1).setAddress(addressAB).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName2).setAddress(addressAC).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(addressAB);
        ClientProducer producer2 = this.clientSession.createProducer(addressAC);
        ClientConsumer clientConsumer = this.clientSession.createConsumer(queueName);
        this.clientSession.start();
        producer.send((Message)this.createTextMessage(this.clientSession, "m1"));
        producer2.send((Message)this.createTextMessage(this.clientSession, "m2"));
        ClientMessage m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"m2", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receiveImmediate();
        Assert.assertNull((Object)m);
    }

    @Test
    public void testWildcardRoutingStarInMiddle() throws Exception {
        SimpleString addressAB = new SimpleString("a.b.c");
        SimpleString addressAC = new SimpleString("a.c");
        SimpleString address = new SimpleString("*.b.*");
        SimpleString queueName1 = new SimpleString("Q1");
        SimpleString queueName2 = new SimpleString("Q2");
        SimpleString queueName = new SimpleString("Q");
        this.clientSession.createQueue(new QueueConfiguration(queueName1).setAddress(addressAB).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName2).setAddress(addressAC).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(addressAB);
        ClientProducer producer2 = this.clientSession.createProducer(addressAC);
        ClientConsumer clientConsumer = this.clientSession.createConsumer(queueName);
        this.clientSession.start();
        producer.send((Message)this.createTextMessage(this.clientSession, "m1"));
        producer2.send((Message)this.createTextMessage(this.clientSession, "m2"));
        ClientMessage m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"m1", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receiveImmediate();
        Assert.assertNull((Object)m);
    }

    @Test
    public void testWildcardRoutingStarAndHash() throws Exception {
        SimpleString addressAB = new SimpleString("a.b.c.d");
        SimpleString addressAC = new SimpleString("a.c");
        SimpleString address = new SimpleString("*.b.#");
        SimpleString queueName1 = new SimpleString("Q1");
        SimpleString queueName2 = new SimpleString("Q2");
        SimpleString queueName = new SimpleString("Q");
        this.clientSession.createQueue(new QueueConfiguration(queueName1).setAddress(addressAB).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName2).setAddress(addressAC).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(addressAB);
        ClientProducer producer2 = this.clientSession.createProducer(addressAC);
        ClientConsumer clientConsumer = this.clientSession.createConsumer(queueName);
        this.clientSession.start();
        producer.send((Message)this.createTextMessage(this.clientSession, "m1"));
        producer2.send((Message)this.createTextMessage(this.clientSession, "m2"));
        ClientMessage m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"m1", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receiveImmediate();
        Assert.assertNull((Object)m);
    }

    @Test
    public void testWildcardRoutingHashAndStar() throws Exception {
        SimpleString addressAB = new SimpleString("a.b.c");
        SimpleString addressAC = new SimpleString("a.c");
        SimpleString address = new SimpleString("#.b.*");
        SimpleString queueName1 = new SimpleString("Q1");
        SimpleString queueName2 = new SimpleString("Q2");
        SimpleString queueName = new SimpleString("Q");
        this.clientSession.createQueue(new QueueConfiguration(queueName1).setAddress(addressAB).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName2).setAddress(addressAC).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(addressAB);
        ClientProducer producer2 = this.clientSession.createProducer(addressAC);
        ClientConsumer clientConsumer = this.clientSession.createConsumer(queueName);
        this.clientSession.start();
        producer.send((Message)this.createTextMessage(this.clientSession, "m1"));
        producer2.send((Message)this.createTextMessage(this.clientSession, "m2"));
        ClientMessage m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"m1", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receiveImmediate();
        Assert.assertNull((Object)m);
    }

    @Test
    public void testLargeWildcardRouting() throws Exception {
        SimpleString addressAB = new SimpleString("a.b.c.d.e.f.g.h.i.j.k.l.m.n.o.p.q.r.s.t.u.v.w.x.y.z");
        SimpleString addressAC = new SimpleString("a.c");
        SimpleString address = new SimpleString("a.#");
        SimpleString queueName1 = new SimpleString("Q1");
        SimpleString queueName2 = new SimpleString("Q2");
        SimpleString queueName = new SimpleString("Q");
        this.clientSession.createQueue(new QueueConfiguration(queueName1).setAddress(addressAB).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName2).setAddress(addressAC).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(queueName).setAddress(address).setDurable(Boolean.valueOf(false)));
        Assert.assertEquals((long)2L, (long)this.server.getPostOffice().getBindingsForAddress(addressAB).getBindings().size());
        Assert.assertEquals((long)2L, (long)this.server.getPostOffice().getBindingsForAddress(addressAC).getBindings().size());
        Assert.assertEquals((long)1L, (long)this.server.getPostOffice().getBindingsForAddress(address).getBindings().size());
        ClientProducer producer = this.clientSession.createProducer(addressAB);
        ClientProducer producer2 = this.clientSession.createProducer(addressAC);
        ClientConsumer clientConsumer = this.clientSession.createConsumer(queueName);
        this.clientSession.start();
        producer.send((Message)this.createTextMessage(this.clientSession, "m1"));
        producer2.send((Message)this.createTextMessage(this.clientSession, "m2"));
        ClientMessage m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"m1", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"m2", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receiveImmediate();
        Assert.assertNull((Object)m);
        clientConsumer.close();
        this.clientSession.deleteQueue(queueName);
        Assert.assertEquals((long)1L, (long)this.server.getPostOffice().getBindingsForAddress(addressAB).getBindings().size());
        Assert.assertEquals((long)1L, (long)this.server.getPostOffice().getBindingsForAddress(addressAC).getBindings().size());
        Assert.assertEquals((long)0L, (long)this.server.getPostOffice().getBindingsForAddress(address).getBindings().size());
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        Configuration configuration = this.createDefaultInVMConfig().setWildcardRoutingEnabled(true).setTransactionTimeoutScanPeriod(500L);
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)configuration, (boolean)false));
        this.server.start();
        this.server.getManagementService().enableNotifications(false);
        this.locator = this.createInVMNonHALocator();
        this.sf = this.createSessionFactory(this.locator);
        this.clientSession = this.addClientSession(this.sf.createSession(false, true, true));
    }
}

