/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.util.HashMap;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTest;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTestBase;
import org.apache.activemq.artemis.tests.integration.cluster.failover.ReplicatedFailoverTest;
import org.apache.activemq.artemis.utils.RetryMethod;
import org.apache.activemq.artemis.utils.RetryRule;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class ReplicatedPagedFailoverTest
extends ReplicatedFailoverTest {
    @Rule
    public RetryRule retryRule = new RetryRule(0);

    protected ActiveMQServer createInVMFailoverServer(boolean realFiles, Configuration configuration, NodeManager nodeManager, int id) {
        return this.createInVMFailoverServer(realFiles, configuration, 1024, 2048, new HashMap(), nodeManager, id);
    }

    @Override
    @Test
    public void testFailWithBrowser() throws Exception {
        this.internalBrowser(0);
    }

    @Test
    public void testFailWithBrowserWithClose() throws Exception {
        this.internalBrowser(1);
    }

    @Test
    public void testFailWithBrowserWithDelete() throws Exception {
        this.internalBrowser(2);
    }

    @Override
    @RetryMethod(retries=2)
    @Test(timeout=120000L)
    public void testReplicatedFailback() throws Exception {
        super.testReplicatedFailback();
    }

    @Override
    @RetryMethod(retries=2)
    @Test(timeout=120000L)
    public void testFailoverOnInitialConnection() throws Exception {
        super.testFailoverOnInitialConnection();
    }

    private void internalBrowser(int temperMode) throws Exception {
        int numMessages = 50;
        int messagesPerPage = 10;
        int iterations = 10;
        this.createSessionFactory();
        ClientSession session = this.createSession((ClientSessionFactory)this.sf, true, true);
        session.createQueue(new QueueConfiguration(FailoverTestBase.ADDRESS).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        Queue queue = this.liveServer.getServer().locateQueue(FailoverTest.ADDRESS);
        for (int j = 0; j < iterations; ++j) {
            ClientMessage msg;
            ClientMessage msg2;
            System.err.println("#iteration " + j);
            queue.getPageSubscription().getPagingStore().startPaging();
            Assert.assertNotNull((Object)queue);
            for (int i = 0; i < numMessages; ++i) {
                producer.send((Message)this.createMessage(session, i, i % 2 == 0));
                if (i <= 0 || i % messagesPerPage != 0) continue;
                queue.getPageSubscription().getPagingStore().forceAnotherPage();
            }
            ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS, true);
            session.start();
            while ((msg2 = consumer.receive(500L)) != null) {
            }
            consumer.close();
            PagingStore store = queue.getPageSubscription().getPagingStore();
            if (temperMode == 1) {
                for (long pageID = store.getFirstPage(); pageID <= (long)(store.getCurrentPage().getPageId() + 10); ++pageID) {
                    this.liveServer.getServer().getStorageManager().pageClosed(store.getStoreName(), (int)pageID);
                }
            } else if (temperMode == 2) {
                for (long pageID = store.getFirstPage(); pageID <= (long)(store.getCurrentPage().getPageId() + 10); ++pageID) {
                    this.liveServer.getServer().getStorageManager().pageDeleted(store.getStoreName(), (int)pageID);
                }
            }
            store.getFirstPage();
            store.getCurrentPage().getPageId();
            consumer = session.createConsumer(FailoverTestBase.ADDRESS, false);
            session.start();
            while ((msg = consumer.receive(500L)) != null) {
                msg.acknowledge();
            }
            consumer.close();
            Wait.assertFalse(() -> ((PagingStore)queue.getPageSubscription().getPagingStore()).isPaging());
        }
    }
}

