/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.topology;

import java.util.Map;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.tests.integration.cluster.topology.TopologyClusterTestBase;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;

public class HAClientTopologyTest
extends TopologyClusterTestBase {
    @Override
    protected boolean isNetty() {
        return false;
    }

    @Override
    protected void setupCluster() throws Exception {
        this.setupCluster(MessageLoadBalancingType.ON_DEMAND);
    }

    protected void setupCluster(MessageLoadBalancingType messageLoadBalancingType) throws Exception {
        this.setupClusterConnection("cluster0", "queues", messageLoadBalancingType, 1, this.isNetty(), 0, 1, 2, 3, 4);
        this.setupClusterConnection("cluster1", "queues", messageLoadBalancingType, 1, this.isNetty(), 1, 0, 2, 3, 4);
        this.setupClusterConnection("cluster2", "queues", messageLoadBalancingType, 1, this.isNetty(), 2, 0, 1, 3, 4);
        this.setupClusterConnection("cluster3", "queues", messageLoadBalancingType, 1, this.isNetty(), 3, 0, 1, 2, 4);
        this.setupClusterConnection("cluster4", "queues", messageLoadBalancingType, 1, this.isNetty(), 4, 0, 1, 2, 3);
    }

    @Override
    protected void setupServers() throws Exception {
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
        this.setupServer(2, this.isFileStorage(), this.isNetty());
        this.setupServer(3, this.isFileStorage(), this.isNetty());
        this.setupServer(4, this.isFileStorage(), this.isNetty());
    }

    @Override
    protected ServerLocator createHAServerLocator() {
        TransportConfiguration tc = ActiveMQTestBase.createTransportConfiguration((boolean)this.isNetty(), (boolean)false, (Map)ActiveMQTestBase.generateParams((int)0, (boolean)this.isNetty()));
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithHA((TransportConfiguration[])new TransportConfiguration[]{tc}));
        locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true);
        return locator;
    }
}

