/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt.imported;

import org.apache.activemq.artemis.tests.integration.mqtt.imported.MQTTTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.fusesource.mqtt.client.BlockingConnection;
import org.fusesource.mqtt.client.MQTT;
import org.fusesource.mqtt.client.QoS;
import org.fusesource.mqtt.client.Topic;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTTSessionExpiryIntervalTest
extends MQTTTestSupport {
    private static final Logger log = LoggerFactory.getLogger(MQTTSessionExpiryIntervalTest.class);

    @Test(timeout=60000L)
    public void testCustomSessionExpiryInterval() throws Exception {
        MQTT mqttSub = this.createMQTTConnection("MQTT-Sub-Client", false);
        BlockingConnection connectionSub = mqttSub.blockingConnection();
        connectionSub.connect();
        MQTTSessionExpiryIntervalTest.assertEquals((long)1L, (long)this.getSessions().size());
        Topic[] topics = new Topic[]{new Topic("TopicA", QoS.EXACTLY_ONCE)};
        connectionSub.subscribe(topics);
        connectionSub.disconnect();
        Wait.assertEquals((int)0, () -> this.getSessions().size(), (long)10000L, (long)100L);
    }

    @Override
    protected void addMQTTConnector() throws Exception {
        this.server.getConfiguration().addAcceptorConfiguration("MQTT", "tcp://localhost:" + this.port + "?protocols=MQTT;anycastPrefix=anycast:;multicastPrefix=multicast:;defaultMqttSessionExpiryInterval=3");
        log.debug("Added MQTT connector to broker");
    }
}

