/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.jms.client;

import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.SelectorTranslator;
import org.junit.Assert;
import org.junit.Test;

public class SelectorTranslatorTest
extends ActiveMQTestBase {
    @Test
    public void testParseNull() {
        Assert.assertNull((Object)SelectorTranslator.convertToActiveMQFilterString(null));
    }

    @Test
    public void testParseSimple() {
        String selector = "color = 'red'";
        Assert.assertEquals((Object)"color = 'red'", (Object)SelectorTranslator.convertToActiveMQFilterString((String)"color = 'red'"));
    }

    @Test
    public void testParseMoreComplex() {
        String selector = "color = 'red' OR cheese = 'stilton' OR (age = 3 AND shoesize = 12)";
        Assert.assertEquals((Object)"color = 'red' OR cheese = 'stilton' OR (age = 3 AND shoesize = 12)", (Object)SelectorTranslator.convertToActiveMQFilterString((String)"color = 'red' OR cheese = 'stilton' OR (age = 3 AND shoesize = 12)"));
    }

    @Test
    public void testParseJMSDeliveryMode() {
        String selector = "JMSDeliveryMode='NON_PERSISTENT'";
        Assert.assertEquals((Object)"AMQDurable='NON_DURABLE'", (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = "JMSDeliveryMode='PERSISTENT'";
        Assert.assertEquals((Object)"AMQDurable='DURABLE'", (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = "color = 'red' AND 'NON_PERSISTENT' = JMSDeliveryMode";
        Assert.assertEquals((Object)"color = 'red' AND 'NON_DURABLE' = AMQDurable", (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = "color = 'red' AND 'PERSISTENT' = JMSDeliveryMode";
        Assert.assertEquals((Object)"color = 'red' AND 'DURABLE' = AMQDurable", (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        this.checkNoSubstitute("JMSDeliveryMode");
    }

    @Test
    public void testParseJMSPriority() {
        String selector = "JMSPriority=5";
        Assert.assertEquals((Object)"AMQPriority=5", (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = " JMSPriority = 7";
        Assert.assertEquals((Object)" AMQPriority = 7", (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = " JMSPriority = 7 OR 1 = JMSPriority AND (JMSPriority= 1 + 4)";
        Assert.assertEquals((Object)" AMQPriority = 7 OR 1 = AMQPriority AND (AMQPriority= 1 + 4)", (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        this.checkNoSubstitute("JMSPriority");
        selector = "animal = 'lion' JMSPriority = 321 OR animal_name = 'xyzJMSPriorityxyz'";
        Assert.assertEquals((Object)"animal = 'lion' AMQPriority = 321 OR animal_name = 'xyzJMSPriorityxyz'", (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
    }

    @Test
    public void testParseJMSMessageID() {
        String selector = "JMSMessageID='ID:AMQ-12435678";
        Assert.assertEquals((Object)"AMQUserID='ID:AMQ-12435678", (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = " JMSMessageID='ID:AMQ-12435678";
        Assert.assertEquals((Object)" AMQUserID='ID:AMQ-12435678", (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = " JMSMessageID = 'ID:AMQ-12435678";
        Assert.assertEquals((Object)" AMQUserID = 'ID:AMQ-12435678", (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = " myHeader = JMSMessageID";
        Assert.assertEquals((Object)" myHeader = AMQUserID", (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = " myHeader = JMSMessageID OR (JMSMessageID = 'ID-AMQ' + '12345')";
        Assert.assertEquals((Object)" myHeader = AMQUserID OR (AMQUserID = 'ID-AMQ' + '12345')", (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        this.checkNoSubstitute("JMSMessageID");
    }

    @Test
    public void testParseJMSTimestamp() {
        String selector = "JMSTimestamp=12345678";
        Assert.assertEquals((Object)"AMQTimestamp=12345678", (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = " JMSTimestamp=12345678";
        Assert.assertEquals((Object)" AMQTimestamp=12345678", (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = " JMSTimestamp=12345678 OR 78766 = JMSTimestamp AND (JMSTimestamp= 1 + 4878787)";
        Assert.assertEquals((Object)" AMQTimestamp=12345678 OR 78766 = AMQTimestamp AND (AMQTimestamp= 1 + 4878787)", (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        this.checkNoSubstitute("JMSTimestamp");
        selector = "animal = 'lion' JMSTimestamp = 321 OR animal_name = 'xyzJMSTimestampxyz'";
        Assert.assertEquals((Object)"animal = 'lion' AMQTimestamp = 321 OR animal_name = 'xyzJMSTimestampxyz'", (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
    }

    @Test
    public void testParseJMSExpiration() {
        String selector = "JMSExpiration=12345678";
        Assert.assertEquals((Object)"AMQExpiration=12345678", (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = " JMSExpiration=12345678";
        Assert.assertEquals((Object)" AMQExpiration=12345678", (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = " JMSExpiration=12345678 OR 78766 = JMSExpiration AND (JMSExpiration= 1 + 4878787)";
        Assert.assertEquals((Object)" AMQExpiration=12345678 OR 78766 = AMQExpiration AND (AMQExpiration= 1 + 4878787)", (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        this.checkNoSubstitute("JMSExpiration");
        selector = "animal = 'lion' JMSExpiration = 321 OR animal_name = 'xyzJMSExpirationxyz'";
        Assert.assertEquals((Object)"animal = 'lion' AMQExpiration = 321 OR animal_name = 'xyzJMSExpirationxyz'", (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
    }

    @Test
    public void testParseJMSCorrelationID() {
        String selector = "JMSCorrelationID='ID:AMQ-12435678";
        Assert.assertEquals((Object)selector, (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = " JMSCorrelationID='ID:AMQ-12435678";
        Assert.assertEquals((Object)selector, (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = " JMSCorrelationID = 'ID:AMQ-12435678";
        Assert.assertEquals((Object)selector, (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = " myHeader = JMSCorrelationID";
        Assert.assertEquals((Object)selector, (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = " myHeader = JMSCorrelationID OR (JMSCorrelationID = 'ID-AMQ' + '12345')";
        Assert.assertEquals((Object)selector, (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        this.checkNoSubstitute("JMSCorrelationID");
    }

    @Test
    public void testParseJMSType() {
        String selector = "JMSType='aardvark'";
        Assert.assertEquals((Object)selector, (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = " JMSType='aardvark'";
        Assert.assertEquals((Object)selector, (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = " JMSType = 'aardvark'";
        Assert.assertEquals((Object)selector, (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = " myHeader = JMSType";
        Assert.assertEquals((Object)selector, (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = " myHeader = JMSType OR (JMSType = 'aardvark' + 'sandwich')";
        Assert.assertEquals((Object)selector, (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        this.checkNoSubstitute("JMSType");
    }

    @Test
    public void testConvertHQFilterString() {
        String selector = "HQUserID = 'ID:AMQ-12435678'";
        Assert.assertEquals((Object)"AMQUserID = 'ID:AMQ-12435678'", (Object)SelectorTranslator.convertHQToActiveMQFilterString((String)selector));
        selector = "HQUserID = 'HQUserID'";
        Assert.assertEquals((Object)"AMQUserID = 'HQUserID'", (Object)SelectorTranslator.convertHQToActiveMQFilterString((String)selector));
        selector = "HQUserID = 'ID:AMQ-12435678'";
        Assert.assertEquals((Object)"AMQUserID = 'ID:AMQ-12435678'", (Object)SelectorTranslator.convertHQToActiveMQFilterString((String)selector));
        selector = "HQDurable='NON_DURABLE'";
        Assert.assertEquals((Object)"AMQDurable='NON_DURABLE'", (Object)SelectorTranslator.convertHQToActiveMQFilterString((String)selector));
        selector = "HQPriority=5";
        Assert.assertEquals((Object)"AMQPriority=5", (Object)SelectorTranslator.convertHQToActiveMQFilterString((String)selector));
        selector = "HQTimestamp=12345678";
        Assert.assertEquals((Object)"AMQTimestamp=12345678", (Object)SelectorTranslator.convertHQToActiveMQFilterString((String)selector));
        selector = "HQExpiration=12345678";
        Assert.assertEquals((Object)"AMQExpiration=12345678", (Object)SelectorTranslator.convertHQToActiveMQFilterString((String)selector));
    }

    private void checkNoSubstitute(String fieldName) {
        String selector = "Other" + fieldName + " = 767868";
        Assert.assertEquals((Object)selector, (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = "cheese = 'cheddar' AND Wrong" + fieldName + " = 54";
        Assert.assertEquals((Object)selector, (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = "fruit = 'pomegranate' AND " + fieldName + "NotThisOne = 'tuesday'";
        Assert.assertEquals((Object)selector, (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = "animal = 'lion' AND animal_name = '" + fieldName + "'";
        Assert.assertEquals((Object)selector, (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = "animal = 'lion' AND animal_name = ' " + fieldName + "'";
        Assert.assertEquals((Object)selector, (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = "animal = 'lion' AND animal_name = ' " + fieldName + " '";
        Assert.assertEquals((Object)selector, (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = "animal = 'lion' AND animal_name = 'xyz " + fieldName + "'";
        Assert.assertEquals((Object)selector, (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = "animal = 'lion' AND animal_name = 'xyz" + fieldName + "'";
        Assert.assertEquals((Object)selector, (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = "animal = 'lion' AND animal_name = '" + fieldName + "xyz'";
        Assert.assertEquals((Object)selector, (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = "animal = 'lion' AND animal_name = 'xyz" + fieldName + "xyz'";
        Assert.assertEquals((Object)selector, (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
    }
}

