/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jboss.as.clustering.jgroups.subsystem.SocketProtocolConfigurationServiceConfigurator;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.network.ClientMapping;
import org.jboss.as.network.SocketBinding;
import org.jgroups.protocols.FD_SOCK;

public class LegacyFailureDetectionProtocolConfigurationServiceConfigurator
extends SocketProtocolConfigurationServiceConfigurator<FD_SOCK> {
    public LegacyFailureDetectionProtocolConfigurationServiceConfigurator(PathAddress address) {
        super(address);
    }

    public Map<String, SocketBinding> getSocketBindings() {
        SocketBinding clientBinding;
        TreeMap<String, SocketBinding> result = new TreeMap<String, SocketBinding>();
        SocketBinding binding = this.getSocketBinding();
        if (binding != null) {
            result.put("jgroups.fd_sock.srv_sock", binding);
        }
        if ((clientBinding = this.getClientSocketBinding()) != null) {
            result.put("jgroups.fd.ping_sock", clientBinding);
        }
        return result;
    }

    @Override
    public void accept(FD_SOCK protocol) {
        SocketBinding clientBinding;
        SocketBinding binding = this.getSocketBinding();
        protocol.setStartPort(binding != null ? binding.getPort() : 0);
        if (binding != null) {
            protocol.setBindAddress(binding.getAddress());
            List clientMappings = binding.getClientMappings();
            if (!clientMappings.isEmpty()) {
                ClientMapping mapping = (ClientMapping)clientMappings.get(0);
                try {
                    protocol.setExternalAddress(InetAddress.getByName(mapping.getDestinationAddress()));
                    protocol.setExternalPort(mapping.getDestinationPort());
                }
                catch (UnknownHostException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
        if ((clientBinding = this.getClientSocketBinding()) != null) {
            protocol.setClientBindPort(clientBinding.getSocketAddress().getPort());
        }
    }
}

