/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.cfg.AnnotatedJoinColumn;
import org.hibernate.cfg.FkSecondPass;
import org.hibernate.cfg.annotations.TableBinder;
import org.hibernate.mapping.JoinedSubclass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.SimpleValue;

public class JoinedSubclassFkSecondPass
extends FkSecondPass {
    private final JoinedSubclass entity;
    private final MetadataBuildingContext buildingContext;

    public JoinedSubclassFkSecondPass(JoinedSubclass entity, AnnotatedJoinColumn[] inheritanceJoinedColumns, SimpleValue key, MetadataBuildingContext buildingContext) {
        super(key, inheritanceJoinedColumns);
        this.entity = entity;
        this.buildingContext = buildingContext;
    }

    @Override
    public String getReferencedEntityName() {
        return this.entity.getSuperclass().getEntityName();
    }

    @Override
    public boolean isInPrimaryKey() {
        return true;
    }

    @Override
    public void doSecondPass(Map<String, PersistentClass> persistentClasses) throws MappingException {
        TableBinder.bindFk(this.entity.getSuperclass(), this.entity, this.columns, this.value, false, this.buildingContext);
    }
}

