/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import jakarta.persistence.ForeignKey;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.MappingException;
import org.hibernate.annotations.LazyGroup;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.cfg.AnnotatedJoinColumn;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.PropertyData;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.SecondPass;
import org.hibernate.cfg.ToOneBinder;
import org.hibernate.cfg.ToOneFkSecondPass;
import org.hibernate.cfg.annotations.PropertyBinder;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SortableValue;
import org.hibernate.type.ForeignKeyDirection;

public class OneToOneSecondPass
implements SecondPass {
    private final MetadataBuildingContext buildingContext;
    private final String mappedBy;
    private final String ownerEntity;
    private final String ownerProperty;
    private final PropertyHolder propertyHolder;
    private final NotFoundAction notFoundAction;
    private final PropertyData inferredData;
    private final XClass targetEntity;
    private final boolean cascadeOnDelete;
    private final boolean optional;
    private final String cascadeStrategy;
    private final AnnotatedJoinColumn[] joinColumns;

    public OneToOneSecondPass(String mappedBy, String ownerEntity, String ownerProperty, PropertyHolder propertyHolder, PropertyData inferredData, XClass targetEntity, NotFoundAction notFoundAction, boolean cascadeOnDelete, boolean optional, String cascadeStrategy, AnnotatedJoinColumn[] columns, MetadataBuildingContext buildingContext) {
        this.ownerEntity = ownerEntity;
        this.ownerProperty = ownerProperty;
        this.mappedBy = mappedBy;
        this.propertyHolder = propertyHolder;
        this.buildingContext = buildingContext;
        this.notFoundAction = notFoundAction;
        this.inferredData = inferredData;
        this.targetEntity = targetEntity;
        this.cascadeOnDelete = cascadeOnDelete;
        this.optional = optional;
        this.cascadeStrategy = cascadeStrategy;
        this.joinColumns = columns;
    }

    @Override
    public void doSecondPass(Map<String, PersistentClass> persistentClasses) throws MappingException {
        OneToOne value = new OneToOne(this.buildingContext, this.propertyHolder.getTable(), this.propertyHolder.getPersistentClass());
        String propertyName = this.inferredData.getPropertyName();
        value.setPropertyName(propertyName);
        String referencedEntityName = ToOneBinder.getReferenceEntityName(this.inferredData, this.targetEntity, this.buildingContext);
        value.setReferencedEntityName(referencedEntityName);
        AnnotationBinder.defineFetchingStrategy(value, this.inferredData.getProperty());
        value.setCascadeDeleteEnabled(this.cascadeOnDelete);
        value.setConstrained(!this.optional);
        ForeignKeyDirection foreignKeyDirection = !BinderHelper.isEmptyAnnotationValue(this.mappedBy) ? ForeignKeyDirection.TO_PARENT : ForeignKeyDirection.FROM_PARENT;
        value.setForeignKeyType(foreignKeyDirection);
        AnnotationBinder.bindForeignKeyNameAndDefinition(value, this.inferredData.getProperty(), (ForeignKey)this.inferredData.getProperty().getAnnotation(ForeignKey.class), (JoinColumn)this.inferredData.getProperty().getAnnotation(JoinColumn.class), (JoinColumns)this.inferredData.getProperty().getAnnotation(JoinColumns.class), this.buildingContext);
        PropertyBinder binder = new PropertyBinder();
        binder.setName(propertyName);
        binder.setProperty(this.inferredData.getProperty());
        binder.setValue(value);
        binder.setCascade(this.cascadeStrategy);
        binder.setAccessType(this.inferredData.getDefaultAccess());
        LazyGroup lazyGroupAnnotation = (LazyGroup)this.inferredData.getProperty().getAnnotation(LazyGroup.class);
        if (lazyGroupAnnotation != null) {
            binder.setLazyGroup(lazyGroupAnnotation.value());
        }
        Property prop = binder.makeProperty();
        prop.setOptional(this.optional);
        if (BinderHelper.isEmptyAnnotationValue(this.mappedBy)) {
            boolean rightOrder = true;
            if (rightOrder) {
                String path = StringHelper.qualify(this.propertyHolder.getPath(), propertyName);
                ToOneFkSecondPass secondPass = new ToOneFkSecondPass(value, this.joinColumns, !this.optional, this.propertyHolder.getEntityOwnerClassName(), path, this.buildingContext);
                secondPass.doSecondPass(persistentClasses);
                this.propertyHolder.addProperty(prop, this.inferredData.getDeclaringClass());
            }
        } else {
            Property otherSideProperty;
            value.setMappedByProperty(this.mappedBy);
            PersistentClass otherSide = persistentClasses.get(value.getReferencedEntityName());
            try {
                if (otherSide == null) {
                    throw new MappingException("Unable to find entity: " + value.getReferencedEntityName());
                }
                otherSideProperty = BinderHelper.findPropertyByName(otherSide, this.mappedBy);
            }
            catch (MappingException e) {
                throw new AnnotationException("Unknown mappedBy in: " + StringHelper.qualify(this.ownerEntity, this.ownerProperty) + ", referenced property unknown: " + StringHelper.qualify(value.getReferencedEntityName(), this.mappedBy));
            }
            if (otherSideProperty == null) {
                throw new AnnotationException("Unknown mappedBy in: " + StringHelper.qualify(this.ownerEntity, this.ownerProperty) + ", referenced property unknown: " + StringHelper.qualify(value.getReferencedEntityName(), this.mappedBy));
            }
            if (otherSideProperty.getValue() instanceof OneToOne) {
                this.propertyHolder.addProperty(prop, this.inferredData.getDeclaringClass());
            } else if (otherSideProperty.getValue() instanceof ManyToOne) {
                Join otherSideJoin = null;
                for (Join otherSideJoinValue : otherSide.getJoins()) {
                    if (!otherSideJoinValue.containsProperty(otherSideProperty)) continue;
                    otherSideJoin = otherSideJoinValue;
                    break;
                }
                if (otherSideJoin != null) {
                    Join mappedByJoin = this.buildJoinFromMappedBySide(persistentClasses.get(this.ownerEntity), otherSideProperty, otherSideJoin);
                    ManyToOne manyToOne = new ManyToOne(this.buildingContext, mappedByJoin.getTable());
                    manyToOne.setNotFoundAction(this.notFoundAction);
                    manyToOne.setCascadeDeleteEnabled(value.isCascadeDeleteEnabled());
                    manyToOne.setFetchMode(value.getFetchMode());
                    manyToOne.setLazy(value.isLazy());
                    manyToOne.setReferencedEntityName(value.getReferencedEntityName());
                    manyToOne.setUnwrapProxy(value.isUnwrapProxy());
                    manyToOne.markAsLogicalOneToOne();
                    prop.setValue(manyToOne);
                    for (Column column : otherSideJoin.getKey().getColumns()) {
                        Column copy = new Column();
                        copy.setLength(column.getLength());
                        copy.setScale(column.getScale());
                        copy.setValue(manyToOne);
                        copy.setName(column.getQuotedName());
                        copy.setNullable(column.isNullable());
                        copy.setPrecision(column.getPrecision());
                        copy.setUnique(column.isUnique());
                        copy.setSqlType(column.getSqlType());
                        copy.setCheckConstraint(column.getCheckConstraint());
                        copy.setComment(column.getComment());
                        copy.setDefaultValue(column.getDefaultValue());
                        copy.setGeneratedAs(column.getGeneratedAs());
                        manyToOne.addColumn(copy);
                    }
                    mappedByJoin.addProperty(prop);
                } else {
                    this.propertyHolder.addProperty(prop, this.inferredData.getDeclaringClass());
                }
                value.setReferencedPropertyName(this.mappedBy);
                boolean referenceToPrimaryKey = this.mappedBy == null || otherSide.getIdentifier() instanceof Component && !((Component)otherSide.getIdentifier()).hasProperty(this.mappedBy);
                value.setReferenceToPrimaryKey(referenceToPrimaryKey);
                String propertyRef = value.getReferencedPropertyName();
                if (propertyRef != null) {
                    this.buildingContext.getMetadataCollector().addUniquePropertyReference(value.getReferencedEntityName(), propertyRef);
                }
            } else {
                throw new AnnotationException("Referenced property not a (One|Many)ToOne: " + StringHelper.qualify(otherSide.getEntityName(), this.mappedBy) + " in mappedBy of " + StringHelper.qualify(this.ownerEntity, this.ownerProperty));
            }
        }
        value.sortProperties();
    }

    private Join buildJoinFromMappedBySide(PersistentClass persistentClass, Property otherSideProperty, Join originalJoin) {
        Join join = new Join();
        join.setPersistentClass(persistentClass);
        join.setTable(originalJoin.getTable());
        join.setInverse(true);
        DependantValue key = new DependantValue(this.buildingContext, join.getTable(), persistentClass.getIdentifier());
        if (this.notFoundAction != null) {
            join.disableForeignKeyCreation();
        }
        join.setKey(key);
        join.setSequentialSelect(false);
        join.setOptional(true);
        key.setCascadeDeleteEnabled(false);
        for (Column column : otherSideProperty.getValue().getColumns()) {
            Column copy = new Column();
            copy.setLength(column.getLength());
            copy.setScale(column.getScale());
            copy.setValue(key);
            copy.setName(column.getQuotedName());
            copy.setNullable(column.isNullable());
            copy.setPrecision(column.getPrecision());
            copy.setUnique(column.isUnique());
            copy.setSqlType(column.getSqlType());
            copy.setCheckConstraint(column.getCheckConstraint());
            copy.setComment(column.getComment());
            copy.setDefaultValue(column.getDefaultValue());
            column.setGeneratedAs(column.getGeneratedAs());
            key.addColumn(copy);
        }
        if (otherSideProperty.getValue() instanceof SortableValue && !((SortableValue)((Object)otherSideProperty.getValue())).isSorted()) {
            key.sortProperties();
        }
        persistentClass.addJoin(join);
        return join;
    }
}

