/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.select;

import jakarta.persistence.Tuple;
import jakarta.persistence.criteria.CompoundSelection;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.ParameterExpression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Selection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.query.criteria.JpaCriteriaQuery;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaQueryPart;
import org.hibernate.query.criteria.JpaSelection;
import org.hibernate.query.sqm.FetchClauseType;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmQuerySource;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.cte.SqmCteStatement;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.expression.ValueBindJpaCriteriaParameter;
import org.hibernate.query.sqm.tree.from.SqmFromClause;
import org.hibernate.query.sqm.tree.jpa.ParameterCollector;
import org.hibernate.query.sqm.tree.select.AbstractSqmSelectQuery;
import org.hibernate.query.sqm.tree.select.SqmOrderByClause;
import org.hibernate.query.sqm.tree.select.SqmQueryGroup;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectClause;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.query.sqm.tree.select.SqmSortSpecification;
import org.hibernate.query.sqm.tree.select.SqmSubQuery;

public class SqmSelectStatement<T>
extends AbstractSqmSelectQuery<T>
implements JpaCriteriaQuery<T>,
SqmStatement<T>,
org.hibernate.query.sqm.internal.ParameterCollector {
    private final SqmQuerySource querySource;
    private Set<SqmParameter<?>> parameters;

    public SqmSelectStatement(NodeBuilder nodeBuilder) {
        this(SqmQuerySource.HQL, nodeBuilder);
    }

    public SqmSelectStatement(SqmQuerySource querySource, NodeBuilder nodeBuilder) {
        super(null, nodeBuilder);
        this.querySource = querySource;
    }

    public SqmSelectStatement(Class<T> resultJavaType, SqmQuerySource querySource, NodeBuilder nodeBuilder) {
        super(resultJavaType, nodeBuilder);
        this.querySource = querySource;
    }

    public SqmSelectStatement(SqmQueryPart<T> queryPart, Class<T> resultType, SqmQuerySource querySource, NodeBuilder builder) {
        super(queryPart, resultType, builder);
        this.querySource = querySource;
    }

    public SqmSelectStatement(Class<T> resultJavaType, NodeBuilder nodeBuilder) {
        super(resultJavaType, nodeBuilder);
        this.querySource = SqmQuerySource.CRITERIA;
        ((SqmQuerySpec)this.getQuerySpec()).setSelectClause(new SqmSelectClause(false, nodeBuilder));
        ((SqmQuerySpec)this.getQuerySpec()).setFromClause(new SqmFromClause());
    }

    private SqmSelectStatement(NodeBuilder builder, Map<String, SqmCteStatement<?>> cteStatements, boolean withRecursive, Class<T> resultType, SqmQuerySource querySource, Set<SqmParameter<?>> parameters) {
        super(builder, cteStatements, withRecursive, resultType);
        this.querySource = querySource;
        this.parameters = parameters;
    }

    @Override
    public SqmSelectStatement<T> copy(SqmCopyContext context) {
        HashSet parameters;
        SqmSelectStatement existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        if (this.parameters == null) {
            parameters = null;
        } else {
            parameters = new HashSet(this.parameters.size());
            for (SqmParameter<?> parameter : this.parameters) {
                parameters.add((SqmParameter<?>)parameter.copy(context));
            }
        }
        SqmSelectStatement statement = context.registerCopy(this, new SqmSelectStatement(this.nodeBuilder(), this.copyCteStatements(context), this.isWithRecursive(), this.getResultType(), this.getQuerySource(), parameters));
        statement.setQueryPart(((SqmQueryPart)this.getQueryPart()).copy(context));
        return statement;
    }

    @Override
    public SqmQuerySource getQuerySource() {
        return this.querySource;
    }

    @Override
    public SqmQuerySpec<T> getQuerySpec() {
        if (this.querySource == SqmQuerySource.CRITERIA) {
            JpaQueryPart queryPart = this.getQueryPart();
            if (queryPart instanceof SqmQuerySpec) {
                return (SqmQuerySpec)queryPart;
            }
            throw new IllegalStateException("Query group can't be treated as query spec. Use JpaSelectCriteria#getQueryPart to access query group details");
        }
        return super.getQuerySpec();
    }

    public boolean containsCollectionFetches() {
        return this.containsCollectionFetches((SqmQueryPart<?>)this.getQueryPart());
    }

    private boolean containsCollectionFetches(SqmQueryPart<?> queryPart) {
        if (queryPart instanceof SqmQuerySpec) {
            return ((SqmQuerySpec)queryPart).containsCollectionFetches();
        }
        SqmQueryGroup queryGroup = (SqmQueryGroup)queryPart;
        return this.containsCollectionFetches(queryGroup.getQueryParts().get(0));
    }

    public boolean usesDistinct() {
        return this.usesDistinct((SqmQueryPart<?>)this.getQueryPart());
    }

    private boolean usesDistinct(SqmQueryPart<?> queryPart) {
        if (queryPart instanceof SqmQuerySpec) {
            return ((SqmQuerySpec)queryPart).getSelectClause().isDistinct();
        }
        SqmQueryGroup queryGroup = (SqmQueryGroup)queryPart;
        return this.usesDistinct(queryGroup.getQueryParts().get(0));
    }

    @Override
    public Set<SqmParameter<?>> getSqmParameters() {
        if (this.querySource == SqmQuerySource.CRITERIA) {
            assert (this.parameters == null) : "SqmSelectStatement (as Criteria) should not have collected parameters";
            return ParameterCollector.collectParameters(this, sqmParameter -> {}, this.nodeBuilder().getServiceRegistry());
        }
        return this.parameters == null ? Collections.emptySet() : Collections.unmodifiableSet(this.parameters);
    }

    @Override
    public SqmStatement.ParameterResolutions resolveParameters() {
        return SqmUtil.resolveParameters(this);
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitSelectStatement(this);
    }

    @Override
    public void addParameter(SqmParameter<?> parameter) {
        if (this.parameters == null) {
            this.parameters = new HashSet();
        }
        this.parameters.add(parameter);
    }

    @Override
    public SqmSelectStatement<T> distinct(boolean distinct) {
        return (SqmSelectStatement)super.distinct(distinct);
    }

    @Override
    public Set<ParameterExpression<?>> getParameters() {
        assert (this.querySource == SqmQuerySource.CRITERIA);
        Set<SqmParameter<?>> sqmParameters = this.getSqmParameters();
        return sqmParameters.stream().filter(parameterExpression -> !(parameterExpression instanceof ValueBindJpaCriteriaParameter)).collect(Collectors.toSet());
    }

    @Override
    public SqmSelectStatement<T> select(Selection<? extends T> selection) {
        if (this.nodeBuilder().getDomainModel().getJpaCompliance().isJpaQueryComplianceEnabled()) {
            this.checkSelectionIsJpaCompliant(selection);
        }
        ((SqmQuerySpec)this.getQuerySpec()).setSelection((JpaSelection)selection);
        if (this.getResultType() == Object.class) {
            this.setResultType(selection.getJavaType());
        }
        return this;
    }

    @Override
    public SqmSelectStatement<T> multiselect(Selection<?> ... selections) {
        CompoundSelection resultSelection;
        Class resultType;
        if (this.nodeBuilder().getDomainModel().getJpaCompliance().isJpaQueryComplianceEnabled()) {
            for (Selection<?> selection : selections) {
                this.checkSelectionIsJpaCompliant(selection);
            }
        }
        if ((resultType = this.getResultType()) == null || resultType == Object.class) {
            switch (selections.length) {
                case 0: {
                    throw new IllegalArgumentException("empty selections passed to criteria query typed as Object");
                }
                case 1: {
                    resultSelection = selections[0];
                    break;
                }
                default: {
                    this.setResultType(Object[].class);
                    resultSelection = this.nodeBuilder().array((Selection[])selections);
                    break;
                }
            }
        } else {
            resultSelection = Tuple.class.isAssignableFrom(resultType) ? this.nodeBuilder().tuple((Selection[])selections) : (resultType.isArray() ? this.nodeBuilder().array(resultType, selections) : this.nodeBuilder().construct(resultType, (Selection[])selections));
        }
        ((SqmQuerySpec)this.getQuerySpec()).getSelectClause().setSelection((SqmSelectableNode)resultSelection);
        return this;
    }

    @Override
    public SqmSelectStatement<T> multiselect(List<Selection<?>> selectionList) {
        Selection<?> resultSelection;
        if (this.nodeBuilder().getDomainModel().getJpaCompliance().isJpaQueryComplianceEnabled()) {
            for (Selection<?> selection : selectionList) {
                this.checkSelectionIsJpaCompliant(selection);
            }
        }
        Class resultType = this.getResultType();
        List<Selection<?>> selections = selectionList;
        if (resultType == null || resultType == Object.class) {
            switch (selections.size()) {
                case 0: {
                    throw new IllegalArgumentException("empty selections passed to criteria query typed as Object");
                }
                case 1: {
                    resultSelection = selections.get(0);
                    break;
                }
                default: {
                    this.setResultType(Object[].class);
                    resultSelection = this.nodeBuilder().array(selections);
                    break;
                }
            }
        } else {
            resultSelection = Tuple.class.isAssignableFrom(resultType) ? this.nodeBuilder().tuple(selections) : (resultType.isArray() ? this.nodeBuilder().array(resultType, selections) : this.nodeBuilder().construct(resultType, selections));
        }
        ((SqmQuerySpec)this.getQuerySpec()).getSelectClause().setSelection((SqmSelectableNode)resultSelection);
        return this;
    }

    private void checkSelectionIsJpaCompliant(Selection<?> selection) {
        if (selection instanceof SqmSubQuery) {
            throw new IllegalStateException("The JPA specification does not support subqueries in select clauses. Please disable the JPA query compliance if you want to use this feature.");
        }
    }

    @Override
    public SqmSelectStatement<T> orderBy(Order ... orders) {
        SqmOrderByClause sqmOrderByClause = new SqmOrderByClause(orders.length);
        for (Order order : orders) {
            sqmOrderByClause.addSortSpecification((SqmSortSpecification)order);
        }
        ((SqmQueryPart)this.getQueryPart()).setOrderByClause(sqmOrderByClause);
        return this;
    }

    @Override
    public SqmSelectStatement<T> orderBy(List<Order> orders) {
        SqmOrderByClause sqmOrderByClause = new SqmOrderByClause(orders.size());
        for (Order order : orders) {
            sqmOrderByClause.addSortSpecification((SqmSortSpecification)order);
        }
        ((SqmQueryPart)this.getQueryPart()).setOrderByClause(sqmOrderByClause);
        return this;
    }

    public <U> SqmSubQuery<U> subquery(Class<U> type) {
        return new SqmSubQuery<U>(this, type, this.nodeBuilder());
    }

    @Override
    public SqmSelectStatement<T> where(Expression<Boolean> restriction) {
        return (SqmSelectStatement)super.where((Expression)restriction);
    }

    @Override
    public SqmSelectStatement<T> where(Predicate ... restrictions) {
        return (SqmSelectStatement)super.where(restrictions);
    }

    @Override
    public SqmSelectStatement<T> groupBy(Expression<?> ... expressions) {
        return (SqmSelectStatement)super.groupBy((Expression[])expressions);
    }

    @Override
    public SqmSelectStatement<T> groupBy(List<Expression<?>> grouping) {
        return (SqmSelectStatement)super.groupBy((List)grouping);
    }

    @Override
    public SqmSelectStatement<T> having(Expression<Boolean> booleanExpression) {
        return (SqmSelectStatement)super.having((Expression)booleanExpression);
    }

    @Override
    public SqmSelectStatement<T> having(Predicate ... predicates) {
        return (SqmSelectStatement)super.having(predicates);
    }

    @Override
    public JpaExpression<Number> getOffset() {
        return ((SqmQueryPart)this.getQueryPart()).getOffset();
    }

    @Override
    public JpaCriteriaQuery<T> offset(JpaExpression<? extends Number> offset) {
        this.validateComplianceFetchOffset();
        ((SqmQueryPart)this.getQueryPart()).setOffset((JpaExpression)offset);
        return this;
    }

    @Override
    public JpaCriteriaQuery<T> offset(Number offset) {
        this.validateComplianceFetchOffset();
        ((SqmQueryPart)this.getQueryPart()).setOffset(this.nodeBuilder().value(offset));
        return this;
    }

    @Override
    public JpaExpression<Number> getFetch() {
        return ((SqmQueryPart)this.getQueryPart()).getFetch();
    }

    @Override
    public JpaCriteriaQuery<T> fetch(JpaExpression<? extends Number> fetch) {
        this.validateComplianceFetchOffset();
        ((SqmQueryPart)this.getQueryPart()).setFetch((JpaExpression)fetch);
        return this;
    }

    @Override
    public JpaCriteriaQuery<T> fetch(JpaExpression<? extends Number> fetch, FetchClauseType fetchClauseType) {
        this.validateComplianceFetchOffset();
        ((SqmQueryPart)this.getQueryPart()).setFetch(fetch, fetchClauseType);
        return this;
    }

    @Override
    public JpaCriteriaQuery<T> fetch(Number fetch) {
        this.validateComplianceFetchOffset();
        ((SqmQueryPart)this.getQueryPart()).setFetch(this.nodeBuilder().value(fetch));
        return this;
    }

    @Override
    public JpaCriteriaQuery<T> fetch(Number fetch, FetchClauseType fetchClauseType) {
        this.validateComplianceFetchOffset();
        ((SqmQueryPart)this.getQueryPart()).setFetch(this.nodeBuilder().value(fetch), fetchClauseType);
        return this;
    }

    @Override
    public FetchClauseType getFetchClauseType() {
        return ((SqmQueryPart)this.getQueryPart()).getFetchClauseType();
    }

    private void validateComplianceFetchOffset() {
        if (this.nodeBuilder().getDomainModel().getJpaCompliance().isJpaQueryComplianceEnabled()) {
            throw new IllegalStateException("The JPA specification does not support the fetch or offset clause. Please disable the JPA query compliance if you want to use this feature.");
        }
    }
}

