/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spi;

import org.hibernate.Incubating;
import org.hibernate.spi.NavigablePath;

@Incubating
public class TreatedNavigablePath
extends NavigablePath {
    public TreatedNavigablePath(NavigablePath parent, String entityTypeName) {
        this(parent, entityTypeName, null);
    }

    public TreatedNavigablePath(NavigablePath parent, String entityTypeName, String alias) {
        super(parent, entityTypeName, alias, "treat(" + parent + " as " + entityTypeName + ")", TreatedNavigablePath::calculateTreatedFullPath, 1);
        assert (!(parent instanceof TreatedNavigablePath));
    }

    protected static String calculateTreatedFullPath(NavigablePath parent, String localName, String alias) {
        return alias == null ? "treat(" + parent + " as " + localName + ")" : "treat(" + parent + " as " + localName + ")(" + alias + ")";
    }

    @Override
    public NavigablePath treatAs(String entityName) {
        return new TreatedNavigablePath(this.getRealParent(), entityName);
    }

    @Override
    public NavigablePath treatAs(String entityName, String alias) {
        return new TreatedNavigablePath(this.getRealParent(), entityName, alias);
    }
}

