/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.spi;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.query.ResultListTransformer;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.results.internal.RowProcessingStateStandardImpl;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesSourceProcessingStateStandardImpl;
import org.hibernate.sql.results.jdbc.spi.JdbcValues;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.spi.ResultsConsumer;
import org.hibernate.sql.results.spi.RowReader;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.EntityJavaType;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class ListResultsConsumer<R>
implements ResultsConsumer<List<R>, R> {
    private static final ListResultsConsumer<?> NEVER_DE_DUP_CONSUMER = new ListResultsConsumer(UniqueSemantic.NEVER);
    private static final ListResultsConsumer<?> ALLOW_DE_DUP_CONSUMER = new ListResultsConsumer(UniqueSemantic.ALLOW);
    private static final ListResultsConsumer<?> IGNORE_DUP_CONSUMER = new ListResultsConsumer(UniqueSemantic.NONE);
    private static final ListResultsConsumer<?> DE_DUP_CONSUMER = new ListResultsConsumer(UniqueSemantic.FILTER);
    private static final ListResultsConsumer<?> ERROR_DUP_CONSUMER = new ListResultsConsumer(UniqueSemantic.ASSERT);
    private final UniqueSemantic uniqueSemantic;
    private final ResultHandler<R> resultHandler;

    public static <R> ListResultsConsumer<R> instance(UniqueSemantic uniqueSemantic) {
        switch (uniqueSemantic) {
            case ASSERT: {
                return ERROR_DUP_CONSUMER;
            }
            case FILTER: {
                return DE_DUP_CONSUMER;
            }
            case NEVER: {
                return NEVER_DE_DUP_CONSUMER;
            }
            case ALLOW: {
                return ALLOW_DE_DUP_CONSUMER;
            }
        }
        return IGNORE_DUP_CONSUMER;
    }

    public ListResultsConsumer(UniqueSemantic uniqueSemantic) {
        this.uniqueSemantic = uniqueSemantic;
        this.resultHandler = uniqueSemantic == UniqueSemantic.FILTER ? ListResultsConsumer::deDuplicationHandling : (uniqueSemantic == UniqueSemantic.ASSERT ? ListResultsConsumer::duplicationErrorHandling : ListResultsConsumer::applyAll);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<R> consume(JdbcValues jdbcValues, SharedSessionContractImplementor session, JdbcValuesSourceProcessingOptions processingOptions, JdbcValuesSourceProcessingStateStandardImpl jdbcValuesSourceProcessingState, RowProcessingStateStandardImpl rowProcessingState, RowReader<R> rowReader) {
        PersistenceContext persistenceContext = session.getPersistenceContext();
        TypeConfiguration typeConfiguration = session.getTypeConfiguration();
        QueryOptions queryOptions = rowProcessingState.getQueryOptions();
        RuntimeException ex = null;
        try {
            persistenceContext.getLoadContexts().register(jdbcValuesSourceProcessingState);
            ArrayList results = new ArrayList();
            JavaType<R> domainResultJavaType = this.resolveDomainResultJavaType(rowReader.getDomainResultResultJavaType(), rowReader.getResultJavaTypes(), typeConfiguration);
            ResultHandler<Object> resultHandlerToUse = this.uniqueSemantic == UniqueSemantic.ALLOW && domainResultJavaType instanceof EntityJavaType ? ListResultsConsumer::deDuplicationHandling : this.resultHandler;
            while (rowProcessingState.next()) {
                R row = rowReader.readRow(rowProcessingState, processingOptions);
                resultHandlerToUse.handle(row, domainResultJavaType, results, rowProcessingState);
                rowProcessingState.finishRowProcessing();
            }
            try {
                jdbcValuesSourceProcessingState.finishUp();
            }
            finally {
                persistenceContext.getLoadContexts().deregister(jdbcValuesSourceProcessingState);
            }
            ResultListTransformer<?> resultListTransformer = queryOptions.getResultListTransformer();
            if (resultListTransformer != null) {
                List<?> list = resultListTransformer.transformList(results);
                return list;
            }
            ArrayList arrayList = results;
            return arrayList;
        }
        catch (RuntimeException e) {
            ex = e;
            return ex;
        }
        finally {
            try {
                rowReader.finishUp(jdbcValuesSourceProcessingState);
                jdbcValues.finishUp(session);
                persistenceContext.initializeNonLazyCollections();
            }
            catch (RuntimeException e) {
                if (ex != null) {
                    ex.addSuppressed(e);
                }
                ex = e;
                return ex;
            }
            finally {
                if (ex == null) throw new IllegalStateException("Should not reach this");
                throw ex;
            }
        }
    }

    public static <R> void deDuplicationHandling(R result, JavaType<R> transformedJavaType, List<R> results, RowProcessingStateStandardImpl rowProcessingState) {
        ListResultsConsumer.withDuplicationCheck(result, transformedJavaType, results, rowProcessingState, false);
    }

    private static <R> void withDuplicationCheck(R result, JavaType<R> transformedJavaType, List<R> results, RowProcessingStateStandardImpl rowProcessingState, boolean throwException) {
        boolean addResult = true;
        for (int i = 0; i < results.size(); ++i) {
            R existingResult = results.get(i);
            if (!transformedJavaType.areEqual(result, existingResult)) continue;
            if (throwException && !rowProcessingState.hasCollectionInitializers) {
                throw new HibernateException(String.format(Locale.ROOT, "Duplicate row was found and `%s` was specified", new Object[]{UniqueSemantic.ASSERT}));
            }
            addResult = false;
            break;
        }
        if (addResult) {
            results.add(result);
        }
    }

    public static <R> void duplicationErrorHandling(R result, JavaType<R> transformedJavaType, List<R> results, RowProcessingStateStandardImpl rowProcessingState) {
        ListResultsConsumer.withDuplicationCheck(result, transformedJavaType, results, rowProcessingState, true);
    }

    public static <R> void applyAll(R result, JavaType<R> transformedJavaType, List<R> results, RowProcessingStateStandardImpl rowProcessingState) {
        results.add(result);
    }

    private JavaType<R> resolveDomainResultJavaType(Class<R> domainResultResultJavaType, List<JavaType<?>> resultJavaTypes, TypeConfiguration typeConfiguration) {
        JavaTypeRegistry javaTypeRegistry = typeConfiguration.getJavaTypeRegistry();
        if (domainResultResultJavaType != null) {
            return javaTypeRegistry.resolveDescriptor(domainResultResultJavaType);
        }
        if (resultJavaTypes.size() == 1) {
            return resultJavaTypes.get(0);
        }
        return javaTypeRegistry.resolveDescriptor((Type)((Object)Object[].class));
    }

    @Override
    public boolean canResultsBeCached() {
        return true;
    }

    public String toString() {
        return "ListResultsConsumer(" + this.uniqueSemantic + ")";
    }

    @FunctionalInterface
    private static interface ResultHandler<R> {
        public void handle(R var1, JavaType<R> var2, List<R> var3, RowProcessingStateStandardImpl var4);
    }

    public static enum UniqueSemantic {
        NONE,
        FILTER,
        ASSERT,
        NEVER,
        ALLOW;

    }
}

