/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc.spi;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.type.descriptor.JdbcTypeNameMapper;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeFamilyInformation;
import org.hibernate.type.descriptor.jdbc.ObjectJdbcType;
import org.hibernate.type.descriptor.jdbc.internal.JdbcTypeBaseline;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

public class JdbcTypeRegistry
implements JdbcTypeBaseline.BaselineTarget,
Serializable {
    private static final Logger log = Logger.getLogger(JdbcTypeRegistry.class);
    private final TypeConfiguration typeConfiguration;
    private final ConcurrentHashMap<Integer, JdbcType> descriptorMap = new ConcurrentHashMap();

    public JdbcTypeRegistry(TypeConfiguration typeConfiguration) {
        this.typeConfiguration = typeConfiguration;
        JdbcTypeBaseline.prime(this);
    }

    public TypeConfiguration getTypeConfiguration() {
        return this.typeConfiguration;
    }

    @Override
    public void addDescriptor(JdbcType jdbcType) {
        JdbcType previous = this.descriptorMap.put(jdbcType.getDefaultSqlTypeCode(), jdbcType);
        if (previous != null && previous != jdbcType) {
            log.debugf("addDescriptor(%s) replaced previous registration(%s)", (Object)jdbcType, (Object)previous);
        }
    }

    @Override
    public void addDescriptor(int typeCode, JdbcType jdbcType) {
        JdbcType previous = this.descriptorMap.put(typeCode, jdbcType);
        if (previous != null && previous != jdbcType) {
            log.debugf("addDescriptor(%d, %s) replaced previous registration(%s)", typeCode, (Object)jdbcType, (Object)previous);
        }
    }

    public void addDescriptorIfAbsent(JdbcType jdbcType) {
        this.descriptorMap.putIfAbsent(jdbcType.getDefaultSqlTypeCode(), jdbcType);
    }

    public void addDescriptorIfAbsent(int typeCode, JdbcType jdbcType) {
        this.descriptorMap.putIfAbsent(typeCode, jdbcType);
    }

    public JdbcType findDescriptor(int jdbcTypeCode) {
        return this.descriptorMap.get(jdbcTypeCode);
    }

    public JdbcType getDescriptor(int jdbcTypeCode) {
        JdbcTypeFamilyInformation.Family family;
        JdbcType descriptor = this.descriptorMap.get(jdbcTypeCode);
        if (descriptor != null) {
            return descriptor;
        }
        if (JdbcTypeNameMapper.isStandardTypeCode(jdbcTypeCode)) {
            log.debugf("A standard JDBC type code [%s] was not defined in SqlTypeDescriptorRegistry", jdbcTypeCode);
        }
        if ((family = JdbcTypeFamilyInformation.INSTANCE.locateJdbcTypeFamilyByTypeCode(jdbcTypeCode)) != null) {
            for (int potentialAlternateTypeCode : family.getTypeCodes()) {
                if (potentialAlternateTypeCode == jdbcTypeCode) continue;
                JdbcType potentialAlternateDescriptor = this.descriptorMap.get(potentialAlternateTypeCode);
                if (potentialAlternateDescriptor != null) {
                    return potentialAlternateDescriptor;
                }
                if (!JdbcTypeNameMapper.isStandardTypeCode(potentialAlternateTypeCode)) continue;
                log.debugf("A standard JDBC type code [%s] was not defined in SqlTypeDescriptorRegistry", potentialAlternateTypeCode);
            }
        }
        ObjectJdbcType fallBackDescriptor = new ObjectJdbcType(jdbcTypeCode);
        this.addDescriptor(fallBackDescriptor);
        return fallBackDescriptor;
    }

    public boolean hasRegisteredDescriptor(int jdbcTypeCode) {
        return this.descriptorMap.containsKey(jdbcTypeCode) || JdbcTypeNameMapper.isStandardTypeCode(jdbcTypeCode) || JdbcTypeFamilyInformation.INSTANCE.locateJdbcTypeFamilyByTypeCode(jdbcTypeCode) != null;
    }
}

