/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.massindexing.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.hibernate.search.engine.backend.session.spi.DetachedBackendSessionContext;
import org.hibernate.search.engine.reporting.spi.FailureCollector;
import org.hibernate.search.engine.reporting.spi.RootFailureCollector;
import org.hibernate.search.mapper.pojo.massindexing.impl.MassIndexingOperationHandledFailureException;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexerAgentCreateContextImpl;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingBatchIndexingWorkspace;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingFailureHandledRunnable;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingIndexedTypeGroup;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingNotifier;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexerAgent;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexingMappingContext;
import org.hibernate.search.mapper.pojo.reporting.impl.PojoEventContextMessages;
import org.hibernate.search.mapper.pojo.schema.management.spi.PojoScopeSchemaManager;
import org.hibernate.search.mapper.pojo.work.spi.PojoScopeWorkspace;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.Futures;

public class PojoMassIndexingBatchCoordinator
extends PojoMassIndexingFailureHandledRunnable {
    private final PojoMassIndexingMappingContext mappingContext;
    private final List<PojoMassIndexingIndexedTypeGroup<?>> typeGroupsToIndex;
    private final PojoScopeSchemaManager scopeSchemaManager;
    private final DetachedBackendSessionContext detachedSession;
    private final PojoScopeWorkspace scopeWorkspace;
    private final int typesToIndexInParallel;
    private final int documentBuilderThreads;
    private final boolean mergeSegmentsOnFinish;
    private final boolean dropAndCreateSchemaOnStart;
    private final boolean purgeAtStart;
    private final boolean mergeSegmentsAfterPurge;
    private final List<CompletableFuture<?>> indexingFutures = new ArrayList();
    private PojoMassIndexerAgent agent;

    public PojoMassIndexingBatchCoordinator(PojoMassIndexingMappingContext mappingContext, PojoMassIndexingNotifier notifier, List<PojoMassIndexingIndexedTypeGroup<?>> typeGroupsToIndex, PojoScopeSchemaManager scopeSchemaManager, DetachedBackendSessionContext detachedSession, PojoScopeWorkspace scopeWorkspace, int typesToIndexInParallel, int documentBuilderThreads, boolean mergeSegmentsOnFinish, boolean dropAndCreateSchemaOnStart, boolean purgeAtStart, boolean mergeSegmentsAfterPurge) {
        super(notifier);
        this.mappingContext = mappingContext;
        this.typeGroupsToIndex = typeGroupsToIndex;
        this.scopeSchemaManager = scopeSchemaManager;
        this.detachedSession = detachedSession;
        this.scopeWorkspace = scopeWorkspace;
        this.typesToIndexInParallel = typesToIndexInParallel;
        this.documentBuilderThreads = documentBuilderThreads;
        this.mergeSegmentsOnFinish = mergeSegmentsOnFinish;
        this.dropAndCreateSchemaOnStart = dropAndCreateSchemaOnStart;
        this.purgeAtStart = purgeAtStart;
        this.mergeSegmentsAfterPurge = mergeSegmentsAfterPurge;
    }

    @Override
    public void runWithFailureHandler() throws InterruptedException {
        if (!this.indexingFutures.isEmpty()) {
            throw new AssertionFailure("BatchCoordinator instance not expected to be reused");
        }
        this.beforeBatch();
        try {
            this.doBatchWork();
            this.afterBatch();
        }
        catch (MassIndexingOperationHandledFailureException e) {
            this.cleanUpOnFailure();
        }
    }

    private void beforeBatch() throws InterruptedException {
        this.agent = this.mappingContext.createMassIndexerAgent(new PojoMassIndexerAgentCreateContextImpl(this.mappingContext, this.detachedSession.tenantIdentifier()));
        Futures.unwrappedExceptionGet(this.agent.start());
        if (this.dropAndCreateSchemaOnStart) {
            RootFailureCollector failureCollector = new RootFailureCollector(PojoEventContextMessages.INSTANCE.schemaManagement());
            Futures.unwrappedExceptionGet(this.scopeSchemaManager.dropAndCreate((FailureCollector)failureCollector));
            failureCollector.checkNoFailure();
        }
        if (this.purgeAtStart) {
            Futures.unwrappedExceptionGet(this.scopeWorkspace.purge(Collections.emptySet()));
            if (this.mergeSegmentsAfterPurge) {
                Futures.unwrappedExceptionGet(this.scopeWorkspace.mergeSegments());
            }
        }
    }

    private void doBatchWork() throws InterruptedException {
        ThreadPoolExecutor executor = this.mappingContext.threadPoolProvider().newFixedThreadPool(this.typesToIndexInParallel, "Mass indexing - Workspace");
        for (PojoMassIndexingIndexedTypeGroup<?> typeGroup : this.typeGroupsToIndex) {
            this.indexingFutures.add(Futures.runAsync(this.createBatchIndexingWorkspace(typeGroup), (ExecutorService)executor));
        }
        executor.shutdown();
        Futures.unwrappedExceptionGet(CompletableFuture.allOf(this.indexingFutures.toArray(new CompletableFuture[0])));
    }

    private <E> PojoMassIndexingBatchIndexingWorkspace<E, ?> createBatchIndexingWorkspace(PojoMassIndexingIndexedTypeGroup<E> typeGroup) {
        return new PojoMassIndexingBatchIndexingWorkspace(this.mappingContext, this.getNotifier(), typeGroup, typeGroup.loadingStrategy(), this.documentBuilderThreads);
    }

    private void afterBatch() throws InterruptedException {
        if (this.mergeSegmentsOnFinish) {
            Futures.unwrappedExceptionGet(this.scopeWorkspace.mergeSegments());
        }
        this.flushAndRefresh();
        Futures.unwrappedExceptionGet(this.agent.preStop());
        this.agent.stop();
        this.agent = null;
    }

    private void flushAndRefresh() throws InterruptedException {
        Futures.unwrappedExceptionGet(this.scopeWorkspace.flush());
        Futures.unwrappedExceptionGet(this.scopeWorkspace.refresh());
    }

    @Override
    protected void cleanUpOnInterruption() throws InterruptedException {
        try (Closer closer = new Closer();){
            closer.pushAll(this::cancelPendingTask, this.indexingFutures);
            closer.push(PojoMassIndexingBatchCoordinator::flushAndRefresh, (Object)this);
            closer.push(PojoMassIndexerAgent::stop, (Object)this.agent);
            this.agent = null;
        }
    }

    @Override
    protected void cleanUpOnFailure() {
        try (Closer closer = new Closer();){
            closer.pushAll(this::cancelPendingTask, this.indexingFutures);
            closer.push(PojoMassIndexerAgent::stop, (Object)this.agent);
            this.agent = null;
        }
    }

    private void cancelPendingTask(Future<?> task) {
        if (!task.isDone()) {
            task.cancel(true);
        }
    }

    @Override
    protected void notifySuccess() {
        this.getNotifier().reportIndexingCompleted();
    }

    @Override
    protected void notifyInterrupted(InterruptedException exception) {
        this.getNotifier().reportInterrupted(exception);
        this.getNotifier().reportIndexingCompleted();
    }

    @Override
    protected void notifyFailure(RuntimeException exception) {
        super.notifyFailure(exception);
        this.getNotifier().reportIndexingCompleted();
    }
}

