/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.RecordComponentInfo;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeTarget;
import org.jboss.jandex.Utils;

public abstract class EquivalenceKey {
    public static EquivalenceKey of(AnnotationTarget annotationTarget) {
        if (annotationTarget == null) {
            return null;
        }
        switch (annotationTarget.kind()) {
            case CLASS: {
                return EquivalenceKey.of(annotationTarget.asClass());
            }
            case METHOD: {
                return EquivalenceKey.of(annotationTarget.asMethod());
            }
            case METHOD_PARAMETER: {
                return EquivalenceKey.of(annotationTarget.asMethodParameter());
            }
            case FIELD: {
                return EquivalenceKey.of(annotationTarget.asField());
            }
            case RECORD_COMPONENT: {
                return EquivalenceKey.of(annotationTarget.asRecordComponent());
            }
            case TYPE: {
                return EquivalenceKey.of(annotationTarget.asType());
            }
        }
        throw new IllegalArgumentException("Unknown annotation target: " + annotationTarget);
    }

    public static ClassEquivalenceKey of(ClassInfo clazz) {
        if (clazz == null) {
            return null;
        }
        return new ClassEquivalenceKey(clazz.name());
    }

    public static MethodEquivalenceKey of(MethodInfo method) {
        if (method == null) {
            return null;
        }
        return new MethodEquivalenceKey(method.declaringClass().name(), method.methodInternal().nameBytes(), EquivalenceKey.of(method.methodInternal().parameterTypesArray()), EquivalenceKey.of(method.returnType()));
    }

    public static MethodParameterEquivalenceKey of(MethodParameterInfo parameter) {
        if (parameter == null) {
            return null;
        }
        return new MethodParameterEquivalenceKey(EquivalenceKey.of(parameter.method()), parameter.position());
    }

    public static FieldEquivalenceKey of(FieldInfo field) {
        if (field == null) {
            return null;
        }
        return new FieldEquivalenceKey(field.declaringClass().name(), field.fieldInternal().nameBytes(), EquivalenceKey.of(field.type()));
    }

    public static RecordComponentEquivalenceKey of(RecordComponentInfo recordComponent) {
        if (recordComponent == null) {
            return null;
        }
        return new RecordComponentEquivalenceKey(recordComponent.declaringClass().name(), recordComponent.recordComponentInternal().nameBytes(), EquivalenceKey.of(recordComponent.type()));
    }

    public static TypeEquivalenceKey of(TypeTarget typeTarget) {
        if (typeTarget == null) {
            return null;
        }
        return EquivalenceKey.of(typeTarget.target());
    }

    public static TypeEquivalenceKey of(Type type) {
        if (type == null) {
            return null;
        }
        switch (type.kind()) {
            case ARRAY: {
                return new ArrayTypeEquivalenceKey(EquivalenceKey.of(type.asArrayType().component()), type.asArrayType().dimensions());
            }
            case CLASS: {
                return new ClassTypeEquivalenceKey(type.asClassType().name());
            }
            case PARAMETERIZED_TYPE: {
                return new ParameterizedTypeEquivalenceKey(type.asParameterizedType().name(), EquivalenceKey.of(type.asParameterizedType().argumentsArray()));
            }
            case PRIMITIVE: {
                return new PrimitiveTypeEquivalenceKey(type.asPrimitiveType().primitive());
            }
            case TYPE_VARIABLE: {
                return new TypeVariableEquivalenceKey(type.asTypeVariable().identifier(), EquivalenceKey.of(type.asTypeVariable().boundArray()));
            }
            case TYPE_VARIABLE_REFERENCE: {
                return new TypeVariableReferenceEquivalenceKey(type.asTypeVariableReference().identifier());
            }
            case UNRESOLVED_TYPE_VARIABLE: {
                return new UnresolvedTypeVariableEquivalenceKey(type.asUnresolvedTypeVariable().identifier());
            }
            case VOID: {
                return VoidTypeEquivalenceKey.SINGLETON;
            }
            case WILDCARD_TYPE: {
                return new WildcardTypeEquivalenceKey(EquivalenceKey.of(type.asWildcardType().bound()), type.asWildcardType().isExtends(), type.asWildcardType().hasImplicitObjectBound());
            }
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }

    private static TypeEquivalenceKey[] of(Type[] types) {
        TypeEquivalenceKey[] result = new TypeEquivalenceKey[types.length];
        for (int i = 0; i < types.length; ++i) {
            result[i] = EquivalenceKey.of(types[i]);
        }
        return result;
    }

    private EquivalenceKey() {
    }

    String toStringWithWhere(Set<TypeVariableEquivalenceKey> typeVariables) {
        return this.toString();
    }

    private static String toStringWhereClause(Set<TypeVariableEquivalenceKey> typeVariables) {
        if (typeVariables == null || typeVariables.isEmpty()) {
            return "";
        }
        StringJoiner typeVariablesJoiner = new StringJoiner(", ");
        for (TypeVariableEquivalenceKey typeVariable : typeVariables) {
            typeVariablesJoiner.add(typeVariable.toString());
        }
        return " where " + typeVariablesJoiner;
    }

    public static final class WildcardTypeEquivalenceKey
    extends TypeEquivalenceKey {
        private final TypeEquivalenceKey bound;
        private final boolean isExtends;
        private final boolean hasImplicitObjectBound;

        private WildcardTypeEquivalenceKey(TypeEquivalenceKey bound, boolean isExtends, boolean hasImplicitObjectBound) {
            this.bound = bound;
            this.isExtends = isExtends;
            this.hasImplicitObjectBound = hasImplicitObjectBound;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof WildcardTypeEquivalenceKey)) {
                return false;
            }
            WildcardTypeEquivalenceKey that = (WildcardTypeEquivalenceKey)o;
            return this.isExtends == that.isExtends && this.hasImplicitObjectBound == that.hasImplicitObjectBound && Objects.equals(this.bound, that.bound);
        }

        public int hashCode() {
            return Objects.hash(this.bound, this.isExtends, this.hasImplicitObjectBound);
        }

        public String toString() {
            if (this.bound == null || this.hasImplicitObjectBound) {
                return "?";
            }
            if (this.isExtends) {
                return "? extends " + this.bound;
            }
            return "? super " + this.bound;
        }
    }

    public static final class VoidTypeEquivalenceKey
    extends TypeEquivalenceKey {
        private static final VoidTypeEquivalenceKey SINGLETON = new VoidTypeEquivalenceKey();

        private VoidTypeEquivalenceKey() {
        }

        public String toString() {
            return "void";
        }
    }

    public static final class UnresolvedTypeVariableEquivalenceKey
    extends TypeEquivalenceKey {
        private final String name;

        private UnresolvedTypeVariableEquivalenceKey(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UnresolvedTypeVariableEquivalenceKey)) {
                return false;
            }
            UnresolvedTypeVariableEquivalenceKey that = (UnresolvedTypeVariableEquivalenceKey)o;
            return Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        public String toString() {
            return this.name;
        }
    }

    public static final class TypeVariableReferenceEquivalenceKey
    extends TypeEquivalenceKey {
        private final String name;

        private TypeVariableReferenceEquivalenceKey(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TypeVariableReferenceEquivalenceKey)) {
                return false;
            }
            TypeVariableReferenceEquivalenceKey that = (TypeVariableReferenceEquivalenceKey)o;
            return Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        public String toString() {
            return this.name;
        }
    }

    public static final class TypeVariableEquivalenceKey
    extends TypeEquivalenceKey {
        private final String name;
        private final TypeEquivalenceKey[] bounds;

        private TypeVariableEquivalenceKey(String name, TypeEquivalenceKey[] bounds) {
            this.name = name;
            this.bounds = bounds;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TypeVariableEquivalenceKey)) {
                return false;
            }
            TypeVariableEquivalenceKey that = (TypeVariableEquivalenceKey)o;
            return Objects.equals(this.name, that.name) && Arrays.equals(this.bounds, that.bounds);
        }

        public int hashCode() {
            int result = Objects.hash(this.name);
            result = 31 * result + Arrays.hashCode(this.bounds);
            return result;
        }

        public String toString() {
            if (this.bounds.length == 0) {
                return this.name;
            }
            StringJoiner boundsJoiner = new StringJoiner(" & ");
            for (TypeEquivalenceKey bound : this.bounds) {
                boundsJoiner.add(bound.toString());
            }
            return this.name + " extends " + boundsJoiner;
        }

        @Override
        String toStringWithWhere(Set<TypeVariableEquivalenceKey> typeVariables) {
            typeVariables.add(this);
            return this.name;
        }
    }

    public static final class PrimitiveTypeEquivalenceKey
    extends TypeEquivalenceKey {
        private final PrimitiveType.Primitive kind;

        private PrimitiveTypeEquivalenceKey(PrimitiveType.Primitive kind) {
            this.kind = kind;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PrimitiveTypeEquivalenceKey)) {
                return false;
            }
            PrimitiveTypeEquivalenceKey that = (PrimitiveTypeEquivalenceKey)o;
            return this.kind == that.kind;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.kind});
        }

        public String toString() {
            return this.kind.name().toLowerCase(Locale.ROOT);
        }
    }

    public static final class ParameterizedTypeEquivalenceKey
    extends TypeEquivalenceKey {
        private final DotName genericClass;
        private final TypeEquivalenceKey[] typeArguments;

        private ParameterizedTypeEquivalenceKey(DotName genericClass, TypeEquivalenceKey[] typeArguments) {
            this.genericClass = genericClass;
            this.typeArguments = typeArguments;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ParameterizedTypeEquivalenceKey)) {
                return false;
            }
            ParameterizedTypeEquivalenceKey that = (ParameterizedTypeEquivalenceKey)o;
            return Objects.equals(this.genericClass, that.genericClass) && Arrays.equals(this.typeArguments, that.typeArguments);
        }

        public int hashCode() {
            int result = Objects.hash(this.genericClass);
            result = 31 * result + Arrays.hashCode(this.typeArguments);
            return result;
        }

        public String toString() {
            HashSet<TypeVariableEquivalenceKey> typeVariables = new HashSet<TypeVariableEquivalenceKey>();
            StringJoiner typeArgumentsJoiner = new StringJoiner(", ", "<", ">");
            for (TypeEquivalenceKey typeArgument : this.typeArguments) {
                typeArgumentsJoiner.add(typeArgument.toStringWithWhere(typeVariables));
            }
            return this.genericClass + typeArgumentsJoiner.toString() + EquivalenceKey.toStringWhereClause(typeVariables);
        }

        @Override
        String toStringWithWhere(Set<TypeVariableEquivalenceKey> typeVariables) {
            StringJoiner typeArgumentsJoiner = new StringJoiner(", ", "<", ">");
            for (TypeEquivalenceKey typeArgument : this.typeArguments) {
                typeArgumentsJoiner.add(typeArgument.toStringWithWhere(typeVariables));
            }
            return this.genericClass + typeArgumentsJoiner.toString();
        }
    }

    public static final class ClassTypeEquivalenceKey
    extends TypeEquivalenceKey {
        private final DotName name;

        private ClassTypeEquivalenceKey(DotName name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClassTypeEquivalenceKey)) {
                return false;
            }
            ClassTypeEquivalenceKey that = (ClassTypeEquivalenceKey)o;
            return Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        public String toString() {
            return this.name.toString();
        }
    }

    public static final class ArrayTypeEquivalenceKey
    extends TypeEquivalenceKey {
        private final TypeEquivalenceKey component;
        private final int dimensions;

        private ArrayTypeEquivalenceKey(TypeEquivalenceKey component, int dimensions) {
            this.component = component;
            this.dimensions = dimensions;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ArrayTypeEquivalenceKey)) {
                return false;
            }
            ArrayTypeEquivalenceKey that = (ArrayTypeEquivalenceKey)o;
            return this.dimensions == that.dimensions && Objects.equals(this.component, that.component);
        }

        public int hashCode() {
            return Objects.hash(this.component, this.dimensions);
        }

        public String toString() {
            HashSet<TypeVariableEquivalenceKey> typeVariables = new HashSet<TypeVariableEquivalenceKey>();
            StringBuilder result = new StringBuilder();
            result.append(this.component.toStringWithWhere(typeVariables));
            for (int i = 0; i < this.dimensions; ++i) {
                result.append("[]");
            }
            return result + EquivalenceKey.toStringWhereClause(typeVariables);
        }

        @Override
        String toStringWithWhere(Set<TypeVariableEquivalenceKey> typeVariables) {
            StringBuilder result = new StringBuilder();
            result.append(this.component.toStringWithWhere(typeVariables));
            for (int i = 0; i < this.dimensions; ++i) {
                result.append("[]");
            }
            return result.toString();
        }
    }

    public static abstract class TypeEquivalenceKey
    extends EquivalenceKey {
        private TypeEquivalenceKey() {
        }
    }

    public static final class RecordComponentEquivalenceKey
    extends DeclarationEquivalenceKey {
        private final DotName className;
        private final byte[] recordComponentName;
        private final TypeEquivalenceKey type;

        private RecordComponentEquivalenceKey(DotName className, byte[] recordComponentName, TypeEquivalenceKey type) {
            this.className = className;
            this.recordComponentName = recordComponentName;
            this.type = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RecordComponentEquivalenceKey)) {
                return false;
            }
            RecordComponentEquivalenceKey that = (RecordComponentEquivalenceKey)o;
            return Objects.equals(this.className, that.className) && Arrays.equals(this.recordComponentName, that.recordComponentName) && Objects.equals(this.type, that.type);
        }

        public int hashCode() {
            int result = Objects.hash(this.className, this.type);
            result = 31 * result + Arrays.hashCode(this.recordComponentName);
            return result;
        }

        public String toString() {
            HashSet<TypeVariableEquivalenceKey> typeVariables = new HashSet<TypeVariableEquivalenceKey>();
            return "record component " + this.className + "#" + Utils.fromUTF8(this.recordComponentName) + " of type " + this.type.toStringWithWhere(typeVariables) + EquivalenceKey.toStringWhereClause(typeVariables);
        }
    }

    public static final class FieldEquivalenceKey
    extends DeclarationEquivalenceKey {
        private final DotName className;
        private final byte[] fieldName;
        private final TypeEquivalenceKey type;

        private FieldEquivalenceKey(DotName className, byte[] fieldName, TypeEquivalenceKey type) {
            this.className = className;
            this.fieldName = fieldName;
            this.type = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FieldEquivalenceKey)) {
                return false;
            }
            FieldEquivalenceKey that = (FieldEquivalenceKey)o;
            return Objects.equals(this.className, that.className) && Arrays.equals(this.fieldName, that.fieldName) && Objects.equals(this.type, that.type);
        }

        public int hashCode() {
            int result = Objects.hash(this.className, this.type);
            result = 31 * result + Arrays.hashCode(this.fieldName);
            return result;
        }

        public String toString() {
            HashSet<TypeVariableEquivalenceKey> typeVariables = new HashSet<TypeVariableEquivalenceKey>();
            return "field " + this.className + "#" + Utils.fromUTF8(this.fieldName) + " of type " + this.type.toStringWithWhere(typeVariables) + EquivalenceKey.toStringWhereClause(typeVariables);
        }
    }

    public static final class MethodParameterEquivalenceKey
    extends DeclarationEquivalenceKey {
        private final MethodEquivalenceKey method;
        private final short position;

        private MethodParameterEquivalenceKey(MethodEquivalenceKey method, short position) {
            this.method = method;
            this.position = position;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MethodParameterEquivalenceKey)) {
                return false;
            }
            MethodParameterEquivalenceKey that = (MethodParameterEquivalenceKey)o;
            return this.position == that.position && Objects.equals(this.method, that.method);
        }

        public int hashCode() {
            return Objects.hash(this.method, this.position);
        }

        public String toString() {
            return "parameter " + this.position + " of " + this.method;
        }
    }

    public static final class MethodEquivalenceKey
    extends DeclarationEquivalenceKey {
        private final DotName className;
        private final byte[] methodName;
        private final TypeEquivalenceKey[] parameterTypes;
        private final TypeEquivalenceKey returnType;

        private MethodEquivalenceKey(DotName className, byte[] methodName, TypeEquivalenceKey[] parameterTypes, TypeEquivalenceKey returnType) {
            this.className = className;
            this.methodName = methodName;
            this.parameterTypes = parameterTypes;
            this.returnType = returnType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MethodEquivalenceKey)) {
                return false;
            }
            MethodEquivalenceKey that = (MethodEquivalenceKey)o;
            return Objects.equals(this.className, that.className) && Arrays.equals(this.methodName, that.methodName) && Arrays.equals(this.parameterTypes, that.parameterTypes) && Objects.equals(this.returnType, that.returnType);
        }

        public int hashCode() {
            int result = Objects.hash(this.className, this.returnType);
            result = 31 * result + Arrays.hashCode(this.methodName);
            result = 31 * result + Arrays.hashCode(this.parameterTypes);
            return result;
        }

        public String toString() {
            HashSet<TypeVariableEquivalenceKey> typeVariables = new HashSet<TypeVariableEquivalenceKey>();
            StringJoiner parameterTypesJoiner = new StringJoiner(", ", "(", ")");
            for (TypeEquivalenceKey parameterType : this.parameterTypes) {
                parameterTypesJoiner.add(parameterType.toStringWithWhere(typeVariables));
            }
            return "method " + this.className + "#" + Utils.fromUTF8(this.methodName) + parameterTypesJoiner + " -> " + this.returnType.toStringWithWhere(typeVariables) + EquivalenceKey.toStringWhereClause(typeVariables);
        }
    }

    public static final class ClassEquivalenceKey
    extends DeclarationEquivalenceKey {
        private final DotName className;

        private ClassEquivalenceKey(DotName className) {
            this.className = className;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClassEquivalenceKey)) {
                return false;
            }
            ClassEquivalenceKey that = (ClassEquivalenceKey)o;
            return Objects.equals(this.className, that.className);
        }

        public int hashCode() {
            return Objects.hash(this.className);
        }

        public String toString() {
            return "class " + this.className.toString();
        }
    }

    public static abstract class DeclarationEquivalenceKey
    extends EquivalenceKey {
        private DeclarationEquivalenceKey() {
        }
    }
}

