/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.concurrent.TimeUnit;
import java.util.function.UnaryOperator;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.jboss.as.clustering.controller.ChildResourceDefinition;
import org.jboss.as.clustering.controller.FunctionExecutorRegistry;
import org.jboss.as.clustering.controller.ManagementResourceRegistration;
import org.jboss.as.clustering.controller.OperationExecutor;
import org.jboss.as.clustering.controller.OperationHandler;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceConfiguratorFactory;
import org.jboss.as.clustering.controller.RestartParentResourceRegistration;
import org.jboss.as.clustering.controller.validation.EnumValidator;
import org.jboss.as.clustering.infinispan.subsystem.BackupOperation;
import org.jboss.as.clustering.infinispan.subsystem.BackupOperationExecutor;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanExtension;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanModel;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class BackupResourceDefinition
extends ChildResourceDefinition<ManagementResourceRegistration> {
    static final PathElement WILDCARD_PATH = BackupResourceDefinition.pathElement("*");
    private final ResourceServiceConfiguratorFactory parentServiceConfiguratorFactory;
    private final FunctionExecutorRegistry<Cache<?, ?>> executors;

    static PathElement pathElement(String name) {
        return PathElement.pathElement((String)"backup", (String)name);
    }

    BackupResourceDefinition(ResourceServiceConfiguratorFactory parentServiceConfiguratorFactory, FunctionExecutorRegistry<Cache<?, ?>> executors) {
        super(WILDCARD_PATH, InfinispanExtension.SUBSYSTEM_RESOLVER.createChildResolver(new PathElement[]{WILDCARD_PATH}));
        this.parentServiceConfiguratorFactory = parentServiceConfiguratorFactory;
        this.executors = executors;
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parent) {
        ManagementResourceRegistration registration = parent.registerSubModel((ResourceDefinition)this);
        ResourceDescriptor descriptor = new ResourceDescriptor(this.getResourceDescriptionResolver()).addAttributes(Attribute.class).addAttributes(TakeOfflineAttribute.class).addAttributes(DeprecatedAttribute.class);
        new RestartParentResourceRegistration(this.parentServiceConfiguratorFactory, descriptor).register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        if (registration.isRuntimeOnlyRegistrationValid()) {
            new OperationHandler((OperationExecutor)new BackupOperationExecutor(this.executors), BackupOperation.class).register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        }
        return registration;
    }

    static enum DeprecatedAttribute implements org.jboss.as.clustering.controller.Attribute
    {
        ENABLED("enabled", ModelType.BOOLEAN, ModelNode.TRUE, InfinispanModel.VERSION_16_0_0);

        private final AttributeDefinition definition;

        private DeprecatedAttribute(String name, ModelType type, ModelNode defaultValue, InfinispanModel deprecation) {
            this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setRequired(false)).setDefaultValue(defaultValue)).setDeprecated(deprecation.getVersion())).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }

    static enum TakeOfflineAttribute implements org.jboss.as.clustering.controller.Attribute
    {
        AFTER_FAILURES("after-failures", ModelType.INT, new ModelNode(1)),
        MIN_WAIT("min-wait", ModelType.LONG, ModelNode.ZERO_LONG);

        private final AttributeDefinition definition;

        private TakeOfflineAttribute(String name, ModelType type, ModelNode defaultValue) {
            this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setRequired(false)).setDefaultValue(defaultValue)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setMeasurementUnit((MeasurementUnit)(type == ModelType.LONG ? MeasurementUnit.MILLISECONDS : null))).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }

    static enum Attribute implements org.jboss.as.clustering.controller.Attribute,
    UnaryOperator<SimpleAttributeDefinitionBuilder>
    {
        FAILURE_POLICY("failure-policy", ModelType.STRING, new ModelNode(BackupFailurePolicy.WARN.name())){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.setValidator((ParameterValidator)new EnumValidator(BackupFailurePolicy.class));
            }
        }
        ,
        STRATEGY("strategy", ModelType.STRING, new ModelNode(BackupConfiguration.BackupStrategy.ASYNC.name())){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.setValidator((ParameterValidator)new EnumValidator(BackupConfiguration.BackupStrategy.class));
            }
        }
        ,
        TIMEOUT("timeout", ModelType.LONG, new ModelNode(TimeUnit.SECONDS.toMillis(10L))){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.setMeasurementUnit(MeasurementUnit.MILLISECONDS);
            }
        };

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type, ModelNode defaultValue) {
            this.definition = this.apply((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setRequired(false)).setDefaultValue(defaultValue)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }

        @Override
        public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
            return builder;
        }
    }
}

