/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.metrics.impl;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.lang.NonNullApi;
import io.micrometer.core.lang.NonNullFields;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.util.List;

@NonNullApi
@NonNullFields
class VendorAdditionalMetrics
implements MeterBinder {
    VendorAdditionalMetrics() {
    }

    public void bindTo(MeterRegistry registry) {
        List<BufferPoolMXBean> bufferPoolBeans = ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class);
        for (BufferPoolMXBean bufferPoolBean : bufferPoolBeans) {
            String name = bufferPoolBean.getName();
            Gauge.builder((String)("BufferPool.used.memory." + name), (Object)bufferPoolBean, BufferPoolMXBean::getMemoryUsed).baseUnit("bytes").description("The memory used by the NIO pool:" + name).register(registry);
        }
        List<MemoryPoolMXBean> memoryPoolBeans = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean memoryPoolBean : memoryPoolBeans) {
            String name = memoryPoolBean.getName();
            Gauge.builder((String)("memoryPool." + name + ".usage"), (Object)memoryPoolBean, mem -> mem.getUsage().getUsed()).baseUnit("bytes").description("Current usage of the " + name + " memory pool").register(registry);
            Gauge.builder((String)("memoryPool." + name + ".usage.max"), (Object)memoryPoolBean, mem -> mem.getPeakUsage().getUsed()).baseUnit("bytes").description("Peak usage of the " + name + " memory pool").register(registry);
        }
    }
}

