/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.merging;

import java.util.List;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.metadata.ClassAnnotationInformation;
import org.jboss.as.ejb3.clustering.EJBBoundClusteringMetaData;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenComponentDescription;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.deployment.processors.merging.AbstractMergingProcessor;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.ejb3.annotation.ClusteredSingleton;
import org.jboss.metadata.ejb.spec.AssemblyDescriptorMetaData;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;

public class ClusteredSingletonMergingProcessor
extends AbstractMergingProcessor<MessageDrivenComponentDescription> {
    public ClusteredSingletonMergingProcessor() {
        super(MessageDrivenComponentDescription.class);
    }

    @Override
    protected void handleAnnotations(DeploymentUnit deploymentUnit, EEApplicationClasses applicationClasses, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, MessageDrivenComponentDescription componentDescription) throws DeploymentUnitProcessingException {
        EEModuleClassDescription clazz = applicationClasses.getClassByName(componentClass.getName());
        if (clazz == null) {
            return;
        }
        ClassAnnotationInformation clustering = clazz.getAnnotationInformation(ClusteredSingleton.class);
        if (clustering == null || clustering.getClassLevelAnnotations().isEmpty()) {
            return;
        }
        componentDescription.setClusteredSingleton(true);
    }

    @Override
    protected void handleDeploymentDescriptor(DeploymentUnit deploymentUnit, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, MessageDrivenComponentDescription componentDescription) throws DeploymentUnitProcessingException {
        List clusteringMetaDatas;
        AssemblyDescriptorMetaData assemblyMetadata;
        EjbJarMetaData ejbJarMetaData = (EjbJarMetaData)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_METADATA);
        Boolean allBeansClusteredSingleton = null;
        if (ejbJarMetaData != null && (assemblyMetadata = ejbJarMetaData.getAssemblyDescriptor()) != null && (clusteringMetaDatas = assemblyMetadata.getAny(EJBBoundClusteringMetaData.class)) != null) {
            for (EJBBoundClusteringMetaData clusteringMetaData : clusteringMetaDatas) {
                if ("*".equals(clusteringMetaData.getEjbName())) {
                    allBeansClusteredSingleton = clusteringMetaData.isClusteredSingleton();
                    continue;
                }
                if (!componentDescription.getComponentName().equals(clusteringMetaData.getEjbName())) continue;
                componentDescription.setClusteredSingleton(clusteringMetaData.isClusteredSingleton());
                return;
            }
        }
        if (allBeansClusteredSingleton != null && allBeansClusteredSingleton.booleanValue()) {
            componentDescription.setClusteredSingleton(true);
        }
    }
}

