/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote;

import jakarta.ejb.EJBHome;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.naming.ContextListAndJndiViewManagedReferenceFactory;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ValueManagedReference;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.EJBClient;
import org.jboss.ejb.client.EJBHomeLocator;
import org.jboss.ejb.client.EJBIdentifier;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.StatelessEJBLocator;
import org.jboss.msc.value.Value;
import org.wildfly.security.manager.WildFlySecurityManager;

public class RemoteViewManagedReferenceFactory
implements ContextListAndJndiViewManagedReferenceFactory {
    private final EJBIdentifier identifier;
    private final String viewClass;
    private final boolean stateful;
    private final Value<ClassLoader> viewClassLoader;
    private final boolean appclient;

    public RemoteViewManagedReferenceFactory(String appName, String moduleName, String distinctName, String beanName, String viewClass, boolean stateful, Value<ClassLoader> viewClassLoader, boolean appclient) {
        this(new EJBIdentifier(appName == null ? "" : appName, moduleName, beanName, distinctName), viewClass, stateful, viewClassLoader, appclient);
    }

    public RemoteViewManagedReferenceFactory(EJBIdentifier identifier, String viewClass, boolean stateful, Value<ClassLoader> viewClassLoader, boolean appclient) {
        this.identifier = identifier;
        this.viewClass = viewClass;
        this.stateful = stateful;
        this.viewClassLoader = viewClassLoader;
        this.appclient = appclient;
    }

    public String getInstanceClassName() {
        return this.viewClass;
    }

    public String getJndiViewInstanceValue() {
        return this.stateful ? "?" : String.valueOf(this.getReference().getInstance());
    }

    public ManagedReference getReference() {
        EJBHomeLocator ejbLocator;
        Class<?> viewClass;
        try {
            viewClass = Class.forName(this.viewClass, false, WildFlySecurityManager.getCurrentContextClassLoaderPrivileged());
        }
        catch (ClassNotFoundException e) {
            if (this.viewClassLoader == null || this.viewClassLoader.getValue() == null) {
                throw EjbLogger.ROOT_LOGGER.failToLoadViewClassEjb(this.identifier.toString(), e);
            }
            try {
                viewClass = Class.forName(this.viewClass, false, (ClassLoader)this.viewClassLoader.getValue());
            }
            catch (ClassNotFoundException ce) {
                throw EjbLogger.ROOT_LOGGER.failToLoadViewClassEjb(this.identifier.toString(), ce);
            }
        }
        if (EJBHome.class.isAssignableFrom(viewClass)) {
            ejbLocator = EJBHomeLocator.create(viewClass.asSubclass(EJBHome.class), (EJBIdentifier)this.identifier, (Affinity)(this.appclient ? Affinity.NONE : Affinity.LOCAL));
        } else if (this.stateful) {
            try {
                ejbLocator = EJBClient.createSession((StatelessEJBLocator)StatelessEJBLocator.create(viewClass, (EJBIdentifier)this.identifier, (Affinity)(this.appclient ? Affinity.NONE : Affinity.LOCAL)));
            }
            catch (Exception e) {
                throw EjbLogger.ROOT_LOGGER.failedToCreateSessionForStatefulBean(e, this.identifier.toString());
            }
        } else {
            ejbLocator = StatelessEJBLocator.create(viewClass, (EJBIdentifier)this.identifier, (Affinity)(this.appclient ? Affinity.NONE : Affinity.LOCAL));
        }
        Object proxy = EJBClient.createProxy((EJBLocator)ejbLocator);
        return new ValueManagedReference(proxy);
    }
}

