/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice.persistence.filestore;

import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionSynchronizationRegistry;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.ejb3.component.stateful.CurrentSynchronizationCallback;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.timerservice.TimerImpl;
import org.jboss.as.ejb3.timerservice.TimerServiceImpl;
import org.jboss.as.ejb3.timerservice.TimerState;
import org.jboss.as.ejb3.timerservice.persistence.TimerPersistence;
import org.jboss.as.ejb3.timerservice.persistence.filestore.EjbTimerXmlParser_1_0;
import org.jboss.as.ejb3.timerservice.persistence.filestore.EjbTimerXmlPersister;
import org.jboss.as.ejb3.timerservice.persistence.filestore.LegacyFileStore;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ModularClassResolver;
import org.jboss.marshalling.river.RiverMarshallerFactory;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.jboss.staxmapper.XMLMapper;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.wildfly.transaction.client.ContextTransactionManager;

public class FileTimerPersistence
implements TimerPersistence,
Service<FileTimerPersistence> {
    private static final FilePermission FILE_PERMISSION = new FilePermission("<<ALL FILES>>", "read,write,delete");
    private static final XMLInputFactory INPUT_FACTORY = XMLInputFactory.newInstance();
    private final boolean createIfNotExists;
    private MarshallerFactory factory;
    private MarshallingConfiguration configuration;
    private final InjectedValue<TransactionSynchronizationRegistry> transactionSynchronizationRegistry = new InjectedValue();
    private final InjectedValue<ModuleLoader> moduleLoader = new InjectedValue();
    private final InjectedValue<PathManager> pathManager = new InjectedValue();
    private final String path;
    private final String pathRelativeTo;
    private File baseDir;
    private PathManager.Callback.Handle callbackHandle;
    private final ConcurrentMap<String, Lock> locks = new ConcurrentHashMap<String, Lock>();
    private final ConcurrentMap<String, String> directories = new ConcurrentHashMap<String, String>();

    public FileTimerPersistence(boolean createIfNotExists, String path, String pathRelativeTo) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(FILE_PERMISSION);
        }
        this.createIfNotExists = createIfNotExists;
        this.path = path;
        this.pathRelativeTo = pathRelativeTo;
    }

    public void start(StartContext context) {
        if (WildFlySecurityManager.isChecking()) {
            WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    FileTimerPersistence.this.doStart();
                    return null;
                }
            });
        } else {
            this.doStart();
        }
    }

    private void doStart() {
        RiverMarshallerFactory factory = new RiverMarshallerFactory();
        MarshallingConfiguration configuration = new MarshallingConfiguration();
        configuration.setClassResolver((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)((ModuleLoader)this.moduleLoader.getValue())));
        configuration.setVersion(3);
        this.configuration = configuration;
        this.factory = factory;
        if (this.pathRelativeTo != null) {
            this.callbackHandle = ((PathManager)this.pathManager.getValue()).registerCallback(this.pathRelativeTo, PathManager.ReloadServerCallback.create(), new PathManager.Event[]{PathManager.Event.UPDATED, PathManager.Event.REMOVED});
        }
        this.baseDir = new File(((PathManager)this.pathManager.getValue()).resolveRelativePathEntry(this.path, this.pathRelativeTo));
        if (!this.baseDir.exists()) {
            if (this.createIfNotExists) {
                if (!this.baseDir.mkdirs()) {
                    throw EjbLogger.EJB3_TIMER_LOGGER.failToCreateTimerFileStoreDir(this.baseDir);
                }
            } else {
                throw EjbLogger.EJB3_TIMER_LOGGER.timerFileStoreDirNotExist(this.baseDir);
            }
        }
        if (!this.baseDir.isDirectory()) {
            throw EjbLogger.EJB3_TIMER_LOGGER.invalidTimerFileStoreDir(this.baseDir);
        }
    }

    public void stop(StopContext context) {
        this.locks.clear();
        this.directories.clear();
        if (this.callbackHandle != null) {
            this.callbackHandle.remove();
        }
        this.factory = null;
        this.configuration = null;
    }

    public FileTimerPersistence getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    @Override
    public void addTimer(final TimerImpl TimerImpl2) {
        if (WildFlySecurityManager.isChecking()) {
            WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    FileTimerPersistence.this.persistTimer(TimerImpl2, true);
                    return null;
                }
            });
        } else {
            this.persistTimer(TimerImpl2, true);
        }
    }

    @Override
    public void persistTimer(final TimerImpl TimerImpl2) {
        if (WildFlySecurityManager.isChecking()) {
            WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    FileTimerPersistence.this.persistTimer(TimerImpl2, false);
                    return null;
                }
            });
        } else {
            this.persistTimer(TimerImpl2, false);
        }
    }

    @Override
    public boolean shouldRun(TimerImpl timer) {
        return true;
    }

    private void persistTimer(TimerImpl timer, boolean newTimer) {
        Lock lock = this.getLock(timer.getTimedObjectId());
        try {
            int status = ContextTransactionManager.getInstance().getStatus();
            if (status == 1 || status == 4 || status == 9) {
                return;
            }
            lock.lock();
            if (status == 6 || status == 5 || this.isBeforeCompletion() || status == 3) {
                Map<String, TimerImpl> map = this.getTimers(timer.getTimedObjectId(), timer.getTimerService());
                if (timer.getState() == TimerState.CANCELED || timer.getState() == TimerState.EXPIRED) {
                    map.remove(timer.getId());
                    this.writeFile(timer);
                } else if (newTimer || map.containsKey(timer.getId())) {
                    map.put(timer.getId(), timer);
                    this.writeFile(timer);
                }
            } else {
                String key = this.timerTransactionKey(timer);
                Object existing = ((TransactionSynchronizationRegistry)this.transactionSynchronizationRegistry.getValue()).getResource((Object)key);
                if (existing == null) {
                    ((TransactionSynchronizationRegistry)this.transactionSynchronizationRegistry.getValue()).registerInterposedSynchronization((Synchronization)new PersistTransactionSynchronization(lock, key, newTimer));
                }
                ((TransactionSynchronizationRegistry)this.transactionSynchronizationRegistry.getValue()).putResource((Object)key, (Object)timer);
            }
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
        finally {
            lock.unlock();
        }
    }

    private String timerTransactionKey(TimerImpl TimerImpl2) {
        return "org.jboss.as.ejb3.timerTransactionKey." + TimerImpl2.getId();
    }

    @Override
    public void timerUndeployed(String timedObjectId) {
        Lock lock = this.getLock(timedObjectId);
        try {
            lock.lock();
            this.locks.remove(timedObjectId);
            this.directories.remove(timedObjectId);
        }
        finally {
            lock.unlock();
        }
    }

    private boolean isBeforeCompletion() {
        CurrentSynchronizationCallback.CallbackType type = CurrentSynchronizationCallback.get();
        if (type != null) {
            return type == CurrentSynchronizationCallback.CallbackType.BEFORE_COMPLETION;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TimerImpl> loadActiveTimers(String timedObjectId, TimerServiceImpl timerService) {
        Lock lock = this.getLock(timedObjectId);
        try {
            lock.lock();
            Map<String, TimerImpl> timers = this.getTimers(timedObjectId, timerService);
            ArrayList<TimerImpl> entities = new ArrayList<TimerImpl>();
            for (Map.Entry<String, TimerImpl> entry : timers.entrySet()) {
                entities.add(this.mostRecentEntityVersion(entry.getValue()));
            }
            ArrayList<TimerImpl> arrayList = entities;
            return arrayList;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Closeable registerChangeListener(String timedObjectId, TimerPersistence.TimerChangeListener listener) {
        return new Closeable(){

            @Override
            public void close() throws IOException {
            }
        };
    }

    private TimerImpl mostRecentEntityVersion(TimerImpl timerImpl) {
        try {
            int status = ContextTransactionManager.getInstance().getStatus();
            if (status == 5 || status == 6) {
                return timerImpl;
            }
            String key = this.timerTransactionKey(timerImpl);
            TimerImpl existing = (TimerImpl)((TransactionSynchronizationRegistry)this.transactionSynchronizationRegistry.getValue()).getResource((Object)key);
            return existing != null ? existing : timerImpl;
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
    }

    private Lock getLock(String timedObjectId) {
        ReentrantLock addedLock;
        Lock lock = (Lock)this.locks.get(timedObjectId);
        if (lock == null && (lock = this.locks.putIfAbsent(timedObjectId, addedLock = new ReentrantLock())) == null) {
            lock = addedLock;
        }
        return lock;
    }

    private Map<String, TimerImpl> getTimers(String timedObjectId, TimerServiceImpl timerService) {
        return this.loadTimersFromFile(timedObjectId, timerService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, TimerImpl> loadTimersFromFile(String timedObjectId, TimerServiceImpl timerService) {
        HashMap<String, TimerImpl> timers = new HashMap<String, TimerImpl>();
        String directory = this.getDirectory(timedObjectId);
        timers.putAll(LegacyFileStore.loadTimersFromFile(timedObjectId, timerService, directory, this.factory, this.configuration));
        for (Map.Entry entry : timers.entrySet()) {
            this.writeFile((TimerImpl)entry.getValue());
        }
        File file = new File(directory);
        if (!file.exists()) {
            return timers;
        }
        if (!file.isDirectory()) {
            EjbLogger.EJB3_TIMER_LOGGER.failToRestoreTimers(file);
            return timers;
        }
        XMLMapper mapper = this.createMapper(timerService);
        block15: for (File timerFile : file.listFiles()) {
            if (!timerFile.getName().endsWith(".xml")) continue;
            FileInputStream in = null;
            try {
                in = new FileInputStream(timerFile);
                XMLInputFactory inputFactory = INPUT_FACTORY;
                this.setIfSupported(inputFactory, "javax.xml.stream.isValidating", Boolean.FALSE);
                this.setIfSupported(inputFactory, "javax.xml.stream.supportDTD", Boolean.FALSE);
                XMLStreamReader streamReader = inputFactory.createXMLStreamReader(in);
                try {
                    ArrayList timerList = new ArrayList();
                    mapper.parseDocument(timerList, streamReader);
                    for (TimerImpl timer : timerList) {
                        if (timer.getId().equals("deleted-timer")) {
                            timerFile.delete();
                            continue block15;
                        }
                        timers.put(timer.getId(), timer);
                    }
                }
                finally {
                    TimerServiceImpl.safeClose(in);
                }
            }
            catch (Exception e) {
                EjbLogger.EJB3_TIMER_LOGGER.failToRestoreTimersFromFile(timerFile, e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        EjbLogger.EJB3_TIMER_LOGGER.failToCloseFile(e);
                    }
                }
            }
        }
        return timers;
    }

    private XMLMapper createMapper(TimerServiceImpl timerService) {
        XMLMapper mapper = XMLMapper.Factory.create();
        mapper.registerRootElement(new QName("urn:jboss:wildfly:ejb-timers:1.0", "timers"), (XMLElementReader)new EjbTimerXmlParser_1_0(timerService, this.factory, this.configuration, timerService.getInvoker().getClassLoader()));
        return mapper;
    }

    private File fileName(String timedObjectId, String timerId) {
        return new File(this.getDirectory(timedObjectId) + File.separator + timerId.replace(File.separator, "-") + ".xml");
    }

    private String getDirectory(String timedObjectId) {
        Object dirName = (String)this.directories.get(timedObjectId);
        if (dirName == null) {
            dirName = this.baseDir.getAbsolutePath() + File.separator + timedObjectId.replace(File.separator, "-");
            File file = new File((String)dirName);
            if (!file.exists() && !file.mkdirs()) {
                EjbLogger.EJB3_TIMER_LOGGER.failToCreateDirectoryForPersistTimers(file);
            }
            this.directories.put(timedObjectId, (String)dirName);
        }
        return dirName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(TimerImpl timer) {
        File file = this.fileName(timer.getTimedObjectId(), timer.getId());
        if (timer.getState() == TimerState.CANCELED || timer.getState() == TimerState.EXPIRED) {
            if (file.exists()) {
                file.delete();
            }
            return;
        }
        try {
            FileOutputStream out = new FileOutputStream(file);
            try {
                XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(out);
                XMLMapper mapper = this.createMapper(timer.getTimerService());
                mapper.deparseDocument((XMLElementWriter)new EjbTimerXmlPersister(this.factory, this.configuration), Collections.singletonList(timer), writer);
                writer.flush();
                writer.close();
            }
            finally {
                TimerServiceImpl.safeClose(out);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public InjectedValue<TransactionSynchronizationRegistry> getTransactionSynchronizationRegistry() {
        return this.transactionSynchronizationRegistry;
    }

    public InjectedValue<ModuleLoader> getModuleLoader() {
        return this.moduleLoader;
    }

    public InjectedValue<PathManager> getPathManager() {
        return this.pathManager;
    }

    private void setIfSupported(XMLInputFactory inputFactory, String property, Object value) {
        if (inputFactory.isPropertySupported(property)) {
            inputFactory.setProperty(property, value);
        }
    }

    public static XMLExtendedStreamWriter create(XMLStreamWriter writer) throws Exception {
        Class<?> clazz = Class.forName("org.jboss.staxmapper.FormattingXMLStreamWriter");
        Constructor<?> ctr = clazz.getConstructor(XMLStreamWriter.class);
        ctr.setAccessible(true);
        return (XMLExtendedStreamWriter)ctr.newInstance(writer);
    }

    private final class PersistTransactionSynchronization
    implements Synchronization {
        private final String transactionKey;
        private final Lock lock;
        private final boolean newTimer;
        private volatile TimerImpl timer;

        public PersistTransactionSynchronization(Lock lock, String transactionKey, boolean newTimer) {
            this.lock = lock;
            this.transactionKey = transactionKey;
            this.newTimer = newTimer;
        }

        public void beforeCompletion() {
            this.timer = (TimerImpl)((TransactionSynchronizationRegistry)FileTimerPersistence.this.transactionSynchronizationRegistry.getValue()).getResource((Object)this.transactionKey);
            if (this.timer == null) {
                return;
            }
        }

        public void afterCompletion(final int status) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    if (PersistTransactionSynchronization.this.timer == null) {
                        return null;
                    }
                    try {
                        PersistTransactionSynchronization.this.lock.lock();
                        if (status == 3) {
                            Map<String, TimerImpl> map = FileTimerPersistence.this.getTimers(PersistTransactionSynchronization.this.timer.getTimedObjectId(), PersistTransactionSynchronization.this.timer.getTimerService());
                            if (PersistTransactionSynchronization.this.timer.getState() == TimerState.CANCELED || PersistTransactionSynchronization.this.timer.getState() == TimerState.EXPIRED) {
                                map.remove(PersistTransactionSynchronization.this.timer.getId());
                            } else if (PersistTransactionSynchronization.this.newTimer || map.containsKey(PersistTransactionSynchronization.this.timer.getId())) {
                                map.put(PersistTransactionSynchronization.this.timer.getId(), PersistTransactionSynchronization.this.timer);
                            }
                            FileTimerPersistence.this.writeFile(PersistTransactionSynchronization.this.timer);
                        }
                    }
                    finally {
                        PersistTransactionSynchronization.this.lock.unlock();
                    }
                    return null;
                }
            });
        }
    }
}

