/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.common;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AbstractAttachable;
import java.util.function.Function;
import org.wildfly.httpclient.common.EENamespaceInteroperability;
import org.wildfly.httpclient.common.HttpMarshallerFactory;
import org.wildfly.httpclient.common.HttpMarshallerFactoryProvider;

public enum HttpServiceConfig {
    DEFAULT(EENamespaceInteroperability::createPartialInteroperabilityHandler, HttpMarshallerFactoryProvider.getDefaultHttpMarshallerFactoryProvider()),
    EE_NAMESPACE_INTEROPERABLE_MODE(EENamespaceInteroperability::createInteroperabilityHandler, EENamespaceInteroperability.getHttpMarshallerFactoryProvider());

    private final Function<HttpHandler, HttpHandler> handlerWrapper;
    private final HttpMarshallerFactoryProvider marshallerFactoryProvider;

    public static HttpServiceConfig getInstance() {
        if (EENamespaceInteroperability.EE_NAMESPACE_INTEROPERABLE_MODE) {
            return EE_NAMESPACE_INTEROPERABLE_MODE;
        }
        return DEFAULT;
    }

    private HttpServiceConfig(Function<HttpHandler, HttpHandler> handlerWrapper, HttpMarshallerFactoryProvider marshallerFactoryProvider) {
        this.handlerWrapper = handlerWrapper;
        this.marshallerFactoryProvider = marshallerFactoryProvider;
    }

    public HttpHandler wrap(HttpHandler handler) {
        return this.handlerWrapper.apply(handler);
    }

    public HttpMarshallerFactory getHttpUnmarshallerFactory(HttpServerExchange exchange) {
        return this.marshallerFactoryProvider.getUnmarshallerFactory((AbstractAttachable)exchange);
    }

    public HttpMarshallerFactory getHttpMarshallerFactory(HttpServerExchange exchange) {
        return this.marshallerFactoryProvider.getMarshallerFactory((AbstractAttachable)exchange);
    }
}

