/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.data;

import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.data.Data;
import io.opentelemetry.sdk.metrics.data.DoublePointData;
import io.opentelemetry.sdk.metrics.data.GaugeData;
import io.opentelemetry.sdk.metrics.data.HistogramData;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import io.opentelemetry.sdk.metrics.data.MetricDataImpl;
import io.opentelemetry.sdk.metrics.data.MetricDataType;
import io.opentelemetry.sdk.metrics.data.SumData;
import io.opentelemetry.sdk.metrics.data.SummaryData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableGaugeData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableHistogramData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableSumData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableSummaryData;
import io.opentelemetry.sdk.metrics.internal.data.exponentialhistogram.ExponentialHistogramData;
import io.opentelemetry.sdk.resources.Resource;
import javax.annotation.concurrent.Immutable;

@Immutable
public interface MetricData {
    public static MetricData createDoubleGauge(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, String name, String description, String unit, GaugeData<DoublePointData> data) {
        return MetricDataImpl.create(resource, instrumentationLibraryInfo, name, description, unit, MetricDataType.DOUBLE_GAUGE, data);
    }

    public static MetricData createLongGauge(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, String name, String description, String unit, GaugeData<LongPointData> data) {
        return MetricDataImpl.create(resource, instrumentationLibraryInfo, name, description, unit, MetricDataType.LONG_GAUGE, data);
    }

    public static MetricData createDoubleSum(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, String name, String description, String unit, SumData<DoublePointData> data) {
        return MetricDataImpl.create(resource, instrumentationLibraryInfo, name, description, unit, MetricDataType.DOUBLE_SUM, data);
    }

    public static MetricData createLongSum(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, String name, String description, String unit, SumData<LongPointData> data) {
        return MetricDataImpl.create(resource, instrumentationLibraryInfo, name, description, unit, MetricDataType.LONG_SUM, data);
    }

    public static MetricData createDoubleSummary(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, String name, String description, String unit, SummaryData data) {
        return MetricDataImpl.create(resource, instrumentationLibraryInfo, name, description, unit, MetricDataType.SUMMARY, data);
    }

    public static MetricData createDoubleHistogram(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, String name, String description, String unit, HistogramData data) {
        return MetricDataImpl.create(resource, instrumentationLibraryInfo, name, description, unit, MetricDataType.HISTOGRAM, data);
    }

    public static MetricData createExponentialHistogram(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, String name, String description, String unit, ExponentialHistogramData data) {
        return MetricDataImpl.create(resource, instrumentationLibraryInfo, name, description, unit, MetricDataType.EXPONENTIAL_HISTOGRAM, data);
    }

    public Resource getResource();

    public InstrumentationLibraryInfo getInstrumentationLibraryInfo();

    public String getName();

    public String getDescription();

    public String getUnit();

    public MetricDataType getType();

    public Data<?> getData();

    default public boolean isEmpty() {
        return this.getData().getPoints().isEmpty();
    }

    default public GaugeData<DoublePointData> getDoubleGaugeData() {
        if (this.getType() == MetricDataType.DOUBLE_GAUGE) {
            return (GaugeData)this.getData();
        }
        return ImmutableGaugeData.empty();
    }

    default public GaugeData<LongPointData> getLongGaugeData() {
        if (this.getType() == MetricDataType.LONG_GAUGE) {
            return (GaugeData)this.getData();
        }
        return ImmutableGaugeData.empty();
    }

    default public SumData<DoublePointData> getDoubleSumData() {
        if (this.getType() == MetricDataType.DOUBLE_SUM) {
            return (ImmutableSumData)this.getData();
        }
        return ImmutableSumData.empty();
    }

    default public SumData<LongPointData> getLongSumData() {
        if (this.getType() == MetricDataType.LONG_SUM) {
            return (SumData)this.getData();
        }
        return ImmutableSumData.empty();
    }

    default public SummaryData getSummaryData() {
        if (this.getType() == MetricDataType.SUMMARY) {
            return (SummaryData)this.getData();
        }
        return ImmutableSummaryData.empty();
    }

    default public HistogramData getHistogramData() {
        if (this.getType() == MetricDataType.HISTOGRAM) {
            return (HistogramData)this.getData();
        }
        return ImmutableHistogramData.empty();
    }
}

