/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet.deployment;

import jakarta.batch.operations.JobExecutionAlreadyCompleteException;
import jakarta.batch.operations.JobExecutionNotMostRecentException;
import jakarta.batch.operations.JobExecutionNotRunningException;
import jakarta.batch.operations.JobRestartException;
import jakarta.batch.operations.JobSecurityException;
import jakarta.batch.operations.NoSuchJobExecutionException;
import jakarta.batch.runtime.BatchStatus;
import jakarta.batch.runtime.JobExecution;
import jakarta.batch.runtime.JobInstance;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Properties;
import java.util.function.Function;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleMapAttributeDefinition;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.batch.jberet.BatchResourceDescriptionResolver;
import org.wildfly.extension.batch.jberet.deployment.JobOperationReadOnlyStepHandler;
import org.wildfly.extension.batch.jberet.deployment.JobOperationStepHandler;
import org.wildfly.extension.batch.jberet.deployment.WildFlyJobOperator;

public class BatchJobExecutionResourceDefinition
extends SimpleResourceDefinition {
    static final String EXECUTION = "execution";
    static final SimpleAttributeDefinition INSTANCE_ID = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"instance-id", (ModelType)ModelType.LONG).setStorageRuntime()).build();
    static final SimpleAttributeDefinition BATCH_STATUS = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"batch-status", (ModelType)ModelType.STRING).setStorageRuntime()).build();
    static final SimpleAttributeDefinition EXIT_STATUS = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"exit-status", (ModelType)ModelType.STRING).setStorageRuntime()).build();
    static final SimpleAttributeDefinition CREATE_TIME = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"create-time", (ModelType)ModelType.STRING).setStorageRuntime()).build();
    static final SimpleAttributeDefinition START_TIME = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"start-time", (ModelType)ModelType.STRING).setStorageRuntime()).build();
    static final SimpleAttributeDefinition LAST_UPDATED_TIME = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"last-updated-time", (ModelType)ModelType.STRING).setStorageRuntime()).build();
    static final SimpleAttributeDefinition END_TIME = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"end-time", (ModelType)ModelType.STRING).setStorageRuntime()).build();
    private static final ZoneId DEFAULT_ZONE_ID = ZoneId.systemDefault();
    private static final ResourceDescriptionResolver DEFAULT_RESOLVER = BatchResourceDescriptionResolver.getResourceDescriptionResolver("deployment", "job", "execution");
    private static final SimpleMapAttributeDefinition PROPERTIES = new SimpleMapAttributeDefinition.Builder("properties", ModelType.STRING, true).build();
    private static final SimpleOperationDefinition RESTART_JOB = new SimpleOperationDefinitionBuilder("restart-job", DEFAULT_RESOLVER).setParameters(new AttributeDefinition[]{PROPERTIES}).setReplyType(ModelType.LONG).setRuntimeOnly().build();
    private static final SimpleOperationDefinition STOP_JOB = new SimpleOperationDefinitionBuilder("stop-job", DEFAULT_RESOLVER).setRuntimeOnly().build();

    public BatchJobExecutionResourceDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)EXECUTION), DEFAULT_RESOLVER).setRuntime());
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)INSTANCE_ID, (OperationStepHandler)new JobOperationReadOnlyStepHandler(){

            @Override
            protected void updateModel(OperationContext context, ModelNode model, WildFlyJobOperator jobOperator, String jobName) throws OperationFailedException {
                JobInstance jobInstance = jobOperator.getJobInstance(Long.parseLong(context.getCurrentAddressValue()));
                model.set(jobInstance.getInstanceId());
            }
        });
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)BATCH_STATUS, (OperationStepHandler)new JobExecutionOperationStepHandler(){

            @Override
            protected void updateModel(ModelNode model, JobExecution jobExecution) throws OperationFailedException {
                BatchStatus status = jobExecution.getBatchStatus();
                if (status != null) {
                    model.set(status.toString());
                }
            }
        });
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)EXIT_STATUS, (OperationStepHandler)new JobExecutionOperationStepHandler(){

            @Override
            protected void updateModel(ModelNode model, JobExecution jobExecution) throws OperationFailedException {
                String exitStatus = jobExecution.getExitStatus();
                if (exitStatus != null) {
                    model.set(exitStatus);
                }
            }
        });
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)CREATE_TIME, (OperationStepHandler)new DateTimeFormatterOperationStepHandler(JobExecution::getCreateTime));
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)START_TIME, (OperationStepHandler)new DateTimeFormatterOperationStepHandler(JobExecution::getStartTime));
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)LAST_UPDATED_TIME, (OperationStepHandler)new DateTimeFormatterOperationStepHandler(JobExecution::getLastUpdatedTime));
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)END_TIME, (OperationStepHandler)new DateTimeFormatterOperationStepHandler(JobExecution::getEndTime));
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler((OperationDefinition)STOP_JOB, (OperationStepHandler)new JobOperationStepHandler(){

            @Override
            protected void execute(OperationContext context, ModelNode operation, WildFlyJobOperator jobOperator) throws OperationFailedException {
                long executionId = Long.parseLong(context.getCurrentAddressValue());
                try {
                    jobOperator.stop(executionId);
                }
                catch (JobExecutionNotRunningException | JobSecurityException | NoSuchJobExecutionException e) {
                    throw 4.createOperationFailure(e);
                }
            }
        });
        resourceRegistration.registerOperationHandler((OperationDefinition)RESTART_JOB, (OperationStepHandler)new JobOperationStepHandler(){

            @Override
            protected void execute(OperationContext context, ModelNode operation, WildFlyJobOperator jobOperator) throws OperationFailedException {
                long executionId = Long.parseLong(context.getCurrentAddressValue());
                Properties properties = 5.resolvePropertyValue(context, operation, (AttributeDefinition)PROPERTIES);
                try {
                    long newExecutionId = jobOperator.restart(executionId, properties);
                    context.getResult().set(newExecutionId);
                }
                catch (JobExecutionAlreadyCompleteException | JobExecutionNotMostRecentException | JobRestartException | JobSecurityException | NoSuchJobExecutionException e) {
                    throw 5.createOperationFailure(e);
                }
            }
        });
    }

    static class DateTimeFormatterOperationStepHandler
    extends JobExecutionOperationStepHandler {
        private final Function<JobExecution, Date> dateGetter;

        public DateTimeFormatterOperationStepHandler(Function<JobExecution, Date> dateGetter) {
            this.dateGetter = dateGetter;
        }

        @Override
        protected void updateModel(ModelNode model, JobExecution jobExecution) throws OperationFailedException {
            Date date = this.dateGetter.apply(jobExecution);
            if (date != null) {
                model.set(DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), DEFAULT_ZONE_ID)));
            }
        }
    }

    static abstract class JobExecutionOperationStepHandler
    extends JobOperationReadOnlyStepHandler {
        JobExecutionOperationStepHandler() {
        }

        @Override
        protected void updateModel(OperationContext context, ModelNode model, WildFlyJobOperator jobOperator, String jobName) throws OperationFailedException {
            JobExecution jobExecution = jobOperator.getJobExecution(Long.parseLong(context.getCurrentAddressValue()));
            this.updateModel(model, jobExecution);
        }

        protected abstract void updateModel(ModelNode var1, JobExecution var2) throws OperationFailedException;
    }
}

