/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh.cmd.security.ssl;

import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Option;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.impl.aesh.cmd.security.HttpServerCommandActivator;
import org.jboss.as.cli.impl.aesh.cmd.security.SecurityCommand;
import org.jboss.as.cli.impl.aesh.cmd.security.model.DefaultResourceNames;
import org.jboss.as.cli.impl.aesh.cmd.security.model.HTTPServer;
import org.jboss.as.cli.impl.aesh.cmd.security.model.SSLSecurityBuilder;
import org.jboss.as.cli.impl.aesh.cmd.security.ssl.AbstractEnableSSLCommand;
import org.jboss.as.cli.impl.aesh.cmd.security.ssl.OptionActivators;
import org.wildfly.core.cli.command.aesh.CLICommandInvocation;

@CommandDefinition(name="enable-ssl-http-server", description="", activator=HttpServerCommandActivator.class)
public class HTTPServerEnableSSLCommand
extends AbstractEnableSSLCommand {
    @Option(name="server-name", completer=SecurityCommand.OptionCompleters.ServerNameCompleter.class)
    String serverName;
    @Option(name="no-override-security-realm", activator=OptionActivators.NoOverrideSecurityRealmActivator.class, hasValue=false)
    boolean noOverride;
    @Option(name="override-ssl-context", hasValue=false)
    boolean overrideSSLContext;
    @Option(name="add-https-listener", hasValue=false)
    boolean addHttpsListener;
    @Option(name="https-listener-name", completer=SecurityCommand.OptionCompleters.NewHTTPSListenerCompleter.class, hasValue=true, defaultValue={"https"})
    String httpsListener;
    @Option(name="https-listener-socket-binding-name", activator=OptionActivators.DependsOnAddHttpsListenerActivator.class, hasValue=true, defaultValue={"https"}, completer=SecurityCommand.OptionCompleters.SocketBindingCompleter.class)
    String httpsListenerSocketBinding;

    public HTTPServerEnableSSLCommand(CommandContext ctx) {
        super(ctx);
    }

    public boolean hasAddHTTPSListener() {
        return this.addHttpsListener;
    }

    public String getServerName(CommandContext ctx) {
        String sName = this.serverName;
        if (sName == null) {
            sName = DefaultResourceNames.getDefaultServerName(ctx);
        }
        return sName;
    }

    @Override
    protected void secure(CommandContext ctx, SSLSecurityBuilder builder) throws CommandException {
        try {
            HTTPServer.enableSSL(this.serverName, this.addHttpsListener, this.httpsListener, this.httpsListenerSocketBinding, this.noOverride, ctx, builder);
        }
        catch (Exception ex) {
            throw new CommandException((Throwable)ex);
        }
    }

    @Override
    public CommandResult execute(CLICommandInvocation commandInvocation) throws CommandException, InterruptedException {
        CommandResult result = super.execute(commandInvocation);
        if (this.addHttpsListener) {
            commandInvocation.getCommandContext().printLine("HTTPS listener " + this.httpsListener + " has been added");
        }
        return result;
    }

    @Override
    protected boolean isSSLEnabled(CommandContext ctx) throws Exception {
        String target = this.getServerName(ctx);
        if (HTTPServer.hasHttpsListener(ctx, target, this.httpsListener)) {
            if (HTTPServer.getSSLContextName(target, this.httpsListener, ctx) != null && !this.overrideSSLContext) {
                throw new Exception("An SSL server context already exists on the HTTPS listener, use --override-ssl-context option to overwrite the existing SSL context");
            }
        } else if (!this.addHttpsListener) {
            throw new Exception("No HTTPS listener found, you must use --add-https-listener option to add an https listener to " + target + " server.");
        }
        return false;
    }

    @Override
    protected String getTarget(CommandContext ctx) {
        String target = this.serverName;
        if (target == null) {
            target = DefaultResourceNames.getDefaultServerName(ctx);
        }
        return target;
    }

    @Override
    String getDefaultKeyStoreFileName(CommandContext ctx) {
        return this.getTarget(ctx) + ".keystore";
    }

    @Override
    String getDefaultTrustStoreFileName(CommandContext ctx) {
        return this.getTarget(ctx) + ".truststore";
    }
}

