/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.addressing;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Before;
import org.junit.Test;

public class SendDLQNoRouteTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private ClientSessionFactory sessionFactory;

    @Before
    public void setup() throws Exception {
        this.server = this.createServer(true);
        this.server.start();
    }

    @Test(timeout=20000L)
    public void testDLQNoRoute() throws Exception {
        AddressSettings addressSettings = new AddressSettings().setSendToDLAOnNoRoute(true);
        addressSettings.setDeadLetterAddress(SimpleString.toSimpleString((String)"DLA"));
        this.server.getAddressSettingsRepository().addMatch("#", (Object)addressSettings);
        AddressInfo info = new AddressInfo(SimpleString.toSimpleString((String)"info")).addRoutingType(RoutingType.MULTICAST);
        this.server.addAddressInfo(info);
        AddressInfo dla = new AddressInfo(SimpleString.toSimpleString((String)"DLA")).addRoutingType(RoutingType.MULTICAST);
        this.server.addAddressInfo(dla);
        ServerLocator locator = this.createNonHALocator(false);
        ClientSessionFactory factory = locator.createSessionFactory();
        ClientSession session = factory.createSession(true, true);
        ClientProducer producer = session.createProducer("info");
        producer.send((Message)session.createMessage(true));
        session.commit();
    }
}

