/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.Assert;
import org.junit.Test;

public class JmsNettyNioStressTest
extends ActiveMQTestBase {
    @Test
    public void testStressSendNetty() throws Exception {
        this.doTestStressSend(true);
    }

    public void doTestStressSend(boolean netty) throws Exception {
        int i;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("port", 61616);
        params.put("host", "localhost");
        params.put("useNio", true);
        params.put("nioRemotingThreads", 1);
        params.put("batchDelay", 50);
        TransportConfiguration transportConfig = new TransportConfiguration(ActiveMQTestBase.NETTY_ACCEPTOR_FACTORY, params);
        ConfigurationImpl config = this.createBasicConfig().setJMXManagementEnabled(false).clearAcceptorConfigurations().addAcceptorConfiguration(transportConfig);
        ActiveMQServer server = this.createServer(true, (Configuration)config);
        server.getAddressSettingsRepository().clear();
        AddressSettings defaultSetting = new AddressSettings().setPageSizeBytes(0xA00000).setMaxSizeBytes(-1L).setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE).setAutoDeleteAddresses(Boolean.valueOf(false)).setAutoCreateAddresses(Boolean.valueOf(true)).setAutoCreateQueues(Boolean.valueOf(false));
        server.getAddressSettingsRepository().addMatch("#", (Object)defaultSetting);
        server.getConfiguration().setThreadPoolMaxSize(2);
        server.start();
        HashMap<String, Object> connectionParams = new HashMap<String, Object>();
        connectionParams.put("port", 61616);
        connectionParams.put("host", "localhost");
        connectionParams.put("useNio", true);
        connectionParams.put("batchDelay", 50);
        connectionParams.put("nioRemotingThreads", 6);
        TransportConfiguration transpConf = new TransportConfiguration(NettyConnectorFactory.class.getName(), connectionParams);
        ServerLocator locator = this.createNonHALocator(netty);
        int numberOfMessages = 100;
        int numProducers = 5;
        int numConsumerProducers = 5;
        int numConsumers = 5;
        final AtomicInteger totalCount = new AtomicInteger(0);
        int totalExpectedCount = 1500;
        ClientSessionFactory sf = locator.createSessionFactory(transpConf);
        ClientSession session = sf.createTransactedSession();
        session.createAddress(SimpleString.toSimpleString((String)"queue"), RoutingType.ANYCAST, false);
        session.createAddress(SimpleString.toSimpleString((String)"queue2"), RoutingType.ANYCAST, false);
        Assert.assertTrue((boolean)session.addressQuery(SimpleString.toSimpleString((String)"queue")).isExists());
        Assert.assertTrue((boolean)session.addressQuery(SimpleString.toSimpleString((String)"queue2")).isExists());
        session.createQueue(new QueueConfiguration("queue").setRoutingType(RoutingType.ANYCAST));
        session.createQueue(new QueueConfiguration("queue2").setRoutingType(RoutingType.ANYCAST));
        Assert.assertTrue((boolean)session.addressQuery(SimpleString.toSimpleString((String)"queue")).isExists());
        Assert.assertTrue((boolean)session.addressQuery(SimpleString.toSimpleString((String)"queue2")).isExists());
        session.commit();
        sf.close();
        session.close();
        locator.close();
        ActiveMQConnectionFactory cf = ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{transpConf});
        final Connection connectionProducer = cf.createConnection();
        connectionProducer.start();
        final Connection connectionConsumerProducer = cf.createConnection();
        connectionConsumerProducer.start();
        final Connection connectionConsumer = cf.createConnection();
        connectionConsumer.start();
        session.close();
        for (i = 0; i < 5; ++i) {
            new Thread(){

                @Override
                public void run() {
                    Session session = null;
                    try {
                        session = connectionProducer.createSession(true, 0);
                        MessageProducer messageProducer = session.createProducer((Destination)ActiveMQDestination.createQueue((String)"queue"));
                        messageProducer.setDeliveryMode(1);
                        for (int i = 0; i < 100; ++i) {
                            BytesMessage message = session.createBytesMessage();
                            message.writeBytes(new byte[3000]);
                            message.setStringProperty("Service", "LoadShedService");
                            message.setStringProperty("Action", "testAction");
                            messageProducer.send((Message)message);
                            session.commit();
                            totalCount.incrementAndGet();
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        if (session != null) {
                            try {
                                session.close();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }.start();
        }
        for (i = 0; i < 5; ++i) {
            new Thread(){

                @Override
                public void run() {
                    Session session = null;
                    try {
                        session = connectionConsumerProducer.createSession(true, 0);
                        MessageConsumer consumer = session.createConsumer((Destination)ActiveMQDestination.createQueue((String)"queue"));
                        MessageProducer messageProducer = session.createProducer((Destination)ActiveMQDestination.createQueue((String)"queue2"));
                        messageProducer.setDeliveryMode(1);
                        for (int i = 0; i < 100; ++i) {
                            BytesMessage message = (BytesMessage)consumer.receive(5000L);
                            if (message == null) {
                                return;
                            }
                            message = session.createBytesMessage();
                            message.writeBytes(new byte[3000]);
                            message.setStringProperty("Service", "LoadShedService");
                            message.setStringProperty("Action", "testAction");
                            messageProducer.send((Message)message);
                            session.commit();
                            totalCount.incrementAndGet();
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        if (session != null) {
                            try {
                                session.close();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }.start();
        }
        for (i = 0; i < 5; ++i) {
            new Thread(){

                @Override
                public void run() {
                    Session session = null;
                    try {
                        session = connectionConsumer.createSession(true, 0);
                        MessageConsumer consumer = session.createConsumer((Destination)ActiveMQDestination.createQueue((String)"queue2"));
                        for (int i = 0; i < 100; ++i) {
                            BytesMessage message = (BytesMessage)consumer.receive(5000L);
                            if (message == null) {
                                return;
                            }
                            session.commit();
                            totalCount.incrementAndGet();
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        if (session != null) {
                            try {
                                session.close();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }.start();
        }
        Wait.waitFor(() -> totalExpectedCount == totalCount.get(), (long)60000L, (long)100L);
        Assert.assertEquals((String)"Possible deadlock", (long)totalExpectedCount, (long)totalCount.get());
        connectionProducer.close();
        connectionConsumerProducer.close();
        connectionConsumer.close();
        server.stop();
    }
}

