/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.bridge;

import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.cluster.impl.BridgeImpl;
import org.apache.activemq.artemis.tests.integration.cluster.util.MultiServerTestBase;
import org.junit.Test;

public class BridgeFailoverTest
extends MultiServerTestBase {
    @Test
    public void testSimpleConnectOnMultipleNodes() throws Exception {
        BridgeConfiguration bridgeConfiguration = new BridgeConfiguration();
        String ORIGINAL_QUEUE = "noCluster.originalQueue";
        String TARGET_QUEUE = "noCluster.targetQueue";
        bridgeConfiguration.setHA(true);
        ArrayList<String> connectors = new ArrayList<String>();
        connectors.add("target-4");
        connectors.add("backup-4");
        bridgeConfiguration.setName("Bridge-for-test");
        bridgeConfiguration.setStaticConnectors(connectors);
        bridgeConfiguration.setQueueName(ORIGINAL_QUEUE);
        bridgeConfiguration.setForwardingAddress(TARGET_QUEUE);
        bridgeConfiguration.setRetryInterval(100L);
        bridgeConfiguration.setConfirmationWindowSize(1);
        bridgeConfiguration.setReconnectAttempts(-1);
        this.servers[2].getConfiguration().getBridgeConfigurations().add(bridgeConfiguration);
        for (ActiveMQServer server : this.servers) {
            server.getConfiguration().addQueueConfiguration(new QueueConfiguration(ORIGINAL_QUEUE));
            server.getConfiguration().addQueueConfiguration(new QueueConfiguration(TARGET_QUEUE));
        }
        this.startServers();
        ServerLocator locator = this.createLocator(false, 2);
        ClientSessionFactory factory = this.addSessionFactory(locator.createSessionFactory());
        ClientSession session = this.addClientSession(factory.createSession(false, false));
        ClientProducer producer = this.addClientProducer(session.createProducer(ORIGINAL_QUEUE));
        for (int i = 0; i < 100; ++i) {
            ClientMessage msg = session.createMessage(true);
            msg.putIntProperty("i", i);
            producer.send((Message)msg);
        }
        session.commit();
        ServerLocator locatorConsumer = this.createLocator(false, 4);
        ClientSessionFactory factoryConsumer = this.addSessionFactory(locatorConsumer.createSessionFactory());
        ClientSession sessionConsumer = this.addClientSession(factoryConsumer.createSession(false, false));
        ClientConsumer consumer = sessionConsumer.createConsumer(TARGET_QUEUE);
        sessionConsumer.start();
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = consumer.receive(10000L);
            BridgeFailoverTest.assertNotNull((Object)message);
            message.acknowledge();
        }
        sessionConsumer.commit();
    }

    @Test
    public void testFailoverOnBridgeNoRetryOnSameNode() throws Exception {
        this.internalTestFailoverOnBridge(0);
    }

    @Test
    public void testFailoverOnBridgeForeverRetryOnSameNode() throws Exception {
        this.internalTestFailoverOnBridge(-1);
    }

    public void internalTestFailoverOnBridge(int retriesSameNode) throws Exception {
        ClientMessage message;
        int i;
        BridgeConfiguration bridgeConfiguration = new BridgeConfiguration();
        String ORIGINAL_QUEUE = "noCluster.originalQueue";
        String TARGET_QUEUE = "noCluster.targetQueue";
        bridgeConfiguration.setHA(true);
        ArrayList<String> connectors = new ArrayList<String>();
        connectors.add("target-4");
        connectors.add("backup-4");
        bridgeConfiguration.setName("Bridge-for-test");
        bridgeConfiguration.setStaticConnectors(connectors);
        bridgeConfiguration.setQueueName(ORIGINAL_QUEUE);
        bridgeConfiguration.setForwardingAddress(TARGET_QUEUE);
        bridgeConfiguration.setRetryInterval(100L);
        bridgeConfiguration.setConfirmationWindowSize(1);
        bridgeConfiguration.setReconnectAttempts(-1);
        bridgeConfiguration.setReconnectAttemptsOnSameNode(retriesSameNode);
        bridgeConfiguration.setHA(true);
        this.servers[2].getConfiguration().getBridgeConfigurations().add(bridgeConfiguration);
        for (ActiveMQServer server : this.servers) {
            server.getConfiguration().addQueueConfiguration(new QueueConfiguration(ORIGINAL_QUEUE));
            server.getConfiguration().addQueueConfiguration(new QueueConfiguration(TARGET_QUEUE));
        }
        this.startServers();
        BridgeImpl bridge = (BridgeImpl)this.servers[2].getClusterManager().getBridges().get("Bridge-for-test");
        BridgeFailoverTest.assertNotNull((Object)bridge);
        long timeout = System.currentTimeMillis() + 5000L;
        while (bridge.getTargetNodeFromTopology() == null && timeout > System.currentTimeMillis()) {
            Thread.sleep(100L);
        }
        BridgeFailoverTest.assertNotNull((Object)bridge.getTargetNodeFromTopology());
        ServerLocator locatorProducer = this.createLocator(false, 2);
        ClientSessionFactory factory = this.addSessionFactory(locatorProducer.createSessionFactory());
        ClientSession session = this.addClientSession(factory.createSession(false, false));
        ClientProducer producer = this.addClientProducer(session.createProducer(ORIGINAL_QUEUE));
        for (int i2 = 0; i2 < 100; ++i2) {
            ClientMessage msg = session.createMessage(true);
            msg.putIntProperty("i", i2);
            producer.send((Message)msg);
        }
        session.commit();
        ServerLocator locatorConsumer = this.createLocator(false, 4);
        ClientSessionFactory factoryConsumer = this.addSessionFactory(locatorConsumer.createSessionFactory());
        ClientSession sessionConsumer = this.addClientSession(factoryConsumer.createSession(false, false));
        ClientConsumer consumer = sessionConsumer.createConsumer(TARGET_QUEUE);
        sessionConsumer.start();
        for (i = 0; i < 100; ++i) {
            message = consumer.receive(10000L);
            BridgeFailoverTest.assertNotNull((Object)message);
            message.acknowledge();
        }
        sessionConsumer.rollback();
        factoryConsumer.close();
        sessionConsumer.close();
        BridgeFailoverTest.crashAndWaitForFailure((ActiveMQServer)this.servers[4], (ServerLocator)locatorConsumer);
        locatorConsumer.close();
        BridgeFailoverTest.assertTrue((String)"Backup server didn't activate.", (boolean)this.backupServers[4].waitForActivation(5L, TimeUnit.SECONDS));
        for (i = 100; i < 200; ++i) {
            ClientMessage msg = session.createMessage(true);
            msg.putIntProperty("i", i);
            producer.send((Message)msg);
        }
        session.commit();
        locatorConsumer = this.createLocator(false, 9);
        factoryConsumer = this.addSessionFactory(locatorConsumer.createSessionFactory());
        sessionConsumer = this.addClientSession(factoryConsumer.createSession());
        consumer = sessionConsumer.createConsumer(TARGET_QUEUE);
        sessionConsumer.start();
        for (i = 0; i < 200; ++i) {
            message = consumer.receive(10000L);
            BridgeFailoverTest.assertNotNull((Object)message);
            message.acknowledge();
        }
        sessionConsumer.commit();
    }

    @Test
    public void testInitialConnectionNodeAlreadyDown() throws Exception {
        BridgeConfiguration bridgeConfiguration = new BridgeConfiguration();
        String ORIGINAL_QUEUE = "noCluster.originalQueue";
        String TARGET_QUEUE = "noCluster.targetQueue";
        bridgeConfiguration.setHA(true);
        ArrayList<String> connectors = new ArrayList<String>();
        connectors.add("target-4");
        connectors.add("backup-4");
        bridgeConfiguration.setName("Bridge-for-test");
        bridgeConfiguration.setStaticConnectors(connectors);
        bridgeConfiguration.setQueueName(ORIGINAL_QUEUE);
        bridgeConfiguration.setForwardingAddress(TARGET_QUEUE);
        bridgeConfiguration.setRetryInterval(100L);
        bridgeConfiguration.setConfirmationWindowSize(1);
        bridgeConfiguration.setReconnectAttempts(-1);
        this.servers[2].getConfiguration().getBridgeConfigurations().add(bridgeConfiguration);
        for (ActiveMQServer server : this.servers) {
            server.getConfiguration().addQueueConfiguration(new QueueConfiguration(ORIGINAL_QUEUE));
            server.getConfiguration().addQueueConfiguration(new QueueConfiguration(TARGET_QUEUE));
        }
        this.startBackups(0, 1, 3, 4);
        this.startServers(0, 1, 3, 4);
        BridgeFailoverTest.waitForTopology((ActiveMQServer)this.servers[4], (int)(this.getNumberOfServers() - 1), (int)(this.getNumberOfServers() - 1));
        BridgeFailoverTest.crashAndWaitForFailure((ActiveMQServer)this.servers[4], (ServerLocator)this.createLocator(false, 4));
        this.waitForServerToStart(this.backupServers[4]);
        this.startBackups(2);
        this.startServers(2);
        ServerLocator locator = this.createLocator(false, 2);
        ClientSessionFactory factory = this.addSessionFactory(locator.createSessionFactory());
        ClientSession session = this.addClientSession(factory.createSession(false, false));
        ClientProducer producer = this.addClientProducer(session.createProducer(ORIGINAL_QUEUE));
        for (int i = 0; i < 100; ++i) {
            ClientMessage msg = session.createMessage(true);
            msg.putIntProperty("i", i);
            producer.send((Message)msg);
        }
        session.commit();
        ServerLocator locatorConsumer = this.createLocator(false, 9);
        ClientSessionFactory factoryConsumer = this.addSessionFactory(locatorConsumer.createSessionFactory());
        ClientSession sessionConsumer = this.addClientSession(factoryConsumer.createSession(false, false));
        ClientConsumer consumer = sessionConsumer.createConsumer(TARGET_QUEUE);
        sessionConsumer.start();
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = consumer.receive(10000L);
            BridgeFailoverTest.assertNotNull((Object)message);
            message.acknowledge();
        }
        sessionConsumer.commit();
    }
}

