/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.stomp.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.tests.integration.stomp.util.ClientStompFrame;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnection;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnectionFactory;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompFrameFactory;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompFrameFactoryFactory;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.collections.ConcurrentHashSet;
import org.apache.activemq.transport.netty.NettyTransport;
import org.apache.activemq.transport.netty.NettyTransportFactory;
import org.apache.activemq.transport.netty.NettyTransportListener;

public abstract class AbstractStompClientConnection
implements StompClientConnection {
    protected Pinger pinger;
    protected String version;
    protected String host;
    protected int port;
    protected String username;
    protected String passcode;
    protected StompFrameFactory factory;
    protected NettyTransport transport;
    protected ByteBuffer readBuffer;
    protected List<Byte> receiveList;
    protected BlockingQueue<ClientStompFrame> frameQueue = new LinkedBlockingQueue<ClientStompFrame>();
    protected boolean connected = false;
    protected int serverPingCounter;
    protected String scheme;
    private static final ConcurrentHashSet<StompClientConnection> connections = new ConcurrentHashSet();

    public static final void tearDownConnections() {
        for (StompClientConnection connection : connections) {
            try {
                connection.closeTransport();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        connections.clear();
    }

    @Deprecated
    public AbstractStompClientConnection(String version, String host, int port) throws IOException {
        this.version = version;
        this.host = host;
        this.port = port;
        this.scheme = "tcp";
        this.factory = StompFrameFactoryFactory.getFactory(version);
        connections.add((Object)this);
    }

    public AbstractStompClientConnection(URI uri) throws Exception {
        this.parseURI(uri);
        this.factory = StompFrameFactoryFactory.getFactory(this.version);
        this.readBuffer = ByteBuffer.allocateDirect(10240);
        this.receiveList = new ArrayList<Byte>(10240);
        this.transport = NettyTransportFactory.createTransport((URI)uri);
        this.transport.setTransportListener((NettyTransportListener)new StompTransportListener());
        this.transport.connect();
        Wait.waitFor(() -> this.transport.isConnected(), (long)1000L);
        if (!this.transport.isConnected()) {
            throw new RuntimeException("Could not connect transport");
        }
        connections.add((Object)this);
    }

    public AbstractStompClientConnection(URI uri, boolean autoConnect) throws Exception {
        this.parseURI(uri);
        this.factory = StompFrameFactoryFactory.getFactory(this.version);
        this.readBuffer = ByteBuffer.allocateDirect(10240);
        this.receiveList = new ArrayList<Byte>(10240);
        this.transport = NettyTransportFactory.createTransport((URI)uri);
        this.transport.setTransportListener((NettyTransportListener)new StompTransportListener());
        if (autoConnect) {
            this.transport.connect();
            Wait.waitFor(() -> this.transport.isConnected(), (long)1000L);
            if (!this.transport.isConnected()) {
                throw new RuntimeException("Could not connect transport");
            }
        }
        connections.add((Object)this);
    }

    private void parseURI(URI uri) {
        this.scheme = uri.getScheme() == null ? "tcp" : uri.getScheme();
        this.host = uri.getHost();
        this.port = uri.getPort();
        this.version = StompClientConnectionFactory.getStompVersionFromURI(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientStompFrame sendFrameInternal(ClientStompFrame frame, boolean wicked) throws IOException, InterruptedException {
        ClientStompFrame response = null;
        ByteBuffer buffer = wicked ? frame.toByteBufferWithExtra("\n") : frame.toByteBuffer();
        ByteBuf buf = Unpooled.copiedBuffer((ByteBuffer)buffer);
        try {
            buf.retain();
            ChannelFuture future = this.transport.send(buf);
            if (future != null) {
                future.awaitUninterruptibly();
            }
        }
        finally {
            buf.release();
        }
        if (frame.needsReply()) {
            response = this.receiveFrame();
            while (response != null && response.getCommand().equals("STOMP")) {
                response = this.receiveFrame();
            }
        }
        return response;
    }

    @Override
    public ClientStompFrame sendFrame(ClientStompFrame frame) throws IOException, InterruptedException {
        return this.sendFrameInternal(frame, false);
    }

    @Override
    public ClientStompFrame sendWickedFrame(ClientStompFrame frame) throws IOException, InterruptedException {
        return this.sendFrameInternal(frame, true);
    }

    @Override
    public ClientStompFrame receiveFrame() throws InterruptedException {
        return this.frameQueue.poll(10L, TimeUnit.SECONDS);
    }

    @Override
    public ClientStompFrame receiveFrame(long timeout) throws InterruptedException {
        return this.frameQueue.poll(timeout, TimeUnit.MILLISECONDS);
    }

    private void receiveBytes(int n) {
        this.readBuffer.rewind();
        for (int i = 0; i < n; ++i) {
            byte b = this.readBuffer.get();
            if (b == 0) {
                int sz = this.receiveList.size();
                if (sz <= 0) continue;
                byte[] frameBytes = new byte[sz];
                for (int j = 0; j < sz; ++j) {
                    frameBytes[j] = this.receiveList.get(j);
                }
                ClientStompFrame frame = this.factory.createFrame(new String(frameBytes, StandardCharsets.UTF_8));
                if (this.validateFrame(frame)) {
                    this.frameQueue.offer(frame);
                    this.receiveList.clear();
                    continue;
                }
                this.receiveList.add(b);
                continue;
            }
            if (b == 10 && this.receiveList.size() == 0) {
                this.incrementServerPing();
                continue;
            }
            this.receiveList.add(b);
        }
        this.readBuffer.rewind();
    }

    protected void incrementServerPing() {
        ++this.serverPingCounter;
    }

    private boolean validateFrame(ClientStompFrame f) {
        String h = f.getHeader("content-length");
        if (h != null) {
            int len = Integer.valueOf(h);
            if (f.getBody().getBytes(StandardCharsets.UTF_8).length < len) {
                return false;
            }
        }
        return true;
    }

    protected void close() throws IOException {
        this.transport.close();
    }

    @Override
    public ClientStompFrame connect() throws Exception {
        return this.connect(null, null);
    }

    @Override
    public void destroy() {
        try {
            this.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.connected = false;
        }
    }

    @Override
    public ClientStompFrame connect(String username, String password) throws Exception {
        throw new RuntimeException("connect method not implemented!");
    }

    @Override
    public boolean isConnected() {
        return this.connected && this.transport.isConnected();
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public int getFrameQueueSize() {
        return this.frameQueue.size();
    }

    @Override
    public void closeTransport() throws IOException {
        this.transport.close();
    }

    @Override
    public NettyTransport getTransport() {
        return this.transport;
    }

    protected class Pinger
    extends Thread {
        long pingInterval;
        ClientStompFrame pingFrame;
        volatile boolean stop = false;

        Pinger(long interval) {
            this.pingInterval = interval;
            this.pingFrame = AbstractStompClientConnection.this.createFrame("STOMP");
            this.pingFrame.setBody("\n");
            this.pingFrame.setForceOneway();
            this.pingFrame.setPing(true);
        }

        public void startPing() {
            this.start();
        }

        public synchronized void stopPing() {
            this.stop = true;
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Pinger pinger = this;
            synchronized (pinger) {
                while (!this.stop) {
                    try {
                        AbstractStompClientConnection.this.sendFrame(this.pingFrame);
                        this.wait(this.pingInterval);
                    }
                    catch (Exception e) {
                        this.stop = true;
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private class StompTransportListener
    implements NettyTransportListener {
        private StompTransportListener() {
        }

        public void onData(ByteBuf incoming) {
            while (incoming.readableBytes() > 0) {
                int bytes = incoming.readableBytes();
                if (incoming.readableBytes() < AbstractStompClientConnection.this.readBuffer.remaining()) {
                    ByteBuffer byteBuffer = ByteBuffer.allocate(incoming.readableBytes());
                    incoming.readBytes(byteBuffer);
                    byteBuffer.rewind();
                    AbstractStompClientConnection.this.readBuffer.put(byteBuffer);
                    AbstractStompClientConnection.this.receiveBytes(bytes);
                    continue;
                }
                incoming.readBytes(AbstractStompClientConnection.this.readBuffer);
                AbstractStompClientConnection.this.receiveBytes(bytes - incoming.readableBytes());
            }
        }

        public void onTransportClosed() {
        }

        public void onTransportError(Throwable cause) {
            throw new RuntimeException(cause);
        }
    }
}

