/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.entity;

import java.io.ByteArrayInputStream;
import java.security.SecureRandom;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import javax.security.auth.x500.X500Principal;
import org.wildfly.security.asn1.ASN1Exception;
import org.wildfly.security.asn1.DERDecoder;
import org.wildfly.security.asn1.DEREncoder;
import org.wildfly.security.mechanism._private.ElytronMessages;
import org.wildfly.security.sasl.entity.Entity;
import org.wildfly.security.x500.GeneralName;
import org.wildfly.security.x500.TrustedAuthority;
import org.wildfly.security.x500.util.X500PrincipalUtil;

class EntityUtil {
    private static final byte[] randomCharDictionary;

    EntityUtil() {
    }

    public static void encodeX509CertificateChain(DEREncoder encoder, X509Certificate[] certChain) throws ASN1Exception {
        try {
            int chainSize = certChain.length;
            encoder.startSetOf();
            for (int i = 0; i < chainSize; ++i) {
                encoder.writeEncoded(certChain[i].getEncoded());
            }
            encoder.endSetOf();
        }
        catch (CertificateEncodingException e) {
            throw new ASN1Exception(e);
        }
    }

    public static void encodeAlgorithmIdentifier(DEREncoder encoder, String objectIdentifier, boolean omitParametersField) throws ASN1Exception {
        encoder.startSequence();
        encoder.encodeObjectIdentifier(objectIdentifier);
        if (!omitParametersField) {
            encoder.encodeNull();
        }
        encoder.endSequence();
    }

    public static void encodeAlgorithmIdentifier(DEREncoder encoder, String algorithm) throws ASN1Exception {
        boolean omitParametersField;
        switch (algorithm) {
            case "SHA1withRSA": {
                omitParametersField = false;
                break;
            }
            case "SHA1withDSA": 
            case "SHA1withECDSA": {
                omitParametersField = true;
                break;
            }
            default: {
                throw ElytronMessages.saslEntity.asnUnrecognisedAlgorithm(algorithm);
            }
        }
        EntityUtil.encodeAlgorithmIdentifier(encoder, Entity.algorithmOid(algorithm), omitParametersField);
    }

    public static void encodeGeneralNames(DEREncoder encoder, List<GeneralName> generalNames) throws ASN1Exception {
        encoder.startSequence();
        for (GeneralName generalName : generalNames) {
            generalName.encodeTo(encoder);
        }
        encoder.endSequence();
    }

    public static void encodeGeneralNames(DEREncoder encoder, GeneralName generalName) throws ASN1Exception {
        ArrayList<GeneralName> generalNames = new ArrayList<GeneralName>(1);
        generalNames.add(generalName);
        EntityUtil.encodeGeneralNames(encoder, generalNames);
    }

    public static void encodeGeneralNames(DEREncoder encoder, String subjectName, Collection<List<?>> subjectAltNames) throws ASN1Exception {
        encoder.startSequence();
        if (!subjectName.isEmpty()) {
            new GeneralName.DirectoryName(subjectName).encodeTo(encoder);
        }
        if (subjectAltNames != null) {
            for (List<?> altName : subjectAltNames) {
                EntityUtil.convertToGeneralName(altName).encodeTo(encoder);
            }
        }
        encoder.endSequence();
    }

    public static byte[] encodeRandomNumber(DEREncoder encoder, SecureRandom secureRandom) {
        Random random = secureRandom != null ? secureRandom : ThreadLocalRandom.current();
        byte[] randomA = EntityUtil.generateRandomString(48, random);
        encoder.encodeOctetString(randomA);
        return randomA;
    }

    public static byte[] generateRandomString(int length, Random random) {
        byte[] chars = new byte[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = randomCharDictionary[random.nextInt(93)];
        }
        return chars;
    }

    public static void encodeTrustedAuthorities(DEREncoder encoder, List<TrustedAuthority> trustedAuthorities) throws ASN1Exception {
        encoder.startSequence();
        for (TrustedAuthority trustedAuthority : trustedAuthorities) {
            trustedAuthority.encodeTo(encoder);
        }
        encoder.endSequence();
    }

    public static List<GeneralName> decodeGeneralNames(DERDecoder decoder) throws ASN1Exception {
        ArrayList<GeneralName> generalNames = new ArrayList<GeneralName>();
        GeneralName generalName = null;
        decoder.startSequence();
        while (decoder.hasNextElement()) {
            block12: for (int generalNameType = 0; generalNameType <= 8; ++generalNameType) {
                switch (generalNameType) {
                    case 0: {
                        if (!decoder.isNextType(128, generalNameType, true)) continue block12;
                        decoder.decodeImplicit(generalNameType);
                        decoder.startSequence();
                        String typeId = decoder.decodeObjectIdentifier();
                        byte[] encodedValue = decoder.drainElement();
                        decoder.endSequence();
                        generalName = new GeneralName.OtherName(typeId, encodedValue);
                        break block12;
                    }
                    case 1: {
                        if (!decoder.isNextType(128, generalNameType, false)) continue block12;
                        decoder.decodeImplicit(generalNameType);
                        generalName = new GeneralName.RFC822Name(decoder.decodeIA5String());
                        break block12;
                    }
                    case 2: {
                        if (!decoder.isNextType(128, generalNameType, false)) continue block12;
                        decoder.decodeImplicit(generalNameType);
                        generalName = new GeneralName.DNSName(decoder.decodeIA5String());
                        break block12;
                    }
                    case 3: {
                        if (!decoder.isNextType(128, generalNameType, true)) continue block12;
                        decoder.decodeImplicit(generalNameType);
                        generalName = new GeneralName.X400Address(decoder.drainElementValue(), true);
                        break block12;
                    }
                    case 4: {
                        if (!decoder.isNextType(128, generalNameType, true)) continue block12;
                        byte[] encodedName = decoder.drainElementValue();
                        generalName = new GeneralName.DirectoryName(new X500Principal(encodedName).getName("CANONICAL"));
                        break block12;
                    }
                    case 5: {
                        if (!decoder.isNextType(128, generalNameType, true)) continue block12;
                        decoder.decodeImplicit(generalNameType);
                        generalName = new GeneralName.EDIPartyName(decoder.drainElementValue(), true);
                        break block12;
                    }
                    case 6: {
                        if (!decoder.isNextType(128, generalNameType, false)) continue block12;
                        decoder.decodeImplicit(generalNameType);
                        generalName = new GeneralName.URIName(decoder.decodeIA5String());
                        break block12;
                    }
                    case 7: {
                        if (!decoder.isNextType(128, generalNameType, false)) continue block12;
                        decoder.decodeImplicit(generalNameType);
                        generalName = new GeneralName.IPAddress(decoder.decodeOctetString());
                        break block12;
                    }
                    case 8: {
                        if (!decoder.isNextType(128, generalNameType, false)) continue block12;
                        decoder.decodeImplicit(generalNameType);
                        generalName = new GeneralName.RegisteredID(decoder.decodeObjectIdentifier());
                        break block12;
                    }
                    default: {
                        throw ElytronMessages.saslEntity.asnInvalidGeneralNameType();
                    }
                }
            }
            generalNames.add(generalName);
        }
        decoder.endSequence();
        return generalNames;
    }

    public static X509Certificate[] decodeX509CertificateChain(DERDecoder decoder) throws ASN1Exception {
        if (decoder.peekType() != 49) {
            throw ElytronMessages.saslEntity.asnUnexpectedTag();
        }
        byte[] certChain = decoder.drainElement();
        try {
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            certChain[0] = 48;
            CertPath certPath = certFactory.generateCertPath(new ByteArrayInputStream(certChain));
            List<? extends Certificate> certs = certPath.getCertificates();
            return certs.toArray(new X509Certificate[certs.size()]);
        }
        catch (CertificateException e) {
            throw new ASN1Exception(e);
        }
    }

    public static X509Certificate[] decodeCertificateData(DERDecoder decoder) throws ASN1Exception {
        if (decoder.peekType() != 49) {
            throw ElytronMessages.saslEntity.asnUnexpectedTag();
        }
        X509Certificate[] peerCertChain = EntityUtil.decodeX509CertificateChain(decoder);
        return peerCertChain;
    }

    public static List<TrustedAuthority> decodeTrustedAuthorities(DERDecoder decoder) throws ASN1Exception {
        ArrayList<TrustedAuthority> trustedAuthorities = new ArrayList<TrustedAuthority>();
        TrustedAuthority trustedAuthority = null;
        decoder.startSequence();
        while (decoder.hasNextElement()) {
            block10: for (int trustedAuthorityType = 0; trustedAuthorityType <= 4; ++trustedAuthorityType) {
                switch (trustedAuthorityType) {
                    case 0: {
                        if (!decoder.isNextType(128, trustedAuthorityType, true)) continue block10;
                        byte[] encodedName = decoder.drainElementValue();
                        trustedAuthority = new TrustedAuthority.NameTrustedAuthority(new X500Principal(encodedName).getName("CANONICAL"));
                        break block10;
                    }
                    case 3: {
                        if (!decoder.isNextType(128, trustedAuthorityType, true)) continue block10;
                        decoder.decodeImplicit(trustedAuthorityType);
                        byte[] cert = decoder.drainElement();
                        cert[0] = 48;
                        try {
                            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                            trustedAuthority = new TrustedAuthority.CertificateTrustedAuthority((X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(cert)));
                            break block10;
                        }
                        catch (CertificateException e) {
                            throw new ASN1Exception(e);
                        }
                    }
                    case 1: {
                        if (!decoder.isNextType(128, trustedAuthorityType, false)) continue block10;
                        decoder.decodeImplicit(trustedAuthorityType);
                        trustedAuthority = new TrustedAuthority.IssuerNameHashTrustedAuthority(decoder.decodeOctetString());
                        break block10;
                    }
                    case 2: {
                        if (!decoder.isNextType(128, trustedAuthorityType, false)) continue block10;
                        decoder.decodeImplicit(trustedAuthorityType);
                        trustedAuthority = new TrustedAuthority.IssuerKeyHashTrustedAuthority(decoder.decodeOctetString());
                        break block10;
                    }
                    case 4: {
                        if (!decoder.isNextType(128, trustedAuthorityType, false)) continue block10;
                        decoder.decodeImplicit(trustedAuthorityType);
                        trustedAuthority = new TrustedAuthority.PKCS15KeyHashTrustedAuthority(decoder.decodeOctetString());
                        break block10;
                    }
                    default: {
                        throw ElytronMessages.saslEntity.asnInvalidGeneralNameType();
                    }
                }
            }
            trustedAuthorities.add(trustedAuthority);
        }
        decoder.endSequence();
        return trustedAuthorities;
    }

    public static boolean matchGeneralNames(List<GeneralName> generalNames, List<GeneralName> actualGeneralNames) {
        if (generalNames == null || actualGeneralNames == null) {
            return false;
        }
        for (GeneralName generalName : generalNames) {
            for (GeneralName actualGeneralName : actualGeneralNames) {
                if (!EntityUtil.matchGeneralName(generalName, actualGeneralName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean matchGeneralName(GeneralName generalName, GeneralName actualGeneralName) {
        if (generalName instanceof GeneralName.DNSName && actualGeneralName instanceof GeneralName.DirectoryName) {
            String[] cnValues = X500PrincipalUtil.getAttributeValues(new X500Principal(((GeneralName.DirectoryName)actualGeneralName).getName()), "2.5.4.3");
            String dnsName = ((GeneralName.DNSName)generalName).getName();
            return dnsName.equalsIgnoreCase(cnValues[0]);
        }
        return generalName.equals(actualGeneralName);
    }

    public static boolean matchGeneralNames(List<GeneralName> generalNames, X509Certificate cert) {
        X500Principal certSubjectName;
        block5: {
            certSubjectName = cert.getSubjectX500Principal();
            try {
                if (EntityUtil.matchGeneralNames(generalNames, EntityUtil.convertToGeneralNames(cert.getSubjectAlternativeNames()))) {
                    return true;
                }
            }
            catch (CertificateParsingException e) {
                if (certSubjectName != null) break block5;
                throw ElytronMessages.saslEntity.unableToDetermineSubjectName(e);
            }
        }
        if (certSubjectName != null) {
            ArrayList<GeneralName> certNames = new ArrayList<GeneralName>(1);
            certNames.add(new GeneralName.DirectoryName(certSubjectName.getName("CANONICAL")));
            if (EntityUtil.matchGeneralNames(generalNames, certNames)) {
                return true;
            }
        }
        return false;
    }

    public static String getDistinguishedNameFromGeneralNames(List<GeneralName> generalNames) {
        for (GeneralName generalName : generalNames) {
            if (!(generalName instanceof GeneralName.DirectoryName)) continue;
            return ((GeneralName.DirectoryName)generalName).getName();
        }
        return null;
    }

    private static GeneralName convertToGeneralName(List<?> generalName) throws ASN1Exception {
        int type = (Integer)generalName.get(0);
        Object name = generalName.get(1);
        switch (type) {
            case 0: {
                return new GeneralName.OtherName((byte[])name);
            }
            case 1: {
                return new GeneralName.RFC822Name((String)name);
            }
            case 2: {
                return new GeneralName.DNSName((String)name);
            }
            case 3: {
                return new GeneralName.X400Address((byte[])name);
            }
            case 4: {
                return new GeneralName.DirectoryName((String)name);
            }
            case 5: {
                return new GeneralName.EDIPartyName((byte[])name);
            }
            case 6: {
                return new GeneralName.URIName((String)name);
            }
            case 7: {
                return new GeneralName.IPAddress((String)name);
            }
            case 8: {
                return new GeneralName.RegisteredID((String)name);
            }
        }
        throw ElytronMessages.saslEntity.asnInvalidGeneralNameType();
    }

    private static List<GeneralName> convertToGeneralNames(Collection<List<?>> generalNames) throws ASN1Exception {
        if (generalNames == null) {
            return null;
        }
        ArrayList<GeneralName> convertedGeneralNames = new ArrayList<GeneralName>();
        for (List<?> generalName : generalNames) {
            convertedGeneralNames.add(EntityUtil.convertToGeneralName(generalName));
        }
        return convertedGeneralNames;
    }

    static {
        int c;
        byte[] dict = new byte[93];
        int i = 0;
        for (c = 33; c < 44; c = (int)((byte)(c + 1))) {
            dict[i++] = c;
        }
        for (c = 45; c < 127; c = (int)((byte)(c + 1))) {
            dict[i++] = c;
        }
        assert (i == dict.length);
        randomCharDictionary = dict;
    }
}

