/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.jboss.as.clustering.controller.DeploymentChainContributingResourceRegistration;
import org.jboss.as.clustering.controller.ManagementResourceRegistration;
import org.jboss.as.clustering.controller.RequirementCapability;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.SubsystemRegistration;
import org.jboss.as.clustering.controller.SubsystemResourceDefinition;
import org.jboss.as.clustering.controller.UnaryCapabilityNameResolver;
import org.jboss.as.clustering.controller.UnaryRequirementCapability;
import org.jboss.as.clustering.infinispan.deployment.ClusteringDependencyProcessor;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanExtension;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemServiceHandler;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteCacheContainerResourceDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.wildfly.clustering.server.service.ClusteringRequirement;
import org.wildfly.clustering.service.UnaryRequirement;

public class InfinispanSubsystemResourceDefinition
extends SubsystemResourceDefinition<SubsystemRegistration>
implements Consumer<DeploymentProcessorTarget> {
    static final PathElement PATH = InfinispanSubsystemResourceDefinition.pathElement((String)"infinispan");

    InfinispanSubsystemResourceDefinition() {
        super(PATH, (ResourceDescriptionResolver)InfinispanExtension.SUBSYSTEM_RESOLVER);
    }

    public void register(SubsystemRegistration parentRegistration) {
        ManagementResourceRegistration registration = parentRegistration.registerSubsystemModel((ResourceDefinition)this);
        registration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
        EnumSet<ClusteringRequirement> requirements = EnumSet.allOf(ClusteringRequirement.class);
        ArrayList<RequirementCapability> capabilities = new ArrayList<RequirementCapability>(requirements.size());
        ArrayList<UnaryRequirementCapability> localCapabilities = new ArrayList<UnaryRequirementCapability>(requirements.size());
        UnaryOperator configurator = builder -> builder.setAllowMultipleRegistrations(true);
        for (ClusteringRequirement requirement : requirements) {
            capabilities.add(new RequirementCapability(requirement.getDefaultRequirement(), configurator));
            localCapabilities.add(new UnaryRequirementCapability((UnaryRequirement)requirement, UnaryCapabilityNameResolver.LOCAL));
        }
        ResourceDescriptor descriptor = new ResourceDescriptor(this.getResourceDescriptionResolver()).addCapabilities(capabilities).addCapabilities(localCapabilities);
        InfinispanSubsystemServiceHandler handler = new InfinispanSubsystemServiceHandler();
        new DeploymentChainContributingResourceRegistration(descriptor, (ResourceServiceHandler)handler, (Consumer)this).register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        new CacheContainerResourceDefinition().register(registration);
        new RemoteCacheContainerResourceDefinition().register(registration);
    }

    @Override
    public void accept(DeploymentProcessorTarget target) {
        target.addDeploymentProcessor("infinispan", Phase.DEPENDENCIES, 7168, (DeploymentUnitProcessor)new ClusteringDependencyProcessor());
    }
}

