/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.enhanced;

import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Supplier;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.QualifiedName;
import org.hibernate.boot.model.relational.QualifiedNameParser;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.BulkInsertionCapableIdentifierGenerator;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.id.SequenceMismatchStrategy;
import org.hibernate.id.enhanced.DatabaseStructure;
import org.hibernate.id.enhanced.ImplicitDatabaseObjectNamingStrategy;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.id.enhanced.OptimizerFactory;
import org.hibernate.id.enhanced.SequenceStructure;
import org.hibernate.id.enhanced.StandardNamingStrategy;
import org.hibernate.id.enhanced.StandardOptimizerDescriptor;
import org.hibernate.id.enhanced.TableStructure;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.log.IncubationLogger;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.schema.extract.spi.SequenceInformation;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class SequenceStyleGenerator
implements PersistentIdentifierGenerator,
BulkInsertionCapableIdentifierGenerator {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)SequenceStyleGenerator.class.getName());
    public static final String SEQUENCE_PARAM = "sequence_name";
    public static final String ALT_SEQUENCE_PARAM = "sequence";
    public static final String CONFIG_SEQUENCE_PER_ENTITY_SUFFIX = "sequence_per_entity_suffix";
    public static final String DEF_SEQUENCE_SUFFIX = "_SEQ";
    public static final String FORCE_TBL_PARAM = "force_table_use";
    public static final String VALUE_COLUMN_PARAM = "value_column";
    public static final String DEF_VALUE_COLUMN = "next_val";
    private DatabaseStructure databaseStructure;
    private Optimizer optimizer;
    private Type identifierType;

    public DatabaseStructure getDatabaseStructure() {
        return this.databaseStructure;
    }

    @Override
    public Optimizer getOptimizer() {
        return this.optimizer;
    }

    public Type getIdentifierType() {
        return this.identifierType;
    }

    @Override
    public void configure(Type type, Properties params, ServiceRegistry serviceRegistry) throws MappingException {
        String databaseSequenceName;
        Number databaseIncrementValue;
        JdbcEnvironment jdbcEnvironment = serviceRegistry.getService(JdbcEnvironment.class);
        ConfigurationService configurationService = serviceRegistry.getService(ConfigurationService.class);
        Dialect dialect = jdbcEnvironment.getDialect();
        this.identifierType = type;
        boolean forceTableUse = ConfigurationHelper.getBoolean(FORCE_TBL_PARAM, params, false);
        QualifiedName sequenceName = this.determineSequenceName(params, dialect, jdbcEnvironment, serviceRegistry);
        int initialValue = this.determineInitialValue(params);
        int incrementSize = this.determineIncrementSize(params);
        String optimizationStrategy = this.determineOptimizationStrategy(params, incrementSize);
        boolean isPooledOptimizer = OptimizerFactory.isPooledOptimizer(optimizationStrategy);
        SequenceMismatchStrategy sequenceMismatchStrategy = configurationService.getSetting("hibernate.id.sequence.increment_size_mismatch_strategy", SequenceMismatchStrategy::interpret, SequenceMismatchStrategy.EXCEPTION);
        if (sequenceMismatchStrategy != SequenceMismatchStrategy.NONE && isPooledOptimizer && this.isPhysicalSequence(jdbcEnvironment, forceTableUse) && (databaseIncrementValue = this.getSequenceIncrementValue(jdbcEnvironment, databaseSequenceName = sequenceName.getObjectName().getText())) != null && databaseIncrementValue.intValue() != incrementSize) {
            int dbIncrementValue = databaseIncrementValue.intValue();
            switch (sequenceMismatchStrategy) {
                case EXCEPTION: {
                    throw new MappingException(String.format("The increment size of the [%s] sequence is set to [%d] in the entity mapping while the associated database sequence increment size is [%d].", databaseSequenceName, incrementSize, dbIncrementValue));
                }
                case FIX: {
                    incrementSize = dbIncrementValue;
                }
                case LOG: {
                    LOG.sequenceIncrementSizeMismatch(databaseSequenceName, incrementSize, dbIncrementValue);
                }
            }
        }
        incrementSize = this.determineAdjustedIncrementSize(optimizationStrategy, incrementSize);
        if (dialect.getSequenceSupport().supportsSequences() && !forceTableUse && !dialect.getSequenceSupport().supportsPooledSequences() && OptimizerFactory.isPooledOptimizer(optimizationStrategy)) {
            forceTableUse = true;
            LOG.forcingTableUse();
        }
        this.databaseStructure = this.buildDatabaseStructure(type, params, jdbcEnvironment, forceTableUse, sequenceName, initialValue, incrementSize);
        this.optimizer = OptimizerFactory.buildOptimizer(optimizationStrategy, this.identifierType.getReturnedClass(), incrementSize, ConfigurationHelper.getInt("initial_value", params, -1));
        this.databaseStructure.configure(this.optimizer);
    }

    @Override
    public void registerExportables(Database database) {
        this.databaseStructure.registerExportables(database);
    }

    @Override
    public void initialize(SqlStringGenerationContext context) {
        this.databaseStructure.initialize(context);
    }

    protected QualifiedName determineSequenceName(Properties params, Dialect dialect, JdbcEnvironment jdbcEnv, ServiceRegistry serviceRegistry) {
        Identifier catalog = jdbcEnv.getIdentifierHelper().toIdentifier(ConfigurationHelper.getString("catalog", params));
        Identifier schema = jdbcEnv.getIdentifierHelper().toIdentifier(ConfigurationHelper.getString("schema", params));
        String sequenceName = ConfigurationHelper.getString(SEQUENCE_PARAM, params, () -> ConfigurationHelper.getString(ALT_SEQUENCE_PARAM, params));
        if (StringHelper.isNotEmpty(sequenceName)) {
            if (sequenceName.contains(".")) {
                return QualifiedNameParser.INSTANCE.parse(sequenceName);
            }
            return new QualifiedNameParser.NameParts(catalog, schema, jdbcEnv.getIdentifierHelper().toIdentifier(sequenceName));
        }
        return this.determineImplicitName(catalog, schema, params, serviceRegistry);
    }

    private QualifiedName determineImplicitName(Identifier catalog, Identifier schema, Properties params, ServiceRegistry serviceRegistry) {
        StrategySelector strategySelector = serviceRegistry.getService(StrategySelector.class);
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = () -> {
            String localSetting = ConfigurationHelper.getString("hibernate.id.db_structure_naming_strategy", params);
            if (localSetting != null) {
                IncubationLogger.INCUBATION_LOGGER.incubatingSetting("hibernate.id.db_structure_naming_strategy");
            }
            return localSetting;
        };
        supplierArray[1] = () -> {
            ConfigurationService configurationService = serviceRegistry.getService(ConfigurationService.class);
            String globalSetting = ConfigurationHelper.getString("hibernate.id.db_structure_naming_strategy", configurationService.getSettings());
            if (globalSetting != null) {
                IncubationLogger.INCUBATION_LOGGER.incubatingSetting("hibernate.id.db_structure_naming_strategy");
            }
            return globalSetting;
        };
        supplierArray[2] = StandardNamingStrategy.class::getName;
        String namingStrategySetting = (String)NullnessHelper.coalesceSuppliedValues(supplierArray);
        ImplicitDatabaseObjectNamingStrategy namingStrategy = strategySelector.resolveStrategy(ImplicitDatabaseObjectNamingStrategy.class, namingStrategySetting);
        return namingStrategy.determineSequenceName(catalog, schema, params, serviceRegistry);
    }

    protected Identifier determineValueColumnName(Properties params, JdbcEnvironment jdbcEnvironment) {
        String name = ConfigurationHelper.getString(VALUE_COLUMN_PARAM, (Map)params, DEF_VALUE_COLUMN);
        return jdbcEnvironment.getIdentifierHelper().toIdentifier(name);
    }

    protected int determineInitialValue(Properties params) {
        return ConfigurationHelper.getInt("initial_value", params, 1);
    }

    protected int determineIncrementSize(Properties params) {
        return ConfigurationHelper.getInt("increment_size", params, 50);
    }

    protected String determineOptimizationStrategy(Properties params, int incrementSize) {
        return ConfigurationHelper.getString("optimizer", (Map)params, OptimizerFactory.determineImplicitOptimizerName(incrementSize, params));
    }

    protected int determineAdjustedIncrementSize(String optimizationStrategy, int incrementSize) {
        int resolvedIncrementSize;
        if (Math.abs(incrementSize) > 1 && StandardOptimizerDescriptor.NONE.getExternalName().equals(optimizationStrategy)) {
            if (incrementSize < -1) {
                resolvedIncrementSize = -1;
                LOG.honoringOptimizerSetting(StandardOptimizerDescriptor.NONE.getExternalName(), "increment_size", incrementSize, "negative", resolvedIncrementSize);
            } else {
                resolvedIncrementSize = 1;
                LOG.honoringOptimizerSetting(StandardOptimizerDescriptor.NONE.getExternalName(), "increment_size", incrementSize, "positive", resolvedIncrementSize);
            }
        } else {
            resolvedIncrementSize = incrementSize;
        }
        return resolvedIncrementSize;
    }

    protected DatabaseStructure buildDatabaseStructure(Type type, Properties params, JdbcEnvironment jdbcEnvironment, boolean forceTableUse, QualifiedName sequenceName, int initialValue, int incrementSize) {
        if (this.isPhysicalSequence(jdbcEnvironment, forceTableUse)) {
            return this.buildSequenceStructure(type, params, jdbcEnvironment, sequenceName, initialValue, incrementSize);
        }
        return this.buildTableStructure(type, params, jdbcEnvironment, sequenceName, initialValue, incrementSize);
    }

    protected boolean isPhysicalSequence(JdbcEnvironment jdbcEnvironment, boolean forceTableUse) {
        return jdbcEnvironment.getDialect().getSequenceSupport().supportsSequences() && !forceTableUse;
    }

    protected DatabaseStructure buildSequenceStructure(Type type, Properties params, JdbcEnvironment jdbcEnvironment, QualifiedName sequenceName, int initialValue, int incrementSize) {
        return new SequenceStructure(jdbcEnvironment, this.determineContributor(params), sequenceName, initialValue, incrementSize, type.getReturnedClass());
    }

    protected DatabaseStructure buildTableStructure(Type type, Properties params, JdbcEnvironment jdbcEnvironment, QualifiedName sequenceName, int initialValue, int incrementSize) {
        Identifier valueColumnName = this.determineValueColumnName(params, jdbcEnvironment);
        String contributor = this.determineContributor(params);
        return new TableStructure(jdbcEnvironment, contributor, sequenceName, valueColumnName, initialValue, incrementSize, type.getReturnedClass());
    }

    private String determineContributor(Properties params) {
        String contributor = params.getProperty("CONTRIBUTOR");
        return contributor == null ? "orm" : contributor;
    }

    @Override
    public Object generate(SharedSessionContractImplementor session, Object object) throws HibernateException {
        return this.optimizer.generate(this.databaseStructure.buildCallback(session));
    }

    @Override
    public boolean supportsBulkInsertionIdentifierGeneration() {
        return this.getDatabaseStructure().isPhysicalSequence();
    }

    @Override
    public String determineBulkInsertionIdentifierGenerationSelectFragment(SqlStringGenerationContext context) {
        return context.getDialect().getSequenceSupport().getSelectSequenceNextValString(context.format(this.getDatabaseStructure().getPhysicalName()));
    }

    private Number getSequenceIncrementValue(JdbcEnvironment jdbcEnvironment, String sequenceName) {
        return jdbcEnvironment.getExtractedDatabaseMetaData().getSequenceInformationList().stream().filter(sequenceInformation -> {
            Identifier catalog = sequenceInformation.getSequenceName().getCatalogName();
            Identifier schema = sequenceInformation.getSequenceName().getSchemaName();
            return !(!sequenceName.equalsIgnoreCase(sequenceInformation.getSequenceName().getSequenceName().getText()) || catalog != null && !catalog.equals(jdbcEnvironment.getCurrentCatalog()) || schema != null && !schema.equals(jdbcEnvironment.getCurrentSchema()));
        }).map(SequenceInformation::getIncrementValue).filter(Objects::nonNull).findFirst().orElse(null);
    }
}

