/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc;

import java.lang.reflect.Type;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.internal.JdbcLiteralFormatterNumericData;
import org.hibernate.type.spi.TypeConfiguration;

public class FloatJdbcType
implements JdbcType {
    public static final FloatJdbcType INSTANCE = new FloatJdbcType();

    @Override
    public int getJdbcTypeCode() {
        return 6;
    }

    @Override
    public String getFriendlyName() {
        return "FLOAT";
    }

    public String toString() {
        return "FloatTypeDescriptor";
    }

    @Override
    public <T> BasicJavaType<T> getJdbcRecommendedJavaTypeMapping(Integer length, Integer scale, TypeConfiguration typeConfiguration) {
        if (length != null && length <= typeConfiguration.getServiceRegistry().getService(JdbcServices.class).getDialect().getFloatPrecision()) {
            return (BasicJavaType)typeConfiguration.getJavaTypeRegistry().getDescriptor((Type)((Object)Float.class));
        }
        return (BasicJavaType)typeConfiguration.getJavaTypeRegistry().getDescriptor((Type)((Object)Double.class));
    }

    @Override
    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaType) {
        return new JdbcLiteralFormatterNumericData<T>(javaType, Float.class);
    }

    @Override
    public Class<?> getPreferredJavaTypeClass(WrapperOptions options) {
        return Float.class;
    }

    @Override
    public <X> ValueBinder<X> getBinder(final JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                st.setFloat(index, javaType.unwrap(value, Float.class, options).floatValue());
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                st.setFloat(name, javaType.unwrap(value, Float.class, options).floatValue());
            }
        };
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(final JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            @Override
            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return javaType.wrap(Float.valueOf(rs.getFloat(paramIndex)), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return javaType.wrap(Float.valueOf(statement.getFloat(index)), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return javaType.wrap(Float.valueOf(statement.getFloat(name)), options);
            }
        };
    }
}

