/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.EnumSet;
import java.util.Set;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.DependencyConfigurator;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ejb3.component.EJBComponentCreateService;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.EJBViewConfiguration;
import org.jboss.as.ejb3.deployment.processors.EjbSuspendInterceptor;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.metadata.ejb.spec.MethodInterfaceType;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.requestcontroller.ControlPoint;
import org.wildfly.extension.requestcontroller.ControlPointService;
import org.wildfly.extension.requestcontroller.RequestControllerActivationMarker;

public class EJBComponentSuspendDeploymentUnitProcessor
implements DeploymentUnitProcessor {
    public static final String ENTRY_POINT_NAME = "ejb.";
    static final Set<MethodInterfaceType> INTERFACES = EnumSet.of(MethodInterfaceType.Remote, MethodInterfaceType.Home, MethodInterfaceType.MessageEndpoint);

    public void deploy(DeploymentPhaseContext context) {
        DeploymentUnit deploymentUnit = context.getDeploymentUnit();
        if (!RequestControllerActivationMarker.isRequestControllerEnabled((DeploymentUnit)deploymentUnit)) {
            return;
        }
        final String topLevelName = deploymentUnit.getParent() == null ? deploymentUnit.getName() : deploymentUnit.getParent().getName();
        for (ComponentDescription component : ((EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION)).getComponentDescriptions()) {
            if (!(component instanceof EJBComponentDescription)) continue;
            final String entryPoint = ENTRY_POINT_NAME + deploymentUnit.getName() + "." + component.getComponentName();
            ControlPointService.install((ServiceTarget)context.getServiceTarget(), (String)topLevelName, (String)entryPoint);
            component.getConfigurators().add(new ComponentConfigurator(){

                public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) {
                    EjbSuspendInterceptor interceptor = null;
                    ImmediateInterceptorFactory factory = null;
                    for (ViewConfiguration view : configuration.getViews()) {
                        EJBViewConfiguration ejbView = (EJBViewConfiguration)view;
                        if (!INTERFACES.contains(ejbView.getMethodIntf())) continue;
                        if (factory == null) {
                            interceptor = new EjbSuspendInterceptor();
                            factory = new ImmediateInterceptorFactory((Interceptor)interceptor);
                        }
                        view.addViewInterceptor(factory, 536);
                    }
                    configuration.getCreateDependencies().add(new DependencyConfigurator<EJBComponentCreateService>(){

                        public void configureDependency(ServiceBuilder<?> serviceBuilder, EJBComponentCreateService service) {
                            serviceBuilder.addDependency(ControlPointService.serviceName((String)topLevelName, (String)entryPoint), ControlPoint.class, service.getControlPointInjector());
                        }
                    });
                }
            });
        }
    }
}

