/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;

public final class PathAddressFilter {
    public static final OperationContext.AttachmentKey<PathAddressFilter> KEY = OperationContext.AttachmentKey.create(PathAddressFilter.class);
    private final boolean accept;
    private final Node node = new Node(null);

    public PathAddressFilter(boolean accept) {
        this.accept = accept;
    }

    public boolean accepts(PathAddress address) {
        Iterator i = address.iterator();
        Node node = this.node;
        while (i.hasNext()) {
            PathElement element = (PathElement)i.next();
            Node key = node.children.get(element.getKey());
            if (key == null) {
                return node.accept;
            }
            node = key.children.get(element.getValue());
            if (node == null) {
                node = key.children.get("*");
            }
            if (node == null) {
                return key.accept;
            }
            if (i.hasNext()) continue;
            return node.accept;
        }
        return this.accept;
    }

    public void addReject(PathAddress address) {
        Iterator i = address.iterator();
        Node node = this.node;
        while (i.hasNext()) {
            String elementValue;
            Node value;
            PathElement element = (PathElement)i.next();
            String elementKey = element.getKey();
            Node key = node.children.get(elementKey);
            if (key == null) {
                key = new Node(element.getKey());
                node.children.put(elementKey, key);
            }
            if ((value = key.children.get(elementValue = element.getValue())) == null) {
                value = new Node(elementValue);
                key.children.put(elementValue, value);
            }
            if (i.hasNext()) continue;
            value.accept = false;
        }
    }

    class Node {
        private final String name;
        private final Map<String, Node> children = new HashMap<String, Node>();
        private boolean accept = true;

        Node(String name) {
            this.name = name;
        }
    }
}

