/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Test;

public class AddressSettingsTest
extends ActiveMQTestBase {
    private final SimpleString addressA = new SimpleString("addressA");
    private final SimpleString addressA2 = new SimpleString("add.addressA");
    private final SimpleString addressB = new SimpleString("addressB");
    private final SimpleString addressB2 = new SimpleString("add.addressB");
    private final SimpleString addressC = new SimpleString("addressC");
    private final SimpleString queueA = new SimpleString("queueA");
    private final SimpleString queueB = new SimpleString("queueB");
    private final SimpleString queueC = new SimpleString("queueC");
    private final SimpleString dlaA = new SimpleString("dlaA");
    private final SimpleString dlqA = new SimpleString("dlqA");
    private final SimpleString dlaB = new SimpleString("dlaB");
    private final SimpleString dlqB = new SimpleString("dlqB");
    private final SimpleString dlaC = new SimpleString("dlaC");
    private final SimpleString dlqC = new SimpleString("dlqC");

    @Test
    public void testSimpleHierarchyWithDLA() throws Exception {
        ActiveMQServer server = this.createServer(false);
        server.start();
        AddressSettings addressSettings = new AddressSettings().setDeadLetterAddress(this.dlaA).setMaxDeliveryAttempts(1);
        AddressSettings addressSettings2 = new AddressSettings().setDeadLetterAddress(this.dlaB).setMaxDeliveryAttempts(1);
        HierarchicalRepository repos = server.getAddressSettingsRepository();
        repos.addMatch(this.addressA.toString(), (Object)addressSettings);
        repos.addMatch(this.addressB.toString(), (Object)addressSettings2);
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = sf.createSession(false, true, false);
        session.createQueue(new QueueConfiguration(this.queueA).setAddress(this.addressA).setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(this.queueB).setAddress(this.addressB).setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(this.dlqA).setAddress(this.dlaA).setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(this.dlqB).setAddress(this.dlaB).setDurable(Boolean.valueOf(false)));
        ClientSession sendSession = sf.createSession(false, true, true);
        ClientMessage cm = sendSession.createMessage(true);
        cm.getBodyBuffer().writeString("A");
        ClientMessage cm2 = sendSession.createMessage(true);
        cm2.getBodyBuffer().writeString("B");
        ClientProducer cp1 = sendSession.createProducer(this.addressA);
        ClientProducer cp2 = sendSession.createProducer(this.addressB);
        cp1.send((Message)cm);
        cp2.send((Message)cm2);
        ClientConsumer dlqARec = session.createConsumer(this.dlqA);
        ClientConsumer dlqBrec = session.createConsumer(this.dlqB);
        ClientConsumer cc1 = session.createConsumer(this.queueA);
        ClientConsumer cc2 = session.createConsumer(this.queueB);
        session.start();
        ClientMessage message = cc1.receive(5000L);
        Assert.assertNotNull((Object)message);
        message.acknowledge();
        message = cc2.receive(5000L);
        Assert.assertNotNull((Object)message);
        message.acknowledge();
        session.rollback();
        cc1.close();
        cc2.close();
        message = dlqARec.receive(5000L);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"A", (Object)message.getBodyBuffer().readString());
        message = dlqBrec.receive(5000L);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"B", (Object)message.getBodyBuffer().readString());
        sendSession.close();
        session.close();
    }

    @Test
    public void test2LevelHierarchyWithDLA() throws Exception {
        ActiveMQServer server = this.createServer(false);
        server.start();
        AddressSettings addressSettings = new AddressSettings().setDeadLetterAddress(this.dlaA).setMaxDeliveryAttempts(1);
        AddressSettings addressSettings2 = new AddressSettings().setDeadLetterAddress(this.dlaB).setMaxDeliveryAttempts(1);
        HierarchicalRepository repos = server.getAddressSettingsRepository();
        repos.addMatch(this.addressA.toString(), (Object)addressSettings);
        repos.addMatch("#", (Object)addressSettings2);
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = sf.createSession(false, true, false);
        session.createQueue(new QueueConfiguration(this.queueA).setAddress(this.addressA).setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(this.queueB).setAddress(this.addressB).setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(this.dlqA).setAddress(this.dlaA).setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(this.dlqB).setAddress(this.dlaB).setDurable(Boolean.valueOf(false)));
        ClientSession sendSession = sf.createSession(false, true, true);
        ClientMessage cm = sendSession.createMessage(true);
        cm.getBodyBuffer().writeString("A");
        ClientMessage cm2 = sendSession.createMessage(true);
        cm2.getBodyBuffer().writeString("B");
        ClientProducer cp1 = sendSession.createProducer(this.addressA);
        ClientProducer cp2 = sendSession.createProducer(this.addressB);
        cp1.send((Message)cm);
        cp2.send((Message)cm2);
        ClientConsumer dlqARec = session.createConsumer(this.dlqA);
        ClientConsumer dlqBrec = session.createConsumer(this.dlqB);
        ClientConsumer cc1 = session.createConsumer(this.queueA);
        ClientConsumer cc2 = session.createConsumer(this.queueB);
        session.start();
        ClientMessage message = cc1.receive(5000L);
        Assert.assertNotNull((Object)message);
        message.acknowledge();
        message = cc2.receive(5000L);
        Assert.assertNotNull((Object)message);
        message.acknowledge();
        session.rollback();
        cc1.close();
        cc2.close();
        message = dlqARec.receive(5000L);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"A", (Object)message.getBodyBuffer().readString());
        message = dlqBrec.receive(5000L);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"B", (Object)message.getBodyBuffer().readString());
        sendSession.close();
        session.close();
    }

    @Test
    public void test2LevelWordHierarchyWithDLA() throws Exception {
        ActiveMQServer server = this.createServer(false);
        server.start();
        AddressSettings addressSettings = new AddressSettings().setDeadLetterAddress(this.dlaA).setMaxDeliveryAttempts(1);
        AddressSettings addressSettings2 = new AddressSettings().setDeadLetterAddress(this.dlaB).setMaxDeliveryAttempts(1);
        HierarchicalRepository repos = server.getAddressSettingsRepository();
        repos.addMatch(this.addressA.toString(), (Object)addressSettings);
        repos.addMatch("*", (Object)addressSettings2);
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = sf.createSession(false, true, false);
        session.createQueue(new QueueConfiguration(this.queueA).setAddress(this.addressA).setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(this.queueB).setAddress(this.addressB).setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(this.dlqA).setAddress(this.dlaA).setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(this.dlqB).setAddress(this.dlaB).setDurable(Boolean.valueOf(false)));
        ClientSession sendSession = sf.createSession(false, true, true);
        ClientMessage cm = sendSession.createMessage(true);
        cm.getBodyBuffer().writeString("A");
        ClientMessage cm2 = sendSession.createMessage(true);
        cm2.getBodyBuffer().writeString("B");
        ClientProducer cp1 = sendSession.createProducer(this.addressA);
        ClientProducer cp2 = sendSession.createProducer(this.addressB);
        cp1.send((Message)cm);
        cp2.send((Message)cm2);
        ClientConsumer dlqARec = session.createConsumer(this.dlqA);
        ClientConsumer dlqBrec = session.createConsumer(this.dlqB);
        ClientConsumer cc1 = session.createConsumer(this.queueA);
        ClientConsumer cc2 = session.createConsumer(this.queueB);
        session.start();
        ClientMessage message = cc1.receive(5000L);
        Assert.assertNotNull((Object)message);
        message.acknowledge();
        message = cc2.receive(5000L);
        Assert.assertNotNull((Object)message);
        message.acknowledge();
        session.rollback();
        cc1.close();
        cc2.close();
        message = dlqARec.receive(5000L);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"A", (Object)message.getBodyBuffer().readString());
        message = dlqBrec.receive(5000L);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"B", (Object)message.getBodyBuffer().readString());
        sendSession.close();
        session.close();
    }

    @Test
    public void test3LevelHierarchyWithDLA() throws Exception {
        ActiveMQServer server = this.createServer(false);
        server.start();
        AddressSettings addressSettings = new AddressSettings().setDeadLetterAddress(this.dlaA).setMaxDeliveryAttempts(1);
        AddressSettings addressSettings2 = new AddressSettings().setDeadLetterAddress(this.dlaB).setMaxDeliveryAttempts(1);
        AddressSettings addressSettings3 = new AddressSettings().setDeadLetterAddress(this.dlaC).setMaxDeliveryAttempts(1);
        HierarchicalRepository repos = server.getAddressSettingsRepository();
        repos.addMatch(this.addressA2.toString(), (Object)addressSettings);
        repos.addMatch("add.*", (Object)addressSettings2);
        repos.addMatch("#", (Object)addressSettings3);
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = sf.createSession(false, true, false);
        session.createQueue(new QueueConfiguration(this.queueA).setAddress(this.addressA2).setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(this.queueB).setAddress(this.addressB2).setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(this.queueC).setAddress(this.addressC).setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(this.dlqA).setAddress(this.dlaA).setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(this.dlqB).setAddress(this.dlaB).setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(this.dlqC).setAddress(this.dlaC).setDurable(Boolean.valueOf(false)));
        ClientSession sendSession = sf.createSession(false, true, true);
        ClientMessage cm = sendSession.createMessage(true);
        cm.getBodyBuffer().writeString("A");
        ClientMessage cm2 = sendSession.createMessage(true);
        cm2.getBodyBuffer().writeString("B");
        ClientMessage cm3 = sendSession.createMessage(true);
        cm3.getBodyBuffer().writeString("C");
        ClientProducer cp1 = sendSession.createProducer(this.addressA2);
        ClientProducer cp2 = sendSession.createProducer(this.addressB2);
        ClientProducer cp3 = sendSession.createProducer(this.addressC);
        cp1.send((Message)cm);
        cp2.send((Message)cm2);
        cp3.send((Message)cm3);
        ClientConsumer dlqARec = session.createConsumer(this.dlqA);
        ClientConsumer dlqBrec = session.createConsumer(this.dlqB);
        ClientConsumer dlqCrec = session.createConsumer(this.dlqC);
        ClientConsumer cc1 = session.createConsumer(this.queueA);
        ClientConsumer cc2 = session.createConsumer(this.queueB);
        ClientConsumer cc3 = session.createConsumer(this.queueC);
        session.start();
        ClientMessage message = cc1.receive(5000L);
        Assert.assertNotNull((Object)message);
        message.acknowledge();
        message = cc2.receive(5000L);
        Assert.assertNotNull((Object)message);
        message.acknowledge();
        message = cc3.receive(5000L);
        Assert.assertNotNull((Object)message);
        message.acknowledge();
        session.rollback();
        cc1.close();
        cc2.close();
        cc3.close();
        message = dlqARec.receive(5000L);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"A", (Object)message.getBodyBuffer().readString());
        message = dlqBrec.receive(5000L);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"B", (Object)message.getBodyBuffer().readString());
        message = dlqCrec.receive(5000L);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"C", (Object)message.getBodyBuffer().readString());
        sendSession.close();
        session.close();
    }

    @Test
    public void test3LevelHierarchyPageSizeBytes() throws Exception {
        ActiveMQServer server = this.createServer(true);
        server.start();
        AddressSettings level1 = new AddressSettings().setPageSizeBytes(102400);
        AddressSettings level2 = new AddressSettings();
        AddressSettings level3 = new AddressSettings();
        server.getAddressSettingsRepository().clear();
        server.getAddressSettingsRepository().setDefault(null);
        HierarchicalRepository repos = server.getAddressSettingsRepository();
        repos.addMatch("test.foo.bar", (Object)level3);
        repos.addMatch("test.foo.#", (Object)level2);
        repos.addMatch("test.#", (Object)level1);
        AddressSettingsTest.assertEquals((long)102400L, (long)((AddressSettings)server.getAddressSettingsRepository().getMatch("test.foo.bar")).getPageSizeBytes());
    }

    @Test
    public void testOverrideHierarchyWithDLA() throws Exception {
        ActiveMQServer server = this.createServer(false);
        server.start();
        AddressSettings addressSettings = new AddressSettings().setMaxDeliveryAttempts(1);
        AddressSettings addressSettings2 = new AddressSettings().setMaxDeliveryAttempts(1);
        AddressSettings addressSettings3 = new AddressSettings().setDeadLetterAddress(this.dlaC).setMaxDeliveryAttempts(1);
        HierarchicalRepository repos = server.getAddressSettingsRepository();
        repos.addMatch(this.addressA2.toString(), (Object)addressSettings);
        repos.addMatch("add.*", (Object)addressSettings2);
        repos.addMatch("#", (Object)addressSettings3);
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = sf.createSession(false, true, false);
        session.createQueue(new QueueConfiguration(this.queueA).setAddress(this.addressA2).setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(this.queueB).setAddress(this.addressB2).setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(this.queueC).setAddress(this.addressC).setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(this.dlqA).setAddress(this.dlaA).setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(this.dlqB).setAddress(this.dlaB).setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(this.dlqC).setAddress(this.dlaC).setDurable(Boolean.valueOf(false)));
        ClientSession sendSession = sf.createSession(false, true, true);
        ClientMessage cm = sendSession.createMessage(true);
        ClientMessage cm2 = sendSession.createMessage(true);
        ClientMessage cm3 = sendSession.createMessage(true);
        ClientProducer cp1 = sendSession.createProducer(this.addressA2);
        ClientProducer cp2 = sendSession.createProducer(this.addressB2);
        ClientProducer cp3 = sendSession.createProducer(this.addressC);
        cp1.send((Message)cm);
        cp2.send((Message)cm2);
        cp3.send((Message)cm3);
        ClientConsumer dlqCrec = session.createConsumer(this.dlqC);
        ClientConsumer cc1 = session.createConsumer(this.queueA);
        ClientConsumer cc2 = session.createConsumer(this.queueB);
        ClientConsumer cc3 = session.createConsumer(this.queueC);
        session.start();
        ClientMessage message = cc1.receive(5000L);
        Assert.assertNotNull((Object)message);
        message.acknowledge();
        message = cc2.receive(5000L);
        Assert.assertNotNull((Object)message);
        message.acknowledge();
        message = cc3.receive(5000L);
        Assert.assertNotNull((Object)message);
        message.acknowledge();
        session.rollback();
        cc1.close();
        cc2.close();
        cc3.close();
        message = dlqCrec.receive(5000L);
        Assert.assertNotNull((Object)message);
        message = dlqCrec.receive(5000L);
        Assert.assertNotNull((Object)message);
        message = dlqCrec.receive(5000L);
        Assert.assertNotNull((Object)message);
        sendSession.close();
        session.close();
    }
}

