/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.ra;

import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.BootstrapContext;
import jakarta.resource.spi.UnavailableException;
import jakarta.resource.spi.XATerminator;
import jakarta.resource.spi.endpoint.MessageEndpoint;
import jakarta.resource.spi.endpoint.MessageEndpointFactory;
import jakarta.resource.spi.work.ExecutionContext;
import jakarta.resource.spi.work.Work;
import jakarta.resource.spi.work.WorkContext;
import jakarta.resource.spi.work.WorkException;
import jakarta.resource.spi.work.WorkListener;
import jakarta.resource.spi.work.WorkManager;
import jakarta.transaction.TransactionSynchronizationRegistry;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Timer;
import java.util.concurrent.CountDownLatch;
import javax.transaction.xa.XAResource;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jms.client.ActiveMQMessage;
import org.apache.activemq.artemis.ra.ActiveMQResourceAdapter;
import org.apache.activemq.artemis.ra.inflow.ActiveMQActivation;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.junit.Before;

public abstract class ActiveMQRATestBase
extends JMSTestBase {
    protected ServerLocator locator;
    protected static final String MDBQUEUE = "mdbQueue";
    protected static final String DLQ = "dlqQueue";
    protected static final String MDBQUEUEPREFIXED = "mdbQueue";
    protected static final SimpleString MDBQUEUEPREFIXEDSIMPLE = new SimpleString("mdbQueue");

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.locator = this.createInVMNonHALocator();
        this.createQueue(true, "mdbQueue");
        this.createQueue(DLQ);
        this.setupDLQ(1);
    }

    protected void setupDLQ(int maxDeliveries) {
        AddressSettings settings = new AddressSettings().setDeadLetterAddress(SimpleString.toSimpleString((String)DLQ)).setMaxDeliveryAttempts(maxDeliveries);
        this.server.getAddressSettingsRepository().addMatch("#", (Object)settings);
    }

    protected ActiveMQActivation lookupActivation(ActiveMQResourceAdapter qResourceAdapter) {
        Map activations = qResourceAdapter.getActivations();
        ActiveMQRATestBase.assertEquals((long)1L, (long)activations.size());
        return (ActiveMQActivation)activations.values().iterator().next();
    }

    protected ActiveMQResourceAdapter newResourceAdapter() {
        ActiveMQResourceAdapter qResourceAdapter = new ActiveMQResourceAdapter();
        qResourceAdapter.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        return qResourceAdapter;
    }

    public class MyBootstrapContext
    implements BootstrapContext {
        WorkManager workManager = new DummyWorkManager();

        public Timer createTimer() throws UnavailableException {
            return null;
        }

        public boolean isContextSupported(Class<? extends WorkContext> aClass) {
            return false;
        }

        public TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
            return null;
        }

        public WorkManager getWorkManager() {
            return this.workManager;
        }

        public XATerminator getXATerminator() {
            return null;
        }

        class DummyWorkManager
        implements WorkManager {
            DummyWorkManager() {
            }

            public void doWork(Work work) throws WorkException {
            }

            public void doWork(Work work, long l, ExecutionContext executionContext, WorkListener workListener) throws WorkException {
            }

            public long startWork(Work work) throws WorkException {
                return 0L;
            }

            public long startWork(Work work, long l, ExecutionContext executionContext, WorkListener workListener) throws WorkException {
                return 0L;
            }

            public void scheduleWork(Work work) throws WorkException {
                work.run();
            }

            public void scheduleWork(Work work, long l, ExecutionContext executionContext, WorkListener workListener) throws WorkException {
            }
        }
    }

    protected class DummyMessageEndpoint
    implements MessageEndpoint,
    MessageListener {
        public CountDownLatch latch;
        public ActiveMQMessage lastMessage;
        public boolean released = false;
        public XAResource xaResource;
        volatile boolean inAfterDelivery = false;

        public DummyMessageEndpoint(CountDownLatch latch) {
            this.latch = latch;
        }

        public void beforeDelivery(Method method) throws NoSuchMethodException, ResourceException {
        }

        public void afterDelivery() throws ResourceException {
            if (this.latch != null) {
                this.latch.countDown();
            }
        }

        public void release() {
            this.released = true;
        }

        public void onMessage(Message message) {
            this.lastMessage = (ActiveMQMessage)message;
        }

        public void reset(CountDownLatch latch) {
            this.latch = latch;
            this.lastMessage = null;
        }

        public void setXAResource(XAResource xaResource) {
            this.xaResource = xaResource;
        }
    }

    protected class DummyMessageEndpointFactory
    implements MessageEndpointFactory {
        private DummyMessageEndpoint endpoint;
        private final boolean isDeliveryTransacted;

        public DummyMessageEndpointFactory(DummyMessageEndpoint endpoint, boolean deliveryTransacted) {
            this.endpoint = endpoint;
            this.isDeliveryTransacted = deliveryTransacted;
        }

        public MessageEndpoint createEndpoint(XAResource xaResource) throws UnavailableException {
            if (xaResource != null) {
                this.endpoint.setXAResource(xaResource);
            }
            return this.endpoint;
        }

        public MessageEndpoint createEndpoint(XAResource xaResource, long l) throws UnavailableException {
            return null;
        }

        public boolean isDeliveryTransacted(Method method) throws NoSuchMethodException {
            return this.isDeliveryTransacted;
        }

        public String getActivationName() {
            return null;
        }

        public Class<?> getEndpointClass() {
            return DummyMessageEndpoint.class;
        }
    }
}

