/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.security;

import java.util.Collections;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.ha.DistributedPrimitiveManagerConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationBackupPolicyConfiguration;
import org.apache.activemq.artemis.quorum.file.FileBasedPrimitiveManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQBasicSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTestBase;
import org.apache.activemq.artemis.tests.util.ReplicatedBackupUtils;
import org.apache.activemq.artemis.tests.util.TransportConfigurationUtils;
import org.junit.Assert;
import org.junit.Test;

public class PluggableQuorumBasicSecurityManagerFailoverTest
extends FailoverTestBase {
    @Override
    protected void createConfigs() throws Exception {
        this.createPluggableReplicatedConfigs();
    }

    @Override
    protected void createPluggableReplicatedConfigs() throws Exception {
        TransportConfiguration liveConnector = this.getConnectorTransportConfiguration(true);
        TransportConfiguration backupConnector = this.getConnectorTransportConfiguration(false);
        TransportConfiguration backupAcceptor = this.getAcceptorTransportConfiguration(false);
        this.backupConfig = this.createDefaultInVMConfig();
        this.liveConfig = this.createDefaultInVMConfig();
        DistributedPrimitiveManagerConfiguration managerConfiguration = new DistributedPrimitiveManagerConfiguration(FileBasedPrimitiveManager.class.getName(), Collections.singletonMap("locks-folder", this.temporaryFolder.newFolder("manager").toString()));
        ReplicatedBackupUtils.configurePluggableQuorumReplicationPair(this.backupConfig, backupConnector, backupAcceptor, this.liveConfig, liveConnector, null, managerConfiguration, managerConfiguration);
        this.backupConfig.setSecurityEnabled(true).setBindingsDirectory(this.getBindingsDir(0, true)).setJournalDirectory(this.getJournalDir(0, true)).setPagingDirectory(this.getPageDir(0, true)).setLargeMessagesDirectory(this.getLargeMessagesDir(0, true));
        this.setupHAPolicyConfiguration();
        this.backupNodeManager = this.createReplicatedBackupNodeManager(this.backupConfig);
        this.backupServer = this.createTestableServer(this.backupConfig, this.backupNodeManager);
        this.backupServer.getServer().setSecurityManager((ActiveMQSecurityManager)new ActiveMQBasicSecurityManager());
        this.liveConfig.setSecurityEnabled(true).clearAcceptorConfigurations().addAcceptorConfiguration(this.getAcceptorTransportConfiguration(true));
        this.nodeManager = this.createNodeManager(this.liveConfig);
        this.liveServer = this.createTestableServer(this.liveConfig, this.nodeManager);
        this.liveServer.getServer().setSecurityManager((ActiveMQSecurityManager)new ActiveMQBasicSecurityManager());
    }

    @Override
    protected TransportConfiguration getAcceptorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getInVMAcceptor(live);
    }

    @Override
    protected TransportConfiguration getConnectorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getInVMConnector(live);
    }

    @Override
    protected void setupHAPolicyConfiguration() {
        ((ReplicationBackupPolicyConfiguration)this.backupConfig.getHAPolicyConfiguration()).setMaxSavedReplicatedJournalsSize(2).setAllowFailBack(true);
    }

    @Test
    public void testFailover() throws Exception {
        this.liveServer.getServer().getActiveMQServerControl().addUser("foo", "bar", "baz", false);
        ClientSessionFactory cf = this.createSessionFactory((ServerLocator)this.getServerLocator());
        ClientSession session = null;
        try {
            session = cf.createSession("foo", "bar", false, true, true, false, 0);
        }
        catch (ActiveMQException e) {
            e.printStackTrace();
            Assert.fail((String)"should not throw exception");
        }
        this.crash(session);
        this.waitForServerToStart(this.backupServer.getServer());
        try {
            cf = this.createSessionFactory((ServerLocator)this.getServerLocator());
            session = cf.createSession("foo", "bar", false, true, true, false, 0);
        }
        catch (ActiveMQException e) {
            e.printStackTrace();
            Assert.fail((String)"should not throw exception");
        }
    }
}

