/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.stomp.v11;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import org.apache.activemq.artemis.tests.integration.stomp.StompTestBase;
import org.apache.activemq.artemis.tests.integration.stomp.util.ClientStompFrame;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnection;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnectionFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ExtraStompTest
extends StompTestBase {
    private StompClientConnection connV10;
    private StompClientConnection connV11;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"ws+v11.stomp"}, {"tcp+v11.stomp"});
    }

    @Override
    public boolean isPersistenceEnabled() {
        return true;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        URI v10Uri = new URI(this.uri.toString().replace("v11", "v10"));
        this.connV10 = StompClientConnectionFactory.createClientConnection(v10Uri);
        this.connV10.connect(this.defUser, this.defPass);
        this.connV11 = StompClientConnectionFactory.createClientConnection(this.uri);
        this.connV11.connect(this.defUser, this.defPass);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        try {
            this.connV10.disconnect();
            this.connV11.disconnect();
        }
        finally {
            super.tearDown();
        }
    }

    @Test
    public void testSendAndReceive10() throws Exception {
        this.testSendAndReceive(this.connV10);
    }

    @Test
    public void testSendAndReceive11() throws Exception {
        this.testSendAndReceive(this.connV11);
    }

    public void testSendAndReceive(StompClientConnection conn) throws Exception {
        String msg1 = "Hello World 1!";
        String msg2 = "Hello World 2!";
        ClientStompFrame frame = conn.createFrame("SEND");
        frame.addHeader("destination", ExtraStompTest.getQueuePrefix() + ExtraStompTest.getQueueName());
        frame.addHeader("content-length", String.valueOf(msg1.getBytes(StandardCharsets.UTF_8).length));
        frame.addHeader("persistent", Boolean.TRUE.toString());
        frame.setBody(msg1);
        conn.sendFrame(frame);
        ClientStompFrame frame2 = conn.createFrame("SEND");
        frame2.addHeader("destination", ExtraStompTest.getQueuePrefix() + ExtraStompTest.getQueueName());
        frame2.addHeader("content-length", String.valueOf(msg2.getBytes(StandardCharsets.UTF_8).length));
        frame2.addHeader("persistent", Boolean.TRUE.toString());
        frame2.setBody(msg2);
        conn.sendFrame(frame2);
        ExtraStompTest.subscribe(conn, "a-sub");
        frame = conn.receiveFrame();
        ExtraStompTest.assertEquals((Object)"MESSAGE", (Object)frame.getCommand());
        ExtraStompTest.assertEquals((Object)"a-sub", (Object)frame.getHeader("subscription"));
        ExtraStompTest.assertNotNull((Object)frame.getHeader("message-id"));
        ExtraStompTest.assertEquals((Object)(ExtraStompTest.getQueuePrefix() + ExtraStompTest.getQueueName()), (Object)frame.getHeader("destination"));
        ExtraStompTest.assertEquals((Object)msg1, (Object)frame.getBody());
        frame = conn.receiveFrame();
        ExtraStompTest.assertEquals((Object)"MESSAGE", (Object)frame.getCommand());
        ExtraStompTest.assertEquals((Object)"a-sub", (Object)frame.getHeader("subscription"));
        ExtraStompTest.assertNotNull((Object)frame.getHeader("message-id"));
        ExtraStompTest.assertEquals((Object)(ExtraStompTest.getQueuePrefix() + ExtraStompTest.getQueueName()), (Object)frame.getHeader("destination"));
        ExtraStompTest.assertEquals((Object)msg2, (Object)frame.getBody());
        ExtraStompTest.unsubscribe(conn, "a-sub");
    }

    @Test
    public void testNoGarbageAfterPersistentMessageV10() throws Exception {
        this.testNoGarbageAfterPersistentMessage(this.connV10);
    }

    @Test
    public void testNoGarbageAfterPersistentMessageV11() throws Exception {
        this.testNoGarbageAfterPersistentMessage(this.connV11);
    }

    public void testNoGarbageAfterPersistentMessage(StompClientConnection conn) throws Exception {
        ExtraStompTest.subscribe(conn, "a-sub");
        ClientStompFrame frame = conn.createFrame("SEND");
        frame.addHeader("destination", ExtraStompTest.getQueuePrefix() + ExtraStompTest.getQueueName());
        frame.addHeader("content-length", "11");
        frame.addHeader("persistent", Boolean.TRUE.toString());
        frame.setBody("Hello World");
        conn.sendFrame(frame);
        frame = conn.createFrame("SEND");
        frame.addHeader("destination", ExtraStompTest.getQueuePrefix() + ExtraStompTest.getQueueName());
        frame.addHeader("content-length", "11");
        frame.addHeader("persistent", Boolean.TRUE.toString());
        frame.setBody("Hello World");
        conn.sendFrame(frame);
        frame = conn.receiveFrame(10000L);
        ExtraStompTest.assertEquals((Object)"Hello World", (Object)frame.getBody());
        frame = conn.receiveFrame(10000L);
        ExtraStompTest.assertEquals((Object)"Hello World", (Object)frame.getBody());
        ExtraStompTest.unsubscribe(conn, "a-sub");
    }

    @Test
    public void testNoGarbageOnPersistentRedeliveryV10() throws Exception {
        this.testNoGarbageOnPersistentRedelivery(this.connV10);
    }

    @Test
    public void testNoGarbageOnPersistentRedeliveryV11() throws Exception {
        this.testNoGarbageOnPersistentRedelivery(this.connV11);
    }

    public void testNoGarbageOnPersistentRedelivery(StompClientConnection conn) throws Exception {
        ClientStompFrame frame = conn.createFrame("SEND");
        frame.addHeader("destination", ExtraStompTest.getQueuePrefix() + ExtraStompTest.getQueueName());
        frame.addHeader("content-length", "11");
        frame.addHeader("persistent", Boolean.TRUE.toString());
        frame.setBody("Hello World");
        conn.sendFrame(frame);
        frame = conn.createFrame("SEND");
        frame.addHeader("destination", ExtraStompTest.getQueuePrefix() + ExtraStompTest.getQueueName());
        frame.addHeader("content-length", "11");
        frame.addHeader("persistent", Boolean.TRUE.toString());
        frame.setBody("Hello World");
        conn.sendFrame(frame);
        frame = ExtraStompTest.subscribe(conn, "a-sub", "client");
        frame = conn.receiveFrame(10000L);
        this.instanceLog.debug((Object)frame);
        frame = conn.receiveFrame(10000L);
        this.instanceLog.debug((Object)frame);
        ExtraStompTest.unsubscribe(conn, "a-sub");
        frame = ExtraStompTest.subscribe(conn, "a-sub");
        frame = conn.receiveFrame(10000L);
        ExtraStompTest.assertEquals((Object)"Hello World", (Object)frame.getBody());
        ExtraStompTest.unsubscribe(conn, "a-sub");
    }
}

